-- ****************************************************************************
-- insertion d'un échantillon de la base sirene pour démonstration géocodage
-- ****************************************************************************

DROP TABLE IF EXISTS etablissement_sirene;
CREATE TABLE etablissement_sirene (
    siren varchar,
    nic varchar,
    siret varchar,
    numerovoieetablissement varchar,
    indicerepetitionetablissement varchar,
    typevoieetablissement varchar,
    libellevoieetablissement varchar,
    codepostaletablissement varchar,
    libellecommuneetablissement varchar
);

INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('320842669', '00014', '32084266900014', NULL, NULL, 'RUE', 'DU COMMANDANT A MEZERGUES', '30190', 'SAINT-CHAPTES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379549041', '00018', '37954904100018', '49', NULL, 'RUE', 'SALOMON REINACH', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('316589761', '00055', '31658976100055', '6', NULL, 'RUE', 'VICTOR HUGO', '30129', 'MANDUEL');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('317799435', '00019', '31779943500019', NULL, NULL, 'BD', 'DES BOULEVARDS', '30190', 'SAINT-GENIES-DE-MALGOIRES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('377490602', '00010', '37749060200010', '31', NULL, 'RUE', 'MENARD', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('326855665', '00021', '32685566500021', NULL, NULL, 'RTE', 'DE BEAUCAIRE', '30129', 'MANDUEL');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('918608613', '00017', '91860861300017', '3', NULL, 'IMP', 'DU LUXEMBOURG', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('390036820', '00020', '39003682000020', '1', NULL, NULL, 'PLAN DES COULICOUS', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379817760', '00018', '37981776000018', '524', NULL, 'RUE', 'ROBERT SCHUMAN', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('343017042', '00015', '34301704200015', '1', NULL, 'PL', 'COROT', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('328223185', '00047', '32822318500047', '6', NULL, 'RUE', 'DU CHAPITRE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('348387705', '00018', '34838770500018', NULL, NULL, 'LOT', 'LA COLLINE 2', '30980', 'SAINT-DIONISY');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('339733552', '00030', '33973355200030', '125', NULL, 'RUE', 'DE L HOSTELLERIE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('348104845', '00030', '34810484500030', '3', NULL, 'CHE', 'DE LA COMBE', '30320', 'SAINT-GERVASY');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('378538128', '00018', '37853812800018', NULL, NULL, 'AV', 'DE BIR HAKEIM', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('331687541', '00028', '33168754100028', '51', 'B', 'BD', 'TALABOT', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('322479841', '00015', '32247984100015', '37', NULL, 'RUE', 'FRESQUE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('331957621', '00021', '33195762100021', '4', NULL, 'PL', 'QUESTEL', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('325618486', '00014', '32561848600014', NULL, NULL, 'CHE', 'DES COMBES', '30980', 'LANGLADE');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('341048684', '00037', '34104868400037', '23', NULL, 'AV', 'GEORGES POMPIDOU', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('253001333', '00025', '25300133300025', NULL, NULL, 'CHE', 'DE BERNIS', '30820', 'CAVEIRAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('310407044', '00026', '31040704400026', '6', NULL, 'RUE', 'DES CIGALOUNS', '30128', 'GARONS');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('331506402', '00022', '33150640200022', '31', NULL, 'RUE', 'RANGUEIL', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379590524', '00011', '37959052400011', '18', NULL, 'PL', 'AVOGADRO', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('323130815', '00018', '32313081500018', '278', NULL, 'RTE', 'D''AVIGNON', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('306723347', '00028', '30672334700028', '14', NULL, 'RUE', 'ANTOINE DELON', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('384028163', '00069', '38402816300069', '4', NULL, 'PL', 'EMILE ZOLA', '30800', 'SAINT-GILLES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('343665808', '00022', '34366580800022', '2', NULL, 'CHE', 'DE SAINT CHAPTES', '30190', 'LA CALMETTE');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('382094795', '00012', '38209479500012', '6', NULL, 'AV', 'FRANKLIN ROOSEVELT', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('383115300', '00014', '38311530000014', '30', NULL, 'RUE', 'RICHELIEU', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('382518330', '00016', '38251833000016', '76', 'T', 'AV', 'JEAN JAURES', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('350396792', '00011', '35039679200011', NULL, NULL, NULL, 'LDT L ESTRADE', '30870', 'SAINT-COME-ET-MARUEJOLS');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('327404836', '00063', '32740483600063', '11', NULL, 'RUE', 'DU PUITS SALIENS', '30800', 'SAINT-GILLES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379289614', '00024', '37928961400024', '400', NULL, 'AV', 'DU DOCTEUR CLAUDE BAILLET', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('381304716', '00016', '38130471600016', NULL, NULL, NULL, 'ZAC EURO 2000', '30132', 'CAISSARGUES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('382249910', '00029', '38224991000029', '3', NULL, 'RUE', 'FRESQUE', '30129', 'REDESSAN');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('054806542', '04915', '05480654204915', NULL, NULL, 'RUE', 'CORNEILLE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('389490806', '00020', '38949080600020', NULL, NULL, 'RUE', 'DE LA BAUME', '30800', 'SAINT-GILLES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('392893194', '00010', '39289319400010', '6', NULL, 'RUE', 'THOUMAYNE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('351712070', '00017', '35171207000017', '1019', NULL, 'RTE', 'DE COURBESSAC', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('345279152', '00010', '34527915200010', '29', NULL, 'RUE', 'PORTE D ALES', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('325657898', '00020', '32565789800020', '5', NULL, 'RUE', 'DU VACCARES', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('334257318', '00025', '33425731800025', '22', NULL, 'RUE', 'CLERISSEAU', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('390504512', '00042', '39050451200042', '10', NULL, 'PL', 'GALILEE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('353335581', '00073', '35333558100073', '111', NULL, 'IMP', 'DU DOUBS', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('323728303', '00054', '32372830300054', '12', NULL, 'RUE', 'RUFFI', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('314513276', '00019', '31451327600019', '39', 'B', 'RUE', 'DES BONS ENFANTS', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('318222254', '00027', '31822225400027', '2', NULL, 'RUE', 'EMILE BILHAU', '30510', 'GENERAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('312204514', '00045', '31220451400045', '53', NULL, 'RUE', 'SEGUIER', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('343010153', '00025', '34301015300025', '16', NULL, 'RUE', 'GRETRY', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('391671708', '00389', '39167170800389', NULL, NULL, 'RUE', 'DU 19 MARS 1962', '30800', 'SAINT-GILLES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('340250851', '00011', '34025085100011', '970', NULL, 'CHE', 'DE LA PLANETTE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('323096818', '00030', '32309681800030', '83', NULL, 'RUE', 'D ORAN', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('378385686', '00027', '37838568600027', '2', NULL, 'PL', 'RAPHAEL', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('380337139', '00022', '38033713900022', '19', NULL, 'RUE', 'MARQUIS DE SURVILLE', '30510', 'GENERAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('500556667', '00037', '50055666700037', '92', NULL, 'PL', 'LOU REGANEL', '30132', 'CAISSARGUES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('333747723', '00042', '33374772300042', '1', NULL, 'PL', 'DES ARENES', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379852973', '00013', '37985297300013', NULL, NULL, 'RUE', 'SALOMON REINACH', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('312607690', '00020', '31260769000020', '11', 'B', 'RUE', 'NATIONALE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('345015069', '00015', '34501506900015', NULL, NULL, NULL, 'MAS PASCALY', '30129', 'REDESSAN');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('325169548', '00022', '32516954800022', NULL, NULL, NULL, 'CAMP ROSIER', '30190', 'SAINTE-ANASTASIE');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('380512152', '00014', '38051215200014', '72', NULL, 'RTE', 'DE MONTPELLIER', '30540', 'MILHAUD');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('381910322', '00019', '38191032200019', '52', 'B', 'AV', 'JEAN JAURES', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('389654146', '00015', '38965414600015', NULL, NULL, NULL, 'MARCHE GARE ST CESAIRE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('378572390', '00029', '37857239000029', '22', NULL, 'RUE', 'MARESCHAL', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('343652624', '00010', '34365262400010', '10', NULL, 'RUE', 'VINCENT FAITA', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('391052107', '00011', '39105210700011', '4', NULL, 'AV', 'GENERAL LECLERC', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('348996059', '00500', '34899605900500', NULL, NULL, 'CHE', 'DU MAS DE VIGNOLLES', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('326743119', '00033', '32674311900033', '9', NULL, 'RUE', 'CLAUDE BERNARD', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('383595873', '00019', '38359587300019', '12', NULL, 'CHE', 'DES DERONDS', '30870', 'CLARENSAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('353580723', '00016', '35358072300016', '9', NULL, 'RUE', 'DEPARCIEUX', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('338142847', '00023', '33814284700023', '146', NULL, 'ALL', 'JACQUES CARTIER', '30320', 'MARGUERITTES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('775688732', '11225', '77568873211225', '125', NULL, 'RUE', 'DE L HOSTELLERIE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('380841379', '00015', '38084137900015', '97', NULL, 'RUE', 'GRIEG', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('352422547', '00021', '35242254700021', '56', NULL, 'AV', 'GENERAL LECLERC', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('312697212', '00040', '31269721200040', NULL, NULL, 'RTE', 'DE NIMES', '30730', 'SAINT-MAMERT-DU-GARD');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('263002214', '00017', '26300221400017', NULL, NULL, NULL, 'MAIRIE', '30870', 'CLARENSAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('332447002', '00012', '33244700200012', '52', NULL, 'RUE', 'BACHALAS', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('880509617', '00028', '88050961700028', '13', NULL, 'RUE', 'DE LA COMTESSE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('337658959', '00016', '33765895900016', '16', NULL, 'RUE', 'DELON SOUBEYRAN', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('392878468', '00025', '39287846800025', '45', NULL, 'AV', 'DU CHEMIN NEUF', '30820', 'CAVEIRAC');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('317966414', '00037', '31796641400037', '13', NULL, 'RUE', 'DU MAIL II', '30129', 'MANDUEL');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('382325967', '00018', '38232596700018', '2', NULL, 'PL', 'ARCHIMEDE', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379952781', '00019', '37995278100019', NULL, NULL, 'AV', 'DE LATTRE DE TASSIGNY', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('383669108', '00011', '38366910800011', '23', NULL, 'RUE', 'DHUODA', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('305555955', '00015', '30555595500015', '5', NULL, 'RUE', 'DES CEDRES', '30540', 'MILHAUD');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('341705630', '00026', '34170563000026', '57', NULL, NULL, 'GALERIE GEORGE SAND', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('383080371', '00024', '38308037100024', NULL, NULL, 'AV', 'DES ECOLES', '30190', 'SAINT-GENIES-DE-MALGOIRES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('348906249', '00076', '34890624900076', '6', NULL, 'RUE', 'DE L AQUEDUC', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('381819663', '00026', '38181966300026', NULL, NULL, 'PL', 'DE L HOTEL DE VILLE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('339109977', '00019', '33910997700019', '2', NULL, 'PL', 'DE L HORLOGE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('384970786', '02319', '38497078602319', '22', NULL, 'BD', 'GAMBETTA', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('351993985', '00016', '35199398500016', NULL, NULL, 'CHE', 'DE LA CARIERASSE', '30132', 'CAISSARGUES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('381248475', '00026', '38124847500026', '1', NULL, 'PL', 'FREDERIC MISTRAL', '30540', 'MILHAUD');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('351539002', '00011', '35153900200011', '25', NULL, 'RUE', 'PIERRE CURIE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('318586831', '00030', '31858683100030', '19', 'B', 'RUE', 'FENELON', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('330074154', '00031', '33007415400031', '2601', NULL, 'RTE', 'DE MONTPELLIER', '30900', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('383746435', '00015', '38374643500015', '5', NULL, 'BD', 'DE PRAGUE', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('379777030', '00022', '37977703000022', '3', NULL, 'IMP', 'JEAN BOUIN', '30000', 'NIMES');
INSERT INTO etablissement_sirene (siren, nic, siret, numerovoieetablissement, indicerepetitionetablissement, typevoieetablissement, libellevoieetablissement, codepostaletablissement, libellecommuneetablissement) VALUES ('306667379', '00029', '30666737900029', '350', NULL, 'IMP', 'DES LISERONS', '30000', 'NIMES');

-- ****************************************************************************
-- insertion des bâtiments de la commune de Générac pour démonstration plus
-- proche voisin
-- ****************************************************************************
DROP TABLE IF EXISTS batiment;
CREATE TABLE batiment (
    geom public.geometry(MultiPolygonZ,2154),
    cleabs character varying(24),
    nature character varying,
    usage_1 character varying,
    usage_2 character varying,
    construction_legere boolean,
    etat_de_l_objet character varying,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    date_d_apparition date,
    date_de_confirmation date,
    sources character varying,
    identifiants_sources character varying,
    methode_d_acquisition_planimetrique character varying,
    precision_planimetrique numeric(5,1),
    methode_d_acquisition_altimetrique character varying,
    precision_altimetrique numeric(5,1),
    nombre_de_logements integer,
    nombre_d_etages integer,
    materiaux_des_murs character varying(2),
    materiaux_de_la_toiture character varying(2),
    hauteur numeric(7,1),
    altitude_minimale_sol numeric(7,1),
    altitude_minimale_toit numeric(7,1),
    altitude_maximale_toit numeric(7,1),
    altitude_maximale_sol numeric(7,1),
    origine_du_batiment character varying,
    appariement_fichiers_fonciers character varying(32)
);

INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000011000000333333338CAA2841000000E0AD01584100000000006052400000000086AA2841333333F3AE0158419A999999995952403333333381AA284133333313B5015841CDCCCCCCCC4C5240000000008BAA284133333313B7015841666666666646524000000000B3AA2841333333F3B70158419A9999999939524000000000BFAA2841CDCCCC2CB60158419A9999999939524000000000C5AA28419A999959AF015841CDCCCCCCCC4C524066666666B8AA284100000040AD0158419A99999999595240CDCCCCCCB5AA2841CDCCCC2CAE015841333333333353524033333333BFAA2841000000C0AF015841CDCCCCCCCC4C524000000000BBAA284133333373B5015841000000000040524033333333B0AA28419A999939B70158419A999999993952409A9999998EAA28419A999979B60158416666666666465240CDCCCCCC86AA2841000000E0B4015841CDCCCCCCCC4C5240333333338AAA284100000060AF0158419A99999999595240333333338FAA2841333333B3AE0158419A99999999595240333333338CAA2841000000E0AD0158410000000000605240', 'BATIMENT0000000357670281', 'Arène ou théâtre antique', 'Indifférencié', NULL, false, 'En service', '2016-06-10 15:22:50.421+02', '2020-11-10 15:15:19.943+01', NULL, '2018-07-23', NULL, NULL, 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.1, 71.4, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC5DA72841CDCCCCCCE8025841CDCCCCCCCC4C4F4000000000F2A62841666666E6020358413333333333F34E4033333333CEA62841CDCCCCAC000358413333333333734E40666666663AA72841CDCCCC8CE6025841CDCCCCCCCC0C4F40CDCCCCCC5DA72841CDCCCCCCE8025841CDCCCCCCCC4C4F40', 'BATIMENT0000000357803204', 'Serre', 'Agricole', NULL, false, 'En service', '2016-06-30 17:09:04.829+02', NULL, NULL, '2015-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.9, 58.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000006666666618B028419A999999500158410000000000C057403333333311B028419A999999500158410000000000C057400000000011B028419A9999D9510158410000000000C057403333333311B028419A999959520158410000000000C05740CDCCCCCC17B028419A999959520158410000000000C057409A99999918B028419A999959520158410000000000C057406666666619B028419A9999B9500158410000000000C057406666666619B028419A999999500158410000000000C057406666666618B028419A999999500158410000000000C05740', 'BATIMENT0000000314347074', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 92.0, 95.0, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333394B22841CDCCCCEC7101584133333333335359409A99999999B22841CDCCCCEC72015841333333333353594000000000A8B22841000000E071015841333333333353594033333333A2B22841333333D3700158413333333333535940666666669FB22841CDCCCC4C7001584133333333335359409A99999991B22841333333737101584133333333335359403333333394B22841CDCCCCEC710158413333333333535940', 'BATIMENT0000000314341226', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 95.4, 101.3, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333367AE2841333333D3030258419A99999999B95540CDCCCCCC66AE2841333333F3030258419A99999999B955400000000077AE284133333373040258419A99999999B955406666666677AE2841333333D3030258419A99999999B955406666666677AE284100000080030258419A99999999B955409A99999968AE28419A999939030258419A99999999B955403333333367AE2841333333D3030258419A99999999B95540', 'BATIMENT0000000314348755', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.1, 80.8, 86.9, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000066666666E3A928416666666681035841666666666666504066666666DEA92841666666868103584166666666666650409A999999E3A92841CDCCCC4C840358416666666666665040CDCCCCCCE5A92841000000408403584166666666666650409A999999EEA92841CDCCCCEC83035841666666666666504000000000E8A928416666664681035841666666666666504066666666E3A9284166666666810358416666666666665040', 'BATIMENT0000000314340950', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:10:48.171+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.1, 59.5, 65.6, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCCDB02841333333332F0258410000000000E056409A999999C1B02841000000E02B0258410000000000E0564033333333B2B02841000000C02C0258410000000000E0564033333333BFB0284166666646300258410000000000E0564000000000C4B028419A999999310258410000000000E056409A999999D2B028419A9999D9300258410000000000E05640CDCCCCCCCDB02841333333332F0258410000000000E05640', 'BATIMENT0000000027743696', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 6.3, 85.2, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666667CB428416666664643035841CDCCCCCCCC2C51406666666667B42841000000804A035841CDCCCCCCCC2C5140333333337BB42841000000804B035841CDCCCCCCCC2C51409A99999991B42841CDCCCC8C44035841CDCCCCCCCC2C51400000000098B428413333333342035841CDCCCCCCCC2C51403333333385B428413333333341035841CDCCCCCCCC2C5140666666667CB428416666664643035841CDCCCCCCCC2C5140', 'BATIMENT0000000027742006', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 8.7, 59.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000009A9999998DAA28419A999939AE0158419A99999999995240333333338FAA2841333333B3AE0158419A999999999952409A999999A2AA284133333333AE0158419A99999999995240CDCCCCCCA1AA284100000060AD0158419A99999999995240000000009FAA284133333393AC0158419A99999999995240CDCCCCCC90AA284100000080AD0158419A999999999952400000000090AA284100000040AD0158419A99999999995240333333338EAA284166666666AD0158419A99999999995240333333338BAA28419A999999AD0158419A999999999952409A9999998DAA28419A999939AE0158419A99999999995240', 'BATIMENT0000000314349772', 'Arène ou théâtre antique', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2019-03-15 19:18:06.773+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.4, 73.0, 74.4, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000D7B728419A9999B90B0458416666666666E652409A999999E7B72841000000800B0458416666666666E6524033333333E4B72841333333F3090458416666666666E652409A999999D5B72841000000600A0458416666666666E6524000000000D7B728419A9999B90B0458416666666666E65240', 'BATIMENT0000000027740705', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2012-10-19 08:00:31.396+02', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.7, 72.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999998DBA2841666666E654FF57419A99999999D953409A999999B1BA2841666666A655FF57419A99999999F95340CDCCCCCCADBA28419A99999957FF574166666666660654409A9999998ABA2841CDCCCC2C57FF574166666666660654409A9999998DBA2841666666E654FF57419A99999999D95340', 'BATIMENT0000000027749959', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.7, 77.4, NULL, 81.5, 77.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666663DBA2841666666E652FF57410000000000E05440000000003BBA28419A9999F955FF57410000000000E054409A9999992FBA28419A9999D955FF57410000000000E054400000000032BA2841000000C052FF57410000000000E05440666666663DBA2841666666E652FF57410000000000E05440', 'BATIMENT0000000314331671', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:18.106+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 80.5, 83.5, 88.1, 82.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333332CB628419A9999B9C2FE57413333333333D35540000000003AB62841CDCCCC2CC4FE57413333333333D355409A99999941B62841333333B3C2FE57413333333333D355409A99999934B62841CDCCCC4CC1FE57413333333333D35540333333332CB628419A9999B9C2FE57413333333333D35540', 'BATIMENT0000000206309690', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2008-09-25 16:47:29.261+02', '2017-01-31 21:26:19.973+01', NULL, '2006-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.9, 83.4, NULL, 88.3, 83.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666666CC028413333337331FF57416666666666865440CDCCCCCC72C028416666666631FF57416666666666865440333333336FC02841CDCCCC2C30FF57416666666666865440CDCCCCCC69C028416666666630FF57416666666666865440666666666CC028413333337331FF57416666666666865440', 'BATIMENT0000000027749953', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2012-10-19 08:03:23.275+02', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 1.0, 81.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000DEC22841CDCCCCECD6FE5741CDCCCCCCCC0C4E4000000000B1C22841333333D3D2FE5741CDCCCCCCCC0C4E4033333333A0C228419A9999B9D5FE5741CDCCCCCCCC0C4E409A999999CDC22841666666C6D9FE5741CDCCCCCCCC0C4E4000000000DEC22841CDCCCCECD6FE5741CDCCCCCCCC0C4E40', 'BATIMENT0000000314331681', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:23.275+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.6, 54.6, 60.1, 60.5, 55.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666683BB2841CDCCCCEC69FF5741333333333313544066666666A5BB28416666668666FF5741333333333313544000000000B8BB28419A99991969FF57413333333333135440CDCCCCCC96BB2841333333736CFF574133333333331354406666666683BB2841CDCCCCEC69FF57413333333333135440', 'BATIMENT0000000314331674', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:18.106+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.6, 78.7, 80.3, 80.9, 79.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666665FB1284100000060160158410000000000408FC06666666666B1284166666606170158410000000000408FC06666666660B1284100000000180158410000000000408FC00000000058B1284133333353170158410000000000408FC0666666665FB1284100000060160158410000000000408FC0', 'BATIMENT0000000314341256', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 120.8, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333338BAA2841666666C6010358416666666666C651400000000086AA28419A999999010358416666666666C65140333333338BAA2841666666A6FF0258416666666666C65140CDCCCCCC8FAA2841333333D3FF0258416666666666C65140333333338BAA2841666666C6010358416666666666C65140', 'BATIMENT0000000314340977', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.3, 62.8, 71.1, 72.3, 64.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000034AE284133333313B90258419A99999999795240CDCCCCCC40AE284133333313BA0258419A999999997952403333333345AE284100000040B902584100000000004052400000000038AE284100000040B8025841CDCCCCCCCC4C52400000000034AE284133333313B90258419A99999999795240', 'BATIMENT0000000027742027', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2012-10-19 08:10:56.738+02', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 3.1, 70.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999925AA28419A999959EC02584133333333333350409A99999925AA2841000000A0EB0258413333333333335040666666662CAA284166666686EB02584133333333333350409A9999992CAA284100000040EC0258413333333333335040333333332BAA284100000040EC02584133333333333350409A99999925AA28419A999959EC0258413333333333335040', 'BATIMENT0000000314340996', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 60.0, 64.8, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000EFA92841333333D3B10258419A9999999939504066666666ECA9284100000040B30258419A999999993950409A999999D9A9284133333353B20258419A999999993950409A999999DCA928419A9999F9B00258419A9999999939504000000000EFA92841333333D3B10258419A99999999395040', 'BATIMENT0000000314340981', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.4, 62.5, 64.9, 65.5, 62.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC21AA284133333373200358410000000000404E400000000017AA284166666606200358410000000000404E400000000014AA28419A999939210358410000000000404E409A99999918AA284166666666210358410000000000404E406666666615AA28419A999999220358410000000000404E409A9999991BAA28419A9999D9220358410000000000404E40CDCCCCCC21AA284133333373200358410000000000404E40', 'BATIMENT0000000314341012', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 56.3, 60.5, 61.7, 56.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000006666666633AB2841CDCCCCAC960258413333333333B35240666666662EAB28419A999919960258413333333333B352406666666625AB2841CDCCCC6C960258413333333333B352400000000020AB2841CDCCCC6C970258413333333333B352409A9999991CAB28419A999919970258413333333333B35240333333332AAB28419A9999D9940258413333333333B35240CDCCCCCC36AB28419A999919960258413333333333B352406666666633AB2841CDCCCCAC960258413333333333B35240', 'BATIMENT0000000314341007', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 69.7, 74.8, 74.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333378A92841666666C6AD0258410000000000408FC0000000007DA9284100000000AE0258410000000000408FC0333333337BA928419A999979AE0258410000000000408FC03333333378A928419A999959AE0258410000000000408FC03333333378A92841666666C6AD0258410000000000408FC0', 'BATIMENT0000000314341033', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 62.4, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000003CAC28419A9999B9E90258410000000000408FC0666666663DAC284133333313E90258410000000000408FC00000000043AC2841CDCCCC2CE90258410000000000408FC00000000042AC2841000000E0E90258410000000000408FC0000000003CAC28419A9999B9E90258410000000000408FC0', 'BATIMENT0000000314341036', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 64.7, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666666AA28419A9999794B0358410000000000408FC0CDCCCCCC6DAA2841666666464B0358410000000000408FC09A9999996EAA2841333333D34B0358410000000000408FC03333333367AA2841000000004C0358410000000000408FC06666666666AA28419A9999794B0358410000000000408FC0', 'BATIMENT0000000314341038', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 63.1, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333338AB2284100000080540158413333333333F359400000000086B22841000000E0540158413333333333F35940CDCCCCCC7AB228419A9999B9520158413333333333F35940000000007FB2284166666666520158413333333333F35940333333338AB2284100000080540158413333333333F35940', 'BATIMENT0000000314341123', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.5, 100.3, 103.8, 105.5, 101.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000025B228419A9999395F0158416666666666865A40CDCCCCCC11B2284133333333600158416666666666865A40CDCCCCCC0FB22841CDCCCC8C5F0158416666666666865A403333333323B22841000000A05E0158416666666666865A400000000025B228419A9999395F0158416666666666865A40', 'BATIMENT0000000314341127', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 101.3, 106.1, 106.7, 101.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666652B22841CDCCCC6C7901584133333333331359403333333341B228419A9999797901584133333333331359400000000041B22841666666E67801584133333333331359406666666652B22841CDCCCCCC7801584133333333331359406666666652B22841CDCCCC6C790158413333333333135940', 'BATIMENT0000000314341154', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 96.2, 100.3, 101.5, 97.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000800000000000000FCB22841333333F3070158410000000000408FC0CDCCCCCCEFB2284166666666070158410000000000408FC000000000EFB22841333333B3070158410000000000408FC000000000D5B22841333333B3060158410000000000408FC09A999999D7B22841000000E0050158410000000000408FC000000000FDB2284133333353070158419A99999999195C409A999999FDB228419A999959070158410000000000408FC000000000FCB22841333333F3070158410000000000408FC0', 'BATIMENT0000000314341175', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 111.3, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666B6B12841000000803D0158413333333333D35C40CDCCCCCCB5B12841000000803C0158413333333333D35C40CDCCCCCCBDB12841000000803C0158413333333333D35C40CDCCCCCCBDB12841000000803D0158413333333333D35C4066666666B6B12841000000803D0158413333333333D35C40', 'BATIMENT0000000314341179', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.4, 110.9, 115.3, 117.8, 112.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000800000033333333D1B12841CDCCCCECF7005841CDCCCCCCCC2C5E4033333333C9B1284133333393F9005841CDCCCCCCCC2C5E40CDCCCCCCBAB1284100000040F8005841CDCCCCCCCC2C5E40CDCCCCCCBCB12841333333D3F7005841CDCCCCCCCC2C5E40CDCCCCCCBDB12841CDCCCCECF7005841CDCCCCCCCC2C5E4066666666C7B12841666666C6F8005841CDCCCCCCCC2C5E40CDCCCCCCCDB12841000000A0F7005841CDCCCCCCCC2C5E4033333333D1B12841CDCCCCECF7005841CDCCCCCCCC2C5E40', 'BATIMENT0000000314341195', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.4, 117.3, 120.7, 121.5, 117.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000006666666680B0284133333373C60058416666666666065A40333333338FB02841CDCCCC6CC60058416666666666065A40000000008FB0284133333373C80058416666666666065A40CDCCCCCC92B0284133333373C80058416666666666065A406666666692B0284133333393C90058416666666666065A409A9999997BB02841CDCCCC8CC90058416666666666065A40CDCCCCCC7BB02841666666A6C70058416666666666065A400000000080B02841666666A6C70058416666666666065A406666666680B0284133333373C60058416666666666065A40', 'BATIMENT0000000314341218', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 99.1, 104.1, 107.6, 99.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666680B0284133333373C60058410000000000005A400000000080B02841666666A6C70058410000000000005A40CDCCCCCC7BB02841666666A6C70058410000000000005A409A9999997BB02841CDCCCC6CC60058410000000000005A406666666680B0284133333373C60058410000000000005A40', 'BATIMENT0000000314341219', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 99.1, 104.0, 106.8, 99.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666ECB0284100000000F50058410000000000408FC066666666EFB028419A999939F40058410000000000408FC09A999999FAB02841000000E0F40058410000000000408FC09A999999F7B028419A999999F50058410000000000408FC066666666ECB0284100000000F50058410000000000408FC0', 'BATIMENT0000000314341250', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-02-10 09:06:22.094+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 108.3, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666688B02841CDCCCCAC000158410000000000A05B403333333383B028419A999939020158410000000000A05B40666666667CB02841CDCCCCEC010158410000000000A05B403333333381B0284133333353000158410000000000A05B406666666688B02841CDCCCCAC000158410000000000A05B40', 'BATIMENT0000000314341213', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 106.8, 110.5, 111.0, 106.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000EFB0284100000000010158419A99999999195C409A999999EFB02841CDCCCC6C000158419A99999999195C4066666666F8B02841CDCCCC4CFD0058419A99999999195C40CDCCCCCC05B12841333333D3FD0058419A99999999195C40CDCCCCCCFBB0284133333393010158419A99999999195C4000000000EFB0284100000000010158419A99999999195C40', 'BATIMENT0000000314341220', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.8, 110.6, 112.4, 112.6, 110.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000009A999999A7B12841333333734D015841CDCCCCCCCCAC5B4000000000B1B12841CDCCCCCC4C015841CDCCCCCCCCAC5B4033333333B2B12841CDCCCC0C4D015841CDCCCCCCCCAC5B40CDCCCCCCB2B12841333333334D015841CDCCCCCCCCAC5B4000000000B1B128419A9999594D015841CDCCCCCCCCAC5B4033333333B5B128419A9999194F015841CDCCCCCCCCAC5B4066666666A7B12841CDCCCCCC4F015841CDCCCCCCCCAC5B4033333333A1B12841333333734D015841CDCCCCCCCCAC5B409A999999A7B12841333333734D015841CDCCCCCCCCAC5B40', 'BATIMENT0000000314341258', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-12-13 14:38:36.757+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 4.0, 106.7, NULL, 111.4, 107.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999995BB22841CDCCCC8C3D0158416666666666065C409A99999965B22841CDCCCC0C3B0158416666666666065C409A9999996EB22841666666A63B0158416666666666065C40CDCCCCCC6CB22841CDCCCC0C3C0158416666666666065C409A99999965B228419A9999393E0158416666666666065C409A9999995BB22841CDCCCC8C3D0158416666666666065C40', 'BATIMENT0000000314341260', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-12-13 14:38:36.757+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.1, 106.0, NULL, 112.7, 109.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000072B22841CDCCCC6C410158416666666666065C409A99999979B228419A9999993F0158416666666666065C40CDCCCCCC8AB2284100000080400158416666666666065C40CDCCCCCC8DB22841CDCCCCAC400158416666666666065C400000000085B22841333333B3420158416666666666065C400000000072B22841CDCCCC6C410158416666666666065C40', 'BATIMENT0000000314341261', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-12-13 14:38:36.757+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.1, 106.0, NULL, 113.7, 107.2, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000048AD2841666666861CFF574166666666664657409A99999964AD2841CDCCCC8C1CFF57419A999999991957409A99999964AD2841333333B31AFF5741CDCCCCCCCC0C57403333333348AD2841666666A61AFF574133333333333357400000000048AD2841666666861CFF57416666666666465740', 'BATIMENT0000000027749967', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.3, 90.8, NULL, 95.7, 91.3, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A999999F7AE284133333373370058410000000000005C40CDCCCCCC02AF28419A9999F9370058410000000000005C409A999999F2AE28419A9999793C0058410000000000005C4033333333E0AE2841000000A03B0058410000000000005C40CDCCCCCCE4AE2841333333533A0058410000000000005C4066666666EBAE2841000000A03A0058410000000000005C409A999999F7AE284133333373370058410000000000005C40', 'BATIMENT0000000027748858', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2016-07-11 16:10:37.238+02', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.7, 109.3, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999975A92841000000C0240058410000000000408FC00000000072A928419A9999F9230058410000000000408FC09A99999978A92841CDCCCC8C230058410000000000408FC0CDCCCCCC7BA9284100000060240058410000000000408FC09A99999975A92841000000C0240058410000000000408FC0', 'BATIMENT0000000314341270', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:12:19.242+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 122.9, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC63AD28416666668627FF57410000000000605640333333335BAD28416666664627FF574166666666666656400000000063AD28419A99995923FF57416666666666665640333333336CAD2841CDCCCCAC23FF57416666666666665640CDCCCCCC63AD28416666668627FF57410000000000605640', 'BATIMENT0000000304467834', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:19.379+02', '2017-01-31 21:26:19.973+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 87.0, NULL, 93.9, 87.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC7CAD2841CDCCCC0C2B0158410000000000408FC0333333337EAD2841CDCCCC0C2A0158410000000000408FC03333333385AD2841CDCCCC2C2A0158410000000000408FC0CDCCCCCC83AD28419A9999392B0158410000000000408FC0CDCCCCCC7CAD2841CDCCCC0C2B0158410000000000408FC0', 'BATIMENT0000000314347449', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 88.2, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666A1A7284100000020F500584100000000006060409A999999A4A7284100000020F400584133333333336360409A9999999AA72841666666A6F30058419A999999996960400000000098A7284133333393F4005841666666666666604066666666A1A7284100000020F50058410000000000606040', 'BATIMENT0000000027747480', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2012-10-19 08:24:56.193+02', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 3.2, 128.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999997CA828419A999999AF0158410000000000408FC06666666662A82841CDCCCC4CAF0158410000000000408FC0CDCCCCCC62A828419A999979AE0158410000000000408FC0333333337DA828419A9999D9AE0158410000000000408FC09A9999997CA828419A999999AF0158410000000000408FC0', 'BATIMENT0000000314346923', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 75.9, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666662EA8284100000020C30158410000000000005340CDCCCCCC2DA82841333333B3C201584100000000000053406666666639A8284166666666C20158410000000000005340333333333AA82841CDCCCCCCC20158410000000000005340666666662EA8284100000020C30158410000000000005340', 'BATIMENT0000000314346880', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.6, 74.4, 76.0, 76.8, 74.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333DEA7284166666626C5015841333333333313534033333333DDA7284100000080C4015841333333333313534000000000EAA7284166666626C4015841333333333313534066666666EBA72841333333D3C4015841333333333313534033333333DEA7284166666626C50158413333333333135340', 'BATIMENT0000000314346887', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.8, 74.5, 76.3, 76.8, 74.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000005AA72841CDCCCC4C6C0258410000000000408FC09A99999955A72841CDCCCCEC6C0258410000000000408FC03333333352A728419A9999996C0258410000000000408FC00000000057A72841000000E06B0258410000000000408FC0000000005AA72841CDCCCC4C6C0258410000000000408FC0', 'BATIMENT0000000314346931', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:20.605+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 71.1, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC0FA82841CDCCCCCCCA0158419A99999999D952403333333313A82841CDCCCCCCCC0158419A99999999D95240CDCCCCCC0EA82841333333F3CC0158419A99999999D95240CDCCCCCC0BA8284166666606CD0158419A99999999D952409A99999908A8284166666606CB0158419A99999999D95240CDCCCCCC0FA82841CDCCCCCCCA0158419A99999999D95240', 'BATIMENT0000000314346911', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.4, 74.0, 75.4, 76.7, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000BBAE28419A9999D9DE0058419A99999999D95740CDCCCCCCC4AE284166666686DE0058413333333333D35740CDCCCCCCC1AE28419A999979DD0058413333333333D3574033333333B9AE2841333333D3DD0058413333333333D3574000000000BBAE28419A9999D9DE0058419A99999999D95740', 'BATIMENT0000000027747470', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-02-10 09:06:22.094+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 91.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999E1AD2841333333138401584100000000004056409A999999BCAD2841CDCCCC4C81015841000000000040564066666666CAAD2841000000607E0158410000000000405640CDCCCCCCF5AD2841CDCCCCAC8101584100000000004056409A999999E7AD2841666666868401584100000000004056409A999999E1AD284133333313840158410000000000405640', 'BATIMENT0000000314347115', 'Eglise', 'Religieux', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 13.3, 75.7, 89.0, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000061AE28419A9999B94F015841CDCCCCCCCC6C55409A9999995EAE28410000004051015841CDCCCCCCCC6C55403333333350AE28419A99997950015841CDCCCCCCCC6C55400000000055AE28419A9999194F015841CDCCCCCCCC6C55400000000061AE28419A9999B94F015841CDCCCCCCCC6C5540', 'BATIMENT0000000314347331', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.6, 83.1, 85.7, 86.4, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999997DAF2841000000A0560158410000000000E056409A9999997CAF28419A9999D9560158410000000000E05640000000006DAF28419A999939590158410000000000E05640000000006BAF284166666686590158410000000000E05640666666665EAF284100000040580158410000000000E05640666666666EAF28419A9999D9550158410000000000E056409A9999997DAF2841000000A0560158410000000000E05640', 'BATIMENT0000000314347389', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 86.9, 91.5, 91.6, 87.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000B2B92841000000407E01584166666666660658406666666692B92841000000407E0158413333333333F357403333333395B92841000000E07C0158413333333333F3574000000000B2B92841333333F37C015841666666666606584000000000B2B92841000000407E0158416666666666065840', 'BATIMENT0000000027745674', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.2, 93.9, NULL, 102.7, 94.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCC9AD28419A9999F96E015841CDCCCCCCCCEC54409A999999DBAD2841CDCCCCCC6F015841CDCCCCCCCCEC544066666666D8AD28413333339370015841CDCCCCCCCCEC54409A999999C7AD2841CDCCCCCC6F015841CDCCCCCCCCEC5440CDCCCCCCC9AD28419A9999F96E015841CDCCCCCCCCEC5440', 'BATIMENT0000000314347377', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 78.0, 83.7, 85.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000005AAF28419A9999991D015841CDCCCCCCCCAC5740333333335BAF28419A9999191B015841CDCCCCCCCCAC5740333333336FAF2841333333531B015841CDCCCCCCCCAC5740000000006EAF28419A9999B91D015841CDCCCCCCCCAC5740000000005AAF28419A9999991D015841CDCCCCCCCCAC5740', 'BATIMENT0000000314347470', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 90.4, 94.7, 94.7, 90.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000E0000009A99999922AD28419A9999D92C015841CDCCCCCCCCCC5640000000000FAD2841333333732C015841CDCCCCCCCCCC56403333333306AD2841666666462C015841CDCCCCCCCCCC56409A99999907AD2841666666262B015841CDCCCCCCCCCC56406666666610AD2841333333532B015841CDCCCCCCCCCC56403333333312AD2841CDCCCC0C2A015841CDCCCCCCCCCC5640666666661CAD2841000000402A015841CDCCCCCCCCCC5640666666661EAD2841000000C028015841CDCCCCCCCCCC56406666666629AD28410000000029015841CDCCCCCCCCCC56409A99999928AD2841CDCCCCAC29015841CDCCCCCCCCCC5640CDCCCCCC2DAD2841666666C629015841CDCCCCCCCCCC5640333333332BAD2841333333D32B015841CDCCCCCCCCCC56403333333324AD2841CDCCCCAC2B015841CDCCCCCCCCCC56409A99999922AD28419A9999D92C015841CDCCCCCCCCCC5640', 'BATIMENT0000000314347437', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 86.2, 91.2, 93.5, 86.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666634AF2841000000603A0158419A999999995956400000000033AF2841666666E6390158419A99999999595640CDCCCCCC31AF28419A999979390158419A99999999595640333333332CAF2841666666C6390158419A999999995956409A9999992EAF2841666666A63A0158419A999999995956406666666634AF2841000000603A0158419A99999999595640', 'BATIMENT0000000314347486', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 85.7, 89.4, 89.8, 85.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC44B0284133333353FC0058410000000000E05A409A99999947B0284166666686FB0058410000000000E05A40000000004FB028419A9999D9FB0058410000000000E05A409A9999994CB02841CDCCCCACFC0058410000000000E05A40CDCCCCCC44B0284133333353FC0058410000000000E05A40', 'BATIMENT0000000314347503', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 103.5, 107.5, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000002AD2841CDCCCCCC2E01584133333333333356400000000002AD2841333333D32E0158413333333333335640CDCCCCCC00AD2841CDCCCCAC2F015841333333333333564033333333F7AC28419A9999792F015841333333333333564066666666F8AC28419A9999992E015841333333333333564066666666FBAC2841666666A62E01584133333333333356400000000002AD2841CDCCCCCC2E0158413333333333335640', 'BATIMENT0000000314347544', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.0, 82.8, 88.8, 89.2, 84.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333BEAD2841333333334D0158419A99999999B9574033333333C3AD28419A9999794D0158419A99999999B9574066666666BFAD28419A9999994E0158419A99999999B9574033333333B8AD2841000000604E0158419A99999999B9574000000000BBAD2841666666664D0158419A99999999B9574033333333BEAD2841333333334D0158419A99999999B95740', 'BATIMENT0000000314347625', 'Château', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 12.5, 82.4, 94.9, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000001600000033333333B8AD2841000000604E0158410000000000C0574066666666BFAD28419A9999994E0158410000000000C0574000000000CDAD2841000000004F0158410000000000C05740CDCCCCCCD2AD2841666666264F0158410000000000C0574033333333DAAD28419A9999594F0158410000000000C0574033333333D2AD2841333333D3500158410000000000C057409A999999D1AD284166666646510158410000000000C0574000000000D0AD2841000000C0510158410000000000C0574033333333CEAD2841CDCCCC0C520158410000000000C0574033333333CAAD28419A999959520158410000000000C0574000000000C7AD284166666666520158410000000000C0574000000000C4AD284133333353520158410000000000C0574033333333C1AD28419A9999F9510158410000000000C0574000000000C0AD2841000000C0510158410000000000C0574000000000BFAD284166666646510158410000000000C05740CDCCCCCCBAAD2841CDCCCC0C510158410000000000C057409A999999B8AD284166666686510158410000000000C057409A999999AFAD28419A9999D9500158410000000000C0574000000000AEAD284133333333500158410000000000C05740CDCCCCCCB2AD2841000000604E0158410000000000C05740CDCCCCCCB5AD2841CDCCCC4C4E0158410000000000C0574033333333B8AD2841000000604E0158410000000000C05740', 'BATIMENT0000000314347627', 'Château', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 12.6, 82.4, 95.0, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC9FAC284166666686A20458419A99999999594C409A999999ACAC284133333353A20458419A99999999594C4033333333ABAC284100000080A10458419A99999999594C40CDCCCCCC9EAC2841000000C0A10458419A99999999594C40CDCCCCCC9FAC284166666686A20458419A99999999594C40', 'BATIMENT0000000314350209', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:05.473+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 53.8, 56.8, 59.5, 53.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333D6AD28419A9999F91F0158416666666666A6574033333333D8AD28419A9999791E0158416666666666A6574000000000E8AD2841333333D31E0158416666666666A6574000000000E6AD2841CDCCCC4C200158416666666666A6574033333333D6AD28419A9999F91F0158416666666666A65740', 'BATIMENT0000000314347637', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 90.4, 94.6, 95.1, 92.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666A1AD2841CDCCCCACF40058410000000000005940CDCCCCCC72AD2841CDCCCC0CF700584100000000000059409A9999996AAD284100000080F400584100000000000059400000000099AD284100000020F2005841000000000000594066666666A1AD2841CDCCCCACF40058410000000000005940', 'BATIMENT0000000314347638', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.3, 94.7, 100.0, 100.6, 95.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999994EAF2841333333336E0158410000000000408FC0333333334CAF28419A9999996E0158410000000000408FC06666666644AF28419A9999D96D0158410000000000408FC0CDCCCCCC46AF28419A9999796D0158410000000000408FC09A9999994EAF2841333333336E0158410000000000408FC0', 'BATIMENT0000000314347675', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 85.1, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666661AAE2841000000008D015841CDCCCCCCCCCC5440666666661BAE2841CDCCCC0C8B015841CDCCCCCCCCCC54406666666627AE28419A9999198B015841CDCCCCCCCCCC54403333333326AE2841333333138D015841CDCCCCCCCCCC5440666666661AAE2841000000008D015841CDCCCCCCCCCC5440', 'BATIMENT0000000314348373', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 78.0, 83.2, 83.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666629AE2841CDCCCC0C9D0158416666666666665440CDCCCCCC2AAE2841000000E09E01584166666666666654403333333322AE2841333333F39E0158416666666666665440CDCCCCCC20AE2841666666269D01584166666666666654406666666629AE2841CDCCCC0C9D0158416666666666665440', 'BATIMENT0000000314348397', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 76.9, 81.6, 82.6, 77.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999991BAB2841CDCCCCEC830158410000000000805340CDCCCCCC13AB2841000000008301584100000000008053403333333318AB2841CDCCCC4C8201584100000000008053400000000020AB2841333333338301584100000000008053409A9999991BAB2841CDCCCCEC830158410000000000805340', 'BATIMENT0000000314348385', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 75.0, 78.0, 79.8, 75.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000030AE2841000000208D0158419A999999993955400000000031AE2841000000208B0158419A99999999395540333333333BAE2841666666268B0158419A99999999395540666666663AAE2841333333338D0158419A999999993955400000000030AE2841000000208D0158419A99999999395540', 'BATIMENT0000000314348379', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.4, 78.5, 84.9, 85.1, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000006666666623AE28419A9999D9940158410000000000805440CDCCCCCC2AAE2841CDCCCC8C9501584100000000008054403333333326AE2841CDCCCC2C9601584100000000008054403333333322AE2841333333339701584100000000008054400000000016AE2841666666A69601584100000000008054406666666619AE2841000000C09401584100000000008054406666666623AE28419A9999D9940158410000000000805440', 'BATIMENT0000000314348425', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 77.2, 82.0, 82.2, 77.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999945AD2841CDCCCCECAB0158410000000000A053409A99999941AD2841333333F3AB0158410000000000A05340000000003EAD2841333333F3AB0158410000000000A05340CDCCCCCC3CAD28419A999959AA0158410000000000A053403333333345AD284133333353AA0158410000000000A053409A99999945AD2841CDCCCCECAB0158410000000000A05340', 'BATIMENT0000000314348446', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 73.3, 78.5, 79.9, 73.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000FCAD28410000002094015841CDCCCCCCCC4C5440CDCCCCCCEBAD2841666666C693015841CDCCCCCCCC4C54409A999999E8AD28419A9999B993015841CDCCCCCCCC4C5440CDCCCCCCE9AD28419A9999B992015841CDCCCCCCCC4C5440CDCCCCCCFCAD2841CDCCCC0C93015841CDCCCCCCCC4C544000000000FCAD28410000002094015841CDCCCCCCCC4C5440', 'BATIMENT0000000314348427', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 77.2, 81.2, 82.3, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000006666666617AE2841333333B39401584133333333339354406666666619AE2841000000C09401584133333333339354406666666623AE28419A9999D99401584133333333339354409A99999927AE2841000000608F0158413333333333935440666666661AAE2841000000408F01584133333333339354403333333319AE28419A9999199101584133333333339354403333333310AE2841666666069101584133333333339354409A9999990FAE2841666666E6910158413333333333935440666666660EAE2841666666869401584133333333339354406666666617AE2841333333B3940158413333333333935440', 'BATIMENT0000000314348428', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-07-03 06:49:09.898+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 77.2, 82.3, 84.5, 77.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666662AF28419A9999B9BC0158410000000000C054403333333364AF284133333313BF0158410000000000C05440333333335DAF2841CDCCCCECBE0158410000000000C054406666666658AF28419A999979BC0158410000000000C054406666666659AF284100000080BC0158410000000000C054406666666662AF28419A9999B9BC0158410000000000C05440', 'BATIMENT0000000314348516', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 77.9, 83.0, 83.4, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCFFAF28419A999979C40158410000000000C054400000000000B0284166666626C50158410000000000C054409A999999FBAF2841CDCCCC2CC50158410000000000C0544066666666FBAF28419A999979C40158410000000000C0544000000000FCAF28419A999979C40158410000000000C05440CDCCCCCCFFAF28419A999979C40158410000000000C05440', 'BATIMENT0000000314348532', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 78.3, 83.0, 83.8, 78.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000CDCCCCCC3CAD28416666664653025841CDCCCCCCCC0C5540666666663AAD28410000002054025841CDCCCCCCCC0C55403333333331AD2841CDCCCCAC53025841CDCCCCCCCC0C55409A99999930AD28410000004053025841CDCCCCCCCC0C5540CDCCCCCC28AD28419A9999F952025841CDCCCCCCCC0C55400000000027AD28419A9999B953025841CDCCCCCCCC0C55406666666624AD2841666666A653025841CDCCCCCCCC0C55403333333327AD28419A99995952025841CDCCCCCCCC0C5540CDCCCCCC3CAD28416666664653025841CDCCCCCCCC0C5540', 'BATIMENT0000000314348579', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 81.1, 84.2, 84.4, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F8AB2841333333132B0258419A99999999995240333333331EAC28419A9999B92C0258419A99999999995240333333331AAC2841CDCCCC8C2E0258419A99999999995240CDCCCCCCF3AB2841000000E02C0258419A9999999999524033333333F8AB2841333333132B0258419A99999999995240', 'BATIMENT0000000314348649', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 71.7, 74.4, 75.2, 71.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999997EAE28410000008035025841CDCCCCCCCCEC55409A9999997DAE2841333333D335025841CDCCCCCCCCEC5540CDCCCCCC70AE28413333335335025841CDCCCCCCCCEC55400000000072AE28419A9999F934025841CDCCCCCCCCEC55406666666673AE28413333339334025841CDCCCCCCCCEC55400000000080AE28413333331335025841CDCCCCCCCCEC55409A9999997EAE28410000008035025841CDCCCCCCCCEC5540', 'BATIMENT0000000314348637', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 85.0, 87.7, 88.3, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F5AF28419A9999D9E10158416666666666C65440CDCCCCCCE7AF28419A9999F9E10158416666666666C654409A999999E7AF28419A999959E10158416666666666C6544066666666F4AF284133333333E10158416666666666C6544033333333F5AF28419A9999D9E10158416666666666C65440', 'BATIMENT0000000314348713', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 79.1, 83.1, 83.2, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666667EAD2841666666065D0258410000000000E05440333333337EAD2841CDCCCC4C5D0258410000000000E054400000000073AD2841CDCCCC6C5D0258410000000000E05440CDCCCCCC72AD2841333333935C0258410000000000E05440CDCCCCCC7DAD28419A9999795C0258410000000000E05440666666667EAD2841666666065D0258410000000000E05440', 'BATIMENT0000000314348698', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 79.8, 83.5, 84.3, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000005DAF2841666666E6EC01584166666666668654409A99999958AF28419A9999F9EC01584166666666668654409A99999959AF284133333373EE01584166666666668654409A9999995EAF284166666666EE0158416666666666865440000000005DAF2841666666E6EC0158416666666666865440', 'BATIMENT0000000314348735', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.1, 77.1, 82.2, 82.8, 77.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666667CAF2841333333B3DB01584100000000006054400000000078AF2841000000C0DB01584100000000006054400000000077AF2841CDCCCC6CDA0158410000000000605440333333337BAF284100000060DA0158410000000000605440666666667CAF2841333333B3DB0158410000000000605440', 'BATIMENT0000000314348718', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 78.8, 81.5, 81.5, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666A9AF284166666646F0015841CDCCCCCCCCCC54409A99999998AF284100000080F0015841CDCCCCCCCCCC54400000000099AF284100000040F1015841CDCCCCCCCCCC544033333333AAAF2841CDCCCC0CF1015841CDCCCCCCCCCC544066666666A9AF284166666646F0015841CDCCCCCCCCCC5440', 'BATIMENT0000000314348760', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 79.1, 83.3, 84.3, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000055AC28419A9999F9090258413333333333735240666666664AAC28419A999959090258413333333333735240333333334BAC284166666606090258413333333333735240CDCCCCCC55AC2841CDCCCCAC0902584133333333337352400000000055AC28419A9999F9090258413333333333735240', 'BATIMENT0000000314348795', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.2, 71.6, 73.8, 74.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCCEB128419A999979BF0158410000000000408FC033333333DAB1284100000020BF0158410000000000408FC033333333DBB128419A9999D9BF0158410000000000408FC000000000D0B1284100000040C00158410000000000408FC0CDCCCCCCCEB128419A999979BF0158410000000000408FC0', 'BATIMENT0000000314350086', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 85.4, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333326AE284166666686E001584100000000008053409A99999924AE284166666606DF0158410000000000805340000000002BAE2841CDCCCC6CDE0158410000000000805340333333332CAE284166666606E001584100000000008053403333333329AE2841CDCCCC0CE001584100000000008053403333333329AE284100000080E001584100000000008053403333333326AE284166666686E00158410000000000805340', 'BATIMENT0000000314348772', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.5, 75.5, 78.0, 78.5, 75.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC01AC28410000006003025841666666666666524033333333FAAB2841CDCCCC6C05025841666666666666524033333333F5AB28419A999919050258416666666666665240CDCCCCCCFCAB284133333313030258416666666666665240CDCCCCCC01AC284100000060030258416666666666665240', 'BATIMENT0000000314348764', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.6, 71.0, 73.6, 73.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333332EAE284166666626D3015841CDCCCCCCCC8C5340000000002DAE28419A999919D2015841CDCCCCCCCC8C5340CDCCCCCC36AE2841000000E0D1015841CDCCCCCCCC8C53403333333337AE2841333333F3D2015841CDCCCCCCCC8C5340333333332EAE284166666626D3015841CDCCCCCCCC8C5340', 'BATIMENT0000000314348774', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.2, 75.0, 78.2, 78.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000057AC28419A9999B9D601584100000000006052403333333358AC2841000000E0D50158410000000000605240CDCCCCCC5FAC2841CDCCCC0CD60158410000000000605240000000005FAC2841CDCCCCECD601584100000000006052400000000057AC28419A9999B9D60158410000000000605240', 'BATIMENT0000000314348819', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.5, 72.0, 73.5, 73.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000004CAE2841333333D3D201584100000000008053409A9999994AAE2841CDCCCCCCD101584100000000008053409A99999953AE28419A999999D101584100000000008053400000000055AE2841000000A0D20158410000000000805340000000004CAE2841333333D3D20158410000000000805340', 'BATIMENT0000000314348828', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 75.0, 78.0, 78.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666666DAB2841333333330502584166666666664652409A9999996AAB28419A999919060258416666666666465240CDCCCCCC67AB2841000000000602584166666666664652403333333363AB2841666666C60502584166666666664652400000000067AB28419A999999040258416666666666465240333333336EAB28419A9999F9040258416666666666465240666666666DAB284133333333050258416666666666465240', 'BATIMENT0000000314348835', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 70.0, 73.1, 73.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A99999936AF284133333353D40158413333333333535440CDCCCCCC35AF284100000080D30158413333333333535440000000004BAF28419A999939D301584133333333335354409A9999994BAF2841666666C6D30158413333333333535440CDCCCCCC40AF2841000000E0D301584133333333335354406666666641AF2841333333D3D401584133333333335354403333333337AF2841333333F3D401584133333333335354409A99999936AF284133333353D40158413333333333535440', 'BATIMENT0000000314348856', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.4, 77.9, 81.3, 82.2, 77.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A999999E2AE284100000040D60158419A9999999999534000000000E3AE2841666666C6D60158419A99999999995340CDCCCCCCE3AE2841CDCCCCCCD70158419A99999999995340CDCCCCCCDDAE2841000000E0D70158419A999999999953409A999999DCAE284100000060D60158419A999999999953409A999999DDAE28419A999959D60158419A999999999953409A999999E2AE284100000040D60158419A99999999995340', 'BATIMENT0000000314348882', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.7, 76.7, 78.4, 80.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC27AC28419A9999F9F40158410000000000605240666666662AAC2841CDCCCC8CF401584100000000006052409A99999935AC2841666666C6F50158410000000000605240CDCCCCCC31AC284133333333F60158410000000000605240CDCCCCCC27AC28419A9999F9F40158410000000000605240', 'BATIMENT0000000314348891', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.4, 71.1, 73.5, 74.2, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC86AD284100000040990158419A999999997954409A99999988AD2841000000A09B0158419A99999999795440666666667EAD2841CDCCCCCC9B0158419A99999999795440000000007EAD28419A9999199B0158419A99999999795440CDCCCCCC7CAD284133333393990158419A99999999795440CDCCCCCC86AD284100000040990158419A99999999795440', 'BATIMENT0000000314348969', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.8, 74.1, 81.9, 83.7, 74.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCC74AD2841CDCCCC2C99015841CDCCCCCCCCAC54403333333378AD28416666662699015841CDCCCCCCCCAC54403333333378AD2841000000C099015841CDCCCCCCCCAC5440CDCCCCCC7CAD28413333339399015841CDCCCCCCCCAC5440000000007EAD28419A9999199B015841CDCCCCCCCCAC54400000000073AD2841333333339B015841CDCCCCCCCCAC54400000000073AD2841CDCCCC2C99015841CDCCCCCCCCAC5440CDCCCCCC74AD2841CDCCCC2C99015841CDCCCCCCCCAC5440', 'BATIMENT0000000314348970', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.2, 74.5, 82.7, 83.5, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000002AAC28419A999919A7015841CDCCCCCCCC8C53409A99999925AC2841CDCCCC2CA7015841CDCCCCCCCC8C53400000000025AC2841CDCCCCACA6015841CDCCCCCCCC8C53400000000029AC284133333393A6015841CDCCCCCCCC8C5340000000002AAC28419A999919A7015841CDCCCCCCCC8C5340', 'BATIMENT0000000314348991', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 74.0, 78.2, 78.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC4AAC28419A999979930158416666666666265440CDCCCCCC3DAC2841333333D3930158416666666666265440666666663BAC2841000000409201584166666666662654406666666648AC2841CDCCCCEC9101584166666666662654403333333349AC2841CDCCCC8C920158416666666666265440CDCCCCCC4AAC28419A999979930158416666666666265440', 'BATIMENT0000000314349024', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.4, 74.2, 80.6, 82.4, 74.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC26AC2841000000209C0158413333333333D353403333333325AC28419A9999399B0158413333333333D353400000000036AC2841333333D39A0158413333333333D353400000000037AC2841000000C09B0158413333333333D353409A9999992AAC2841666666069C0158413333333333D35340CDCCCCCC26AC2841000000209C0158413333333333D35340', 'BATIMENT0000000314349020', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 74.4, 79.3, 81.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999981AC2841CDCCCCEC9F015841CDCCCCCCCCCC53406666666692AC2841000000C09F015841CDCCCCCCCCCC53403333333394AC2841CDCCCCACA0015841CDCCCCCCCCCC53403333333383AC2841CDCCCCECA0015841CDCCCCCCCCCC53409A99999981AC2841CDCCCCEC9F015841CDCCCCCCCCCC5340', 'BATIMENT0000000314349064', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 74.0, 79.2, 80.2, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A9999995AAF28419A999919AE0158413333333333F35440666666663BAF2841666666C6AD0158413333333333F35440333333333EAF284166666666AB0158413333333333F354409A99999945AF28419A999999AB0158413333333333F354400000000059AF28419A999919AC0158413333333333F354400000000064AF284166666666AC0158413333333333F35440CDCCCCCC62AF284133333333AE0158413333333333F354409A9999995AAF28419A999919AE0158413333333333F35440', 'BATIMENT0000000314349089', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 78.6, 83.8, 84.2, 78.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999995CAC2841666666C68601584133333333339354409A99999975AC2841333333138901584133333333339354400000000070AC28419A9999F98901584133333333339354409A99999967AC2841000000408A01584133333333339354409A9999995CAC2841666666C6860158413333333333935440', 'BATIMENT0000000314349122', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.3, 74.0, 82.3, 83.9, 74.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999BDAC28419A9999B9D0015841CDCCCCCCCC8C524066666666BFAC2841333333F3CE015841CDCCCCCCCC8C524000000000C3AC28419A9999F9CE015841CDCCCCCCCC8C524000000000C1AC2841666666C6D0015841CDCCCCCCCC8C52409A999999BDAC28419A9999B9D0015841CDCCCCCCCC8C5240', 'BATIMENT0000000314349150', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.2, 72.0, 74.2, 74.5, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999C9AF2841333333D3D3015841000000000040544033333333C9AF2841CDCCCC6CD3015841000000000040544000000000C5AF284166666686CF0158410000000000405440CDCCCCCCD1AF28419A999979CF015841000000000040544033333333D4AF28419A9999D9D2015841000000000040544066666666D4AF284133333353D3015841000000000040544066666666D5AF2841666666A6D301584100000000004054409A999999C9AF2841333333D3D30158410000000000405440', 'BATIMENT0000000314349196', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 78.0, 81.0, 81.4, 78.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333335DAD284133333373AD0158413333333333935340666666665DAD284133333313AF0158413333333333935340333333334DAD28419A999919AF0158413333333333935340333333334DAD284100000080AD0158413333333333935340333333335DAD284133333373AD0158413333333333935340', 'BATIMENT0000000314349172', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 74.0, 78.3, 78.7, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C000000000000001BAD2841CDCCCC0CAF0158416666666666A65340000000001AAD2841CDCCCCACB20158416666666666A65340666666662FAD2841000000C0B20158416666666666A65340000000002EAD2841CDCCCC6CB50158416666666666A65340333333331CAD284166666686B50158416666666666A65340000000001CAD2841000000E0B40158416666666666A653409A99999918AD28419A9999D9B40158416666666666A653403333333318AD284166666666B50158416666666666A65340000000000BAD28419A999939B50158416666666666A65340000000000DAD2841000000C0B00158416666666666A65340CDCCCCCC0DAD28419A9999F9AE0158416666666666A65340000000001BAD2841CDCCCC0CAF0158416666666666A65340', 'BATIMENT0000000314349162', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 74.0, 78.6, 80.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333395AF284133333333A00158419A99999999395540666666669BAF284100000040A00158419A99999999395540333333339CAF2841666666069F0158419A999999993955409A99999995AF2841000000009F0158419A999999993955403333333395AF284133333333A00158419A99999999395540', 'BATIMENT0000000314349213', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 79.9, 84.9, 85.5, 80.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333332FAC2841333333D3C001584100000000004053400000000029AC2841333333B3C40158410000000000405340333333331AAC284100000060C401584100000000004053409A9999991FAC2841000000A0C00158410000000000405340333333332FAC2841333333D3C00158410000000000405340', 'BATIMENT0000000314349209', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 72.3, 77.0, 78.4, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000025AF2841CDCCCC0CB20158410000000000205540CDCCCCCC2AAF284100000060B00158410000000000205540666666662FAF284166666686B00158410000000000205540CDCCCCCC43AF284100000020B101584100000000002055400000000041AF2841333333D3B201584100000000002055400000000025AF2841CDCCCC0CB20158410000000000205540', 'BATIMENT0000000314349253', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.7, 77.8, 84.5, 84.9, 77.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000CDCCCCCC42AF284100000000B50158413333333333F35440333333332AAF28419A999959B40158413333333333F35440CDCCCCCC2AAF28419A999979B30158413333333333F354403333333324AF28419A999959B30158413333333333F354400000000025AF2841CDCCCC0CB20158413333333333F354400000000041AF2841333333D3B20158413333333333F354403333333344AF2841CDCCCCECB20158413333333333F354406666666643AF28419A999939B40158413333333333F35440CDCCCCCC42AF284100000000B50158413333333333F35440', 'BATIMENT0000000314349254', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.3, 77.5, 83.8, 84.1, 77.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B000000333333334FAD2841CDCCCCEC9201584166666666668654409A99999918AD2841CDCCCCAC910158416666666666865440000000001AAD28419A9999B99001584166666666668654403333333317AD2841666666A69001584166666666668654409A99999913AD2841CDCCCC0C9001584166666666668654403333333315AD2841CDCCCC0C8F0158416666666666865440CDCCCCCC19AD2841CDCCCC8C8E0158416666666666865440333333331DAD2841666666A68E01584166666666668654409A9999991EAD2841000000A08D01584166666666668654406666666655AD2841666666E68E0158416666666666865440333333334FAD2841CDCCCCEC920158416666666666865440', 'BATIMENT0000000314349274', 'Eglise', 'Religieux', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.2, 74.9, 82.1, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A99999972AF2841CDCCCC4C960158413333333333D355400000000066AF284133333353960158413333333333D35540CDCCCCCC60AF284133333353960158413333333333D355409A9999994CAF28419A999959960158413333333333D35540333333334EAF2841CDCCCC0C940158413333333333D35540CDCCCCCC73AF284166666606940158413333333333D355409A99999972AF2841CDCCCC4C960158413333333333D35540', 'BATIMENT0000000314349280', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.0, 79.3, 87.3, 89.2, 80.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999CBAE284166666606980158419A99999999D95440CDCCCCCCCAAE284166666626990158419A99999999D9544000000000C0AE28419A9999F9980158419A99999999D9544000000000C1AE2841000000E0970158419A99999999D954409A999999CBAE284166666606980158419A99999999D95440', 'BATIMENT0000000314349321', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 79.7, 83.4, 83.4, 80.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333368AB284166666626A6015841CDCCCCCCCC0C5340CDCCCCCC68AB28419A999999A5015841CDCCCCCCCC0C53403333333374AB2841333333D3A5015841CDCCCCCCCC0C53409A99999973AB284100000060A6015841CDCCCCCCCC0C53403333333368AB284166666626A6015841CDCCCCCCCC0C5340', 'BATIMENT0000000314349318', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.9, 73.3, 76.2, 77.3, 73.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000FDAC284133333353AB015841CDCCCCCCCC0C534000000000F4AC284100000040AB015841CDCCCCCCCC0C534033333333F1AC28419A9999F9A8015841CDCCCCCCCC0C534033333333FCAC28419A9999D9A8015841CDCCCCCCCC0C534000000000FDAC284133333353AB015841CDCCCCCCCC0C5340', 'BATIMENT0000000314349285', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.2, 74.0, 76.2, 76.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCDAAE28419A999979B00158419A9999999999544066666666E4AE2841333333B3AD0158419A99999999995440CDCCCCCCF6AE2841333333B3AE0158419A9999999999544066666666ECAE2841000000C0B10158419A9999999999544033333333DBAE28419A999979B00158419A99999999995440CDCCCCCCDAAE28419A999979B00158419A99999999995440', 'BATIMENT0000000314349330', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.3, 76.1, 82.4, 84.7, 77.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999982AA2841333333B39E015841CDCCCCCCCC4C5440000000006FAA2841000000609E015841CDCCCCCCCC4C54406666666671AA2841CDCCCCEC9B015841CDCCCCCCCC4C54403333333385AA2841000000409C015841CDCCCCCCCC4C54409A99999982AA2841333333B39E015841CDCCCCCCCC4C5440', 'BATIMENT0000000314349323', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.2, 74.0, 81.2, 81.7, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B00000000000000FFAB2841666666868F0158410000000000A0534066666666FEAB2841000000008E0158410000000000A053409A999999FDAB2841000000008C0158410000000000A0534000000000FDAB2841000000008A0158410000000000A053409A999999FBAB284133333373860158410000000000A053409A9999990EAC284133333353860158410000000000A05340666666660FAC2841000000A08B0158410000000000A05340CDCCCCCC0FAC2841CDCCCC2C8D0158410000000000A053406666666603AC2841333333338D0158410000000000A053400000000007AC2841000000A08E0158410000000000A0534000000000FFAB2841666666868F0158410000000000A05340', 'BATIMENT0000000314349333', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.4, 74.1, 78.5, 80.0, 74.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F0AB284166666626D40158416666666666A6524033333333EFAB284166666626D50158416666666666A65240CDCCCCCCDFAB2841333333D3D40158416666666666A65240CDCCCCCCE0AB2841333333D3D30158416666666666A6524033333333F0AB284166666626D40158416666666666A65240', 'BATIMENT0000000314349364', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 71.5, 74.6, 76.3, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999990BAC28419A999999D80158410000000000408FC00000000010AC2841333333B3D80158410000000000408FC0666666660FAC284100000040D90158410000000000408FC0666666660BAC284166666626D90158410000000000408FC09A9999990BAC28419A999999D80158410000000000408FC0', 'BATIMENT0000000314349847', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 71.3, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666F7AB284100000060C00158419A99999999B952409A99999900AC284100000080C00158419A99999999B95240CDCCCCCCFFAB28419A999939C10158419A99999999B952409A999999F6AB28419A999919C10158419A99999999B9524066666666F7AB284100000060C00158419A99999999B95240', 'BATIMENT0000000314349396', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 72.2, 74.9, 76.1, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000001FAC2841CDCCCC8CA00158410000000000408FC03333333320AC284133333333A10158410000000000408FC0666666661AAC28419A999959A10158410000000000408FC09A99999919AC2841666666A6A00158410000000000408FC0000000001FAC2841CDCCCC8CA00158410000000000408FC0', 'BATIMENT0000000314349849', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 74.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999976AC2841333333F3B4015841CDCCCCCCCC6C53406666666674AC2841666666E6B6015841CDCCCCCCCC6C53400000000072AC2841333333F3B8015841CDCCCCCCCC6C53403333333348AC284100000040B8015841CDCCCCCCCC6C5340000000004EAC28419A999939B4015841CDCCCCCCCC6C53409A99999976AC2841333333F3B4015841CDCCCCCCCC6C5340', 'BATIMENT0000000314349773', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.5, 71.2, 77.7, 79.4, 71.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000B6A92841CDCCCC0CCE0158410000000000408FC09A999999B0A92841CDCCCC0CCE0158410000000000408FC000000000B1A92841CDCCCC4CCC0158410000000000408FC09A999999B6A9284133333353CC0158410000000000408FC000000000B6A92841CDCCCC0CCE0158410000000000408FC0', 'BATIMENT0000000314349511', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 73.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999A8A828419A999959920158410000000000E0534066666666A9A8284133333393910158410000000000E0534066666666B7A82841333333D3910158410000000000E0534000000000B7A8284133333393920158410000000000E053409A999999A8A828419A999959920158410000000000E05340', 'BATIMENT0000000314349544', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.6, 76.9, 79.5, 79.6, 76.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666640AB284100000040AD0158410000000000E05240333333333FAB2841CDCCCC6CAE0158410000000000E052406666666638AB2841CDCCCC4CAE0158410000000000E052400000000039AB284100000020AD0158410000000000E052406666666640AB284100000040AD0158410000000000E05240', 'BATIMENT0000000314349564', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.5, 73.0, 75.5, 76.3, 73.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000003CAB2841666666E6B10158413333333333B35240CDCCCCCC32AB28419A9999B9B10158413333333333B352406666666634AB2841666666C6AF0158413333333333B35240CDCCCCCC3DAB28419A9999D9AF0158413333333333B35240000000003CAB2841666666E6B10158413333333333B35240', 'BATIMENT0000000314349562', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.8, 73.0, 74.8, 76.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC29AE2841333333D3BE015841CDCCCCCCCC4C53406666666623AE2841000000E0BE015841CDCCCCCCCC4C53400000000023AE28419A9999F9BC015841CDCCCCCCCC4C53406666666629AE28419A9999F9BC015841CDCCCCCCCC4C53409A99999929AE2841CDCCCC6CBD015841CDCCCCCCCC4C5340CDCCCCCC29AE2841333333D3BE015841CDCCCCCCCC4C5340', 'BATIMENT0000000314349582', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.3, 74.9, 77.2, 78.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC6CAC2841CDCCCC4C3C0258413333333333D35340333333336EAC28419A9999593C0258413333333333D35340333333336FAC2841666666E63B0258413333333333D35340000000006EAC28419A9999D93B0258413333333333D353406666666662AC28419A9999593B0258413333333333D353403333333361AC2841CDCCCCCC3B0258413333333333D35340CDCCCCCC6CAC2841CDCCCC4C3C0258413333333333D35340', 'BATIMENT0000000314349605', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-07-03 06:49:09.898+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.5, 74.8, 79.3, 80.0, 75.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCE5B82841CDCCCC4C74005841CDCCCCCCCC0C584066666666F1B828410000000075005841CDCCCCCCCC0C58409A999999EFB828416666668675005841CDCCCCCCCC0C5840CDCCCCCCECB828416666662676005841CDCCCCCCCC0C5840CDCCCCCCE1B82841CDCCCC6C75005841CDCCCCCCCC0C5840CDCCCCCCE5B82841CDCCCC4C74005841CDCCCCCCCC0C5840', 'BATIMENT0000000314350000', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:01.716+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 91.9, 96.2, 100.3, 93.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333C9AC284133333353010258416666666666A6524033333333C6AC284100000020010258416666666666A6524066666666CCAC2841CDCCCC8CFF0158416666666666A6524066666666CFAC28419A9999B9FF0158416666666666A6524033333333C9AC284133333353010258416666666666A65240', 'BATIMENT0000000314349755', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 70.3, 74.6, 75.4, 71.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000000000002AAB2841CDCCCC0CCB0158413333333333D352406666666627AB284166666666CE0158413333333333D35240CDCCCCCC20AB284133333353CE0158413333333333D352403333333321AB284133333333CD0158413333333333D352403333333315AB284133333313CD0158413333333333D352400000000017AB284133333353CA0158413333333333D35240333333331EAB2841CDCCCC6CCA0158413333333333D352406666666621AB2841333333F3CA0158413333333333D35240000000002AAB2841CDCCCC0CCB0158413333333333D35240', 'BATIMENT0000000314349757', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 69.4, 75.3, 77.9, 71.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000000000002AAB2841CDCCCC0CCB0158413333333333D35240CDCCCCCC32AB284166666626CB0158413333333333D352403333333336AB2841000000C0CA0158413333333333D35240333333333DAB2841CDCCCCCCCA0158413333333333D35240333333333BAB2841CDCCCC8CCD0158413333333333D35240CDCCCCCC2EAB284100000060CD0158413333333333D35240CDCCCCCC2DAB28419A999979CE0158413333333333D352406666666627AB284166666666CE0158413333333333D35240000000002AAB2841CDCCCC0CCB0158413333333333D35240', 'BATIMENT0000000314349758', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 69.4, 75.3, 77.8, 71.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999998EAA284100000040AB0158410000000000408FC03333333394AA2841CDCCCC4CAB0158410000000000408FC0CDCCCCCC93AA28419A9999F9AB0158410000000000408FC0333333338EAA2841666666E6AB0158410000000000408FC09A9999998EAA284100000040AB0158410000000000408FC0', 'BATIMENT0000000314349844', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 73.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333366AD2841666666A64C0258416666666666E654403333333363AD28419A9999B94D0258416666666666E65440000000005EAD2841666666864D0258416666666666E65440666666665EAD2841333333334D0258416666666666E65440666666665CAD28419A9999194D0258416666666666E65440666666665EAD2841CDCCCC4C4C0258416666666666E654403333333366AD2841666666A64C0258416666666666E65440', 'BATIMENT0000000314349770', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 79.5, 83.6, 84.6, 81.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999996AAA28419A9999D9DF0158410000000000408FC0333333336BAA2841CDCCCC0CDF0158410000000000408FC0CDCCCCCC6FAA284100000020DF0158410000000000408FC0333333336FAA2841CDCCCCECDF0158410000000000408FC09A9999996AAA28419A9999D9DF0158410000000000408FC0', 'BATIMENT0000000314349843', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 70.7, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000009EAE284133333313BD0158410000000000408FC0000000009CAE2841666666A6BC0158410000000000408FC0CDCCCCCC9FAE2841CDCCCC6CBC0158410000000000408FC09A999999A1AE28419A9999D9BC0158410000000000408FC0000000009EAE284133333313BD0158410000000000408FC0', 'BATIMENT0000000314349855', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 76.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000077AA284166666606E00158410000000000408FC09A99999973AA28419A9999F9DF0158410000000000408FC0CDCCCCCC73AA284133333373DF0158410000000000408FC06666666677AA28419A999979DF0158410000000000408FC00000000077AA284166666606E00158410000000000408FC0', 'BATIMENT0000000314349876', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 70.5, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000003333333301AE2841CDCCCC2CB90158419A99999999B9534033333333FEAD2841000000A0B50158419A99999999B953409A99999902AE28419A9999B9B50158419A99999999B95340333333330FAE284133333313B60158419A99999999B953409A9999990CAE28419A999919B80158419A99999999B953409A99999909AE2841CDCCCC0CB80158419A99999999B953403333333308AE2841CDCCCC4CB90158419A99999999B953403333333301AE2841CDCCCC2CB90158419A99999999B95340', 'BATIMENT0000000314349794', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.5, 73.4, 78.9, 79.8, 73.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000CDCCCCCCBBBE284166666686800058410000000000A05B40CDCCCCCCD5BE284166666646800058410000000000A05B40CDCCCCCCD4BE2841CDCCCC4C7E0058410000000000A05B4000000000CFBE2841333333537E0058410000000000A05B4066666666CFBE2841666666867F0058410000000000A05B40CDCCCCCCC1BE28419A9999997F0058410000000000A05B4033333333C1BE2841000000207F0058410000000000A05B409A999999BBBE2841CDCCCC2C7F0058410000000000A05B40CDCCCCCCBBBE284166666686800058410000000000A05B40', 'BATIMENT0000000304467837', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2012-06-28 10:22:19.379+02', '2016-06-09 14:28:41.861+02', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.5, 108.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666665CB42841CDCCCC0C43005841CDCCCCCCCCFC61403333333352B428419A99995944005841CDCCCCCCCCFC61409A99999955B42841000000C044005841CDCCCCCCCCFC6140CDCCCCCC5BB428410000008045005841CDCCCCCCCCFC61400000000066B428413333333344005841CDCCCCCCCCFC6140666666665FB42841CDCCCC6C43005841CDCCCCCCCCFC6140666666665CB42841CDCCCC0C43005841CDCCCCCCCCFC6140', 'BATIMENT0000000314349992', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:31:35.02+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 137.1, 144.0, 144.1, 139.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC41B42841333333B36C005841CDCCCCCCCCCC5F40CDCCCCCC45B42841000000A06E005841CDCCCCCCCCCC5F400000000025B42841CDCCCCAC6F005841CDCCCCCCCCCC5F400000000021B42841000000C06D005841CDCCCCCCCCCC5F40CDCCCCCC41B42841333333B36C005841CDCCCCCCCCCC5F40', 'BATIMENT0000000314349993', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:31:35.02+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 122.6, 127.2, 128.9, 125.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333336B32841666666A62B0058410000000000405E400000000030B32841CDCCCCCC2C005841CDCCCCCCCC4C5E409A99999926B32841666666262C005841CDCCCCCCCC4C5E40666666662CB32841666666E62A005841CDCCCCCCCC4C5E403333333336B32841666666A62B0058410000000000405E40', 'BATIMENT0000000027748854', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.2, 119.0, NULL, 121.4, 120.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000BAB828410000002077005841CDCCCCCCCCEC574033333333B6B82841666666E677005841CDCCCCCCCCEC5740CDCCCCCCAFB828416666668677005841CDCCCCCCCCEC574000000000B3B82841666666C676005841CDCCCCCCCCEC5740CDCCCCCCB4B82841CDCCCC6C76005841CDCCCCCCCCEC57409A999999BBB82841333333D376005841CDCCCCCCCCEC574000000000BAB828410000002077005841CDCCCCCCCCEC5740', 'BATIMENT0000000314349997', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:01.716+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.7, 94.0, 95.7, 96.0, 94.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000CDB12841000000E0A90158419A99999999B95540CDCCCCCCBBB12841666666E6A9015841CDCCCCCCCCCC554000000000BBB12841333333F3A70158410000000000E055409A999999CBB12841CDCCCCECA70158416666666666E6554000000000CDB12841000000E0A90158419A99999999B95540', 'BATIMENT0000000304467905', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2012-10-19 08:32:17.321+02', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 84.4, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999995CB128419A9999F9C1015841CDCCCCCCCC2C55406666666657B12841CDCCCC6CC0015841CDCCCCCCCC2C55409A99999968B12841666666C6BF015841CDCCCCCCCC2C5540000000006CB128419A999959C101584133333333333355409A9999995CB128419A9999F9C1015841CDCCCCCCCC2C5540', 'BATIMENT0000000027745720', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2012-10-19 08:32:17.321+02', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 81.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999994EB12841000000C0870158413333333333135940CDCCCCCC44B12841666666E68701584133333333331359400000000044B1284166666626870158413333333333135940666666664EB12841666666068701584133333333331359409A9999994EB12841000000C0870158413333333333135940', 'BATIMENT0000000314350063', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.5, 94.8, 100.3, 101.2, 94.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F3B02841333333D3B10158413333333333B3554066666666F2B0284133333373AF0158413333333333B3554066666666FBB0284166666666AF0158413333333333B3554066666666FCB02841CDCCCCCCB10158413333333333B3554033333333F3B02841333333D3B10158413333333333B35540', 'BATIMENT0000000314350095', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 82.7, 86.8, 87.1, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999994B12841CDCCCCECA80158410000000000408FC06666666694B1284133333353A80158410000000000408FC066666666A2B1284166666626A80158410000000000408FC066666666A2B12841CDCCCC6CA80158410000000000408FC066666666A2B12841CDCCCCCCA80158410000000000408FC09A99999994B12841CDCCCCECA80158410000000000408FC0', 'BATIMENT0000000314350113', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 84.3, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000003333333321B12841666666C6AF015841CDCCCCCCCCEC5540CDCCCCCC21B12841333333D3B0015841CDCCCCCCCCEC55409A9999991BB12841000000E0B0015841CDCCCCCCCCEC55409A9999991CB1284133333373B2015841CDCCCCCCCCEC55409A9999991FB12841CDCCCC6CB2015841CDCCCCCCCCEC55409A9999991FB1284166666626B2015841CDCCCCCCCCEC55406666666625B128419A999919B2015841CDCCCCCCCCEC55409A99999924B12841666666C6AF015841CDCCCCCCCCEC55403333333321B12841666666C6AF015841CDCCCCCCCCEC5540', 'BATIMENT0000000314350122', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.3, 81.5, 87.8, 88.0, 82.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999B1B1284133333373970158410000000000005940CDCCCCCCB1B12841666666C697015841000000000000594000000000A9B12841666666C6970158410000000000005940CDCCCCCCA8B12841666666E6960158410000000000005940CDCCCCCCB1B12841000000E09601584100000000000059409A999999B1B1284133333373970158410000000000005940', 'BATIMENT0000000314350154', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 94.3, 100.0, 102.5, 96.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000000000000EAB22841000000E0A50158416666666666065840CDCCCCCCE6B22841333333F3A5015841666666666606584033333333E8B22841333333B3A601584166666666660658409A999999DBB22841CDCCCC0CA7015841666666666606584033333333D9B22841CDCCCCACA5015841666666666606584000000000DEB22841CDCCCC8CA50158416666666666065840CDCCCCCCDAB22841000000C0A301584166666666660658409A999999E5B22841CDCCCC6CA3015841666666666606584000000000EAB22841000000E0A50158416666666666065840', 'BATIMENT0000000314350156', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.5, 87.6, 96.1, 96.5, 88.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000009A999999F0B12841000000C09B0158410000000000005940CDCCCCCCF7B128419A9999B99D0158410000000000005940CDCCCCCCE4B12841333333D39E015841000000000000594066666666E4B12841333333B39E01584100000000000059409A999999E2B12841333333339E015841000000000000594066666666DBB12841000000A09E015841000000000000594066666666D6B12841000000409D015841000000000000594033333333E7B12841CDCCCC4C9C01584100000000000059409A999999F0B12841000000C09B0158410000000000005940', 'BATIMENT0000000314350180', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 95.3, 100.0, 100.2, 96.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333394BC2841333333732101584100000000000059409A9999999EBC284100000060210158416666666666265940000000009EBC2841333333D31F01584166666666662659400000000093BC2841666666E61F01584166666666660659403333333394BC284133333373210158410000000000005940', 'BATIMENT0000000304467886', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 98.0, NULL, 100.8, 98.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000006666666634BE284100000000290158416666666666C65840CDCCCCCC35BE28416666662625015841CDCCCCCCCCCC58406666666637BE28413333333323015841CDCCCCCCCCCC58400000000039BE2841333333B321015841CDCCCCCCCCCC5840333333332EBE284100000080210158413333333333F35840333333332DBE284166666626230158413333333333F35840333333332CBE2841CDCCCC2C250158413333333333F35840333333332ABE2841CDCCCCEC280158413333333333F358406666666634BE284100000000290158416666666666C65840', 'BATIMENT0000000304467877', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 96.6, NULL, 100.5, 97.9, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC34BD2841000000801B0158410000000000205940000000002DBD2841CDCCCC8C1B01584100000000002059409A9999992CBD2841CDCCCCAC190158410000000000205940CDCCCCCC34BD2841666666A6190158410000000000205940CDCCCCCC34BD2841000000801B0158410000000000205940', 'BATIMENT0000000304467882', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 1.9, 98.6, NULL, 101.3, 98.9, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999A0B2284166666646B90158416666666666865740CDCCCCCC99B2284100000080B901584166666666668657406666666699B22841CDCCCCECB80158416666666666865740CDCCCCCC9FB22841000000C0B801584166666666668657409A999999A0B2284166666646B90158416666666666865740', 'BATIMENT0000000314350176', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 89.5, 94.1, 94.5, 89.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000000000000E7BC2841666666E6060158416666666666265A4066666666E7BC28419A9999F90A0158419A99999999B95A400000000023BD2841000000E00A0158419A99999999B95A400000000022BD2841666666C6060158416666666666265A40333333330EBD2841666666C6060158416666666666265A409A9999990EBD284133333313080158416666666666865A409A999999FABC284100000020080158416666666666865A409A999999FABC28419A9999D9060158419A99999999395A4000000000E7BC2841666666E6060158416666666666265A40', 'BATIMENT0000000304467921', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.8, 101.1, NULL, 107.9, 101.5, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333A6BF28419A999919F60258410000000000408FC000000000A8BF28419A999979F50258410000000000408FC0CDCCCCCCADBF2841000000A0F50258410000000000408FC09A999999ABBF28419A999959F60258410000000000408FC033333333A6BF28419A999919F60258410000000000408FC0', 'BATIMENT0000000314350241', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', NULL, NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 82.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B0000009A999999B3B02841666666C6820258416666666666E6534066666666B3B0284133333353820258416666666666E6534000000000B9B0284133333333820258416666666666E6534033333333B8B0284100000080810258416666666666E653409A999999A3B02841333333D3810258416666666666E6534033333333A3B0284100000080810258416666666666E65340CDCCCCCC9DB028419A999999810258416666666666E65340666666669FB02841666666A6820258416666666666E653409A999999A4B02841CDCCCC8C820258416666666666E6534033333333A5B02841CDCCCC2C830258416666666666E653409A999999B3B02841666666C6820258416666666666E65340', 'BATIMENT0000000314350215', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:10.193+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 76.8, 79.6, 79.9, 77.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333389B028416666664682025841CDCCCCCCCCCC5340CDCCCCCC86B02841000000A07F025841CDCCCCCCCCCC53403333333382B02841CDCCCCAC7F025841CDCCCCCCCCCC53403333333384B028413333335382025841CDCCCCCCCCCC53403333333389B028416666664682025841CDCCCCCCCCCC5340', 'BATIMENT0000000314350213', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:10.193+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 77.0, 79.3, 82.0, 77.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666669FC12841000000002A0158419A99999999F957403333333392C12841CDCCCC4C2A0158419A99999999F957409A99999992C12841333333B3280158419A99999999F957409A9999999FC128419A999999280158419A99999999F95740666666669FC12841000000002A0158419A99999999F95740', 'BATIMENT0000000314350200', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:55.639+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.9, 94.0, 95.9, 100.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC04BB2841333333D3EA0258410000000000C052409A9999990EBB284133333353EB0258410000000000C052406666666611BB284100000020EA0258410000000000C052403333333307BB28419A9999B9E90258410000000000C05240CDCCCCCC04BB2841333333D3EA0258410000000000C05240', 'BATIMENT0000000027741999', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.0, 73.0, NULL, 76.9, 75.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999915BD2841CDCCCCECBB025841CDCCCCCCCC6C5440000000002EBD2841333333D3BA02584100000000006054406666666636BD284100000020BD025841CDCCCCCCCC2C5440333333331CBD284133333313BE02584133333333331354409A99999915BD2841CDCCCCECBB025841CDCCCCCCCC6C5440', 'BATIMENT0000000027741992', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.7, 77.0, NULL, 81.9, 77.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333BFBA2841CDCCCC4CE50258419A99999999D9524000000000D7BA28419A999919E60258419A99999999D9524066666666D3BA284166666686E70258419A99999999D952409A999999BBBA28419A9999B9E60258419A99999999D9524033333333BFBA2841CDCCCC4CE50258419A99999999D95240', 'BATIMENT0000000314350218', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.4, 73.0, 75.4, 77.7, 73.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000333333332BBB284133333333060358416666666666E653403333333339BB284100000080070358416666666666E653406666666636BB2841CDCCCC8C070358416666666666E653403333333336BB284166666686080358416666666666E65340CDCCCCCC26BB2841CDCCCC8C080358416666666666E65340CDCCCCCC24BB2841CDCCCCCC060358416666666666E65340333333332BBB284133333333060358416666666666E65340', 'BATIMENT0000000314350220', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 75.5, 79.6, 82.3, 76.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000003333333320BD284133333353A40258416666666666A65440CDCCCCCC32BD28419A999919A50258416666666666A654409A9999992CBD284100000080A70258416666666666A654403333333326BD284166666626A70258416666666666A654406666666623BD2841CDCCCCECA70258416666666666A65440333333331BBD28419A999999A70258416666666666A65440333333331DBD28419A9999D9A60258416666666666A65440000000001BBD2841CDCCCCACA60258416666666666A654403333333320BD284133333353A40258416666666666A65440', 'BATIMENT0000000314350226', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.6, 77.0, 82.6, 84.8, 77.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000E4C3284100000040BB0258416666666666265640CDCCCCCCDAC3284166666626BB025841666666666626564066666666DDC328419A9999F9B8025841666666666626564000000000E6C328419A999939B9025841666666666626564000000000E4C3284100000040BB0258416666666666265640', 'BATIMENT0000000314350244', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:23.236+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 84.0, 88.6, 90.0, 84.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666FBC3284133333353C802584166666666660656400000000007C4284166666606C202584166666666660656409A9999991CC42841000000A0C202584166666666660656409A99999912C42841666666E6C8025841666666666606564066666666FBC3284133333353C80258416666666666065640', 'BATIMENT0000000314350242', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:23.236+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 84.0, 88.1, 89.1, 84.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333345BD2841666666469E025841CDCCCCCCCC6C5440CDCCCCCC77BD28413333331399025841CDCCCCCCCC6C54400000000084BD2841000000609B025841CDCCCCCCCC6C54406666666652BD28419A999919A0025841CDCCCCCCCC6C54403333333345BD2841666666469E025841CDCCCCCCCC6C5440', 'BATIMENT0000000314350232', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 77.0, 81.7, 85.4, 77.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999C6B82841CDCCCCCC8B025841CDCCCCCCCC6C544000000000B7B82841000000008B025841CDCCCCCCCC6C544000000000BBB82841CDCCCCCC89025841CDCCCCCCCC6C5440CDCCCCCCBCB828419A99993989025841CDCCCCCCCC6C54409A999999C9B82841CDCCCC6C85025841CDCCCCCCCC6C544033333333D9B828410000004086025841CDCCCCCCCC6C544033333333CAB828419A9999B98A025841CDCCCCCCCC6C54409A999999C6B82841CDCCCCCC8B025841CDCCCCCCCC6C5440', 'BATIMENT0000000314350233', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.5, 76.2, 81.7, 82.5, 76.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333FCAC2841333333738B045841CDCCCCCCCC8C4D409A999999FAAC2841CDCCCCAC89045841CDCCCCCCCC8C4D400000000017AD28410000004089045841CDCCCCCCCC8C4D403333333318AD2841333333138B045841CDCCCCCCCC8C4D4033333333FCAC2841333333738B045841CDCCCCCCCC8C4D40', 'BATIMENT0000000314350207', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:05.473+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.1, 52.0, 59.1, 60.0, 54.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCB1B5284133333313ACFE57410000000000408FC000000000AEB52841CDCCCCCCACFE57410000000000408FC033333333A9B5284166666646ACFE57410000000000408FC0CDCCCCCCA6B528419A999939ACFE57410000000000408FC066666666A2B52841000000A0ABFE57410000000000408FC066666666A7B52841000000E0AAFE57410000000000408FC0CDCCCCCCB1B5284133333313ACFE57410000000000408FC0', 'BATIMENT0000000314331668', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:14.231+02', '2012-11-19 17:15:21.754+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 86.9, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000120000006666666646AD2841000000404B0258416666666666E65440666666664BAD28419A9999794B0258410000000000E05440000000004EAD2841333333934B0258416666666666E654406666666656AD28419A9999F94B0258416666666666E654409A99999954AD2841CDCCCCCC4C0258416666666666E65440666666665CAD28419A9999194D0258416666666666E65440666666665EAD2841333333334D0258416666666666E65440000000005EAD2841666666864D0258416666666666E654403333333363AD28419A9999B94D0258416666666666E654406666666660AD2841000000C04E0258416666666666E65440333333334CAD2841333333F34D0258416666666666E65440333333334CAD2841CDCCCC0C4E0258416666666666E654406666666640AD2841000000A04D0258416666666666E654409A99999942AD2841000000A04C0258416666666666E654400000000048AD2841333333D34C0258416666666666E654403333333349AD2841333333534C0258416666666666E654403333333344AD2841333333134C0258416666666666E654406666666646AD2841000000404B0258416666666666E65440', 'BATIMENT0000000314349769', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 79.5, 83.6, 85.3, 80.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000009A999999CEAD2841000000A0390158419A9999999959564066666666D0AD284100000040380158419A9999999959564033333333DBAD284100000080380158419A9999999959564033333333E9AD28419A9999D9380158419A9999999959564033333333EEAD28419A9999F9380158419A9999999959564033333333EBAD2841333333B33A0158419A9999999959564033333333E0AD2841000000803A0158419A9999999959564033333333E1AD28419A9999F9390158419A999999995956409A999999CEAD2841000000A0390158419A99999999595640', 'BATIMENT0000000314347569', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.4, 86.0, 89.4, 90.6, 87.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCB7AF284133333353C30158410000000000A05440CDCCCCCCB5AF28419A9999D9C50158410000000000A0544000000000B1AF28419A9999D9C50158410000000000A05440CDCCCCCCB0AF28419A999979C50158410000000000A0544033333333ACAF2841CDCCCC6CC50158410000000000A054409A99999998AF2841CDCCCC4CC50158410000000000A05440333333339BAF284166666626C30158410000000000A05440CDCCCCCCB7AF284133333353C30158410000000000A05440', 'BATIMENT0000000314348534', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.5, 78.0, 82.5, 84.5, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000006666666636AD2841666666E6A5015841CDCCCCCCCCCC5340CDCCCCCC2DAD28419A9999F9A5015841CDCCCCCCCCCC53409A9999992DAD28419A999939A5015841CDCCCCCCCCCC5340666666662BAD28419A999939A5015841CDCCCCCCCCCC5340CDCCCCCC2BAD284166666666A4015841CDCCCCCCCCCC5340666666662CAD2841666666A6A3015841CDCCCCCCCCCC5340666666662FAD28419A999999A3015841CDCCCCCCCCCC53400000000036AD284166666646A4015841CDCCCCCCCCCC53406666666636AD2841666666E6A5015841CDCCCCCCCCCC5340', 'BATIMENT0000000314348462', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 74.0, 79.2, 79.7, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999BAAA2841CDCCCCECD70158410000000000408FC000000000BBAA2841CDCCCC4CD70158410000000000408FC09A999999D4AA2841666666A6D70158410000000000408FC000000000D4AA284166666646D80158410000000000408FC09A999999BAAA2841CDCCCCECD70158410000000000408FC0', 'BATIMENT0000000314348732', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2015-12-17 10:23:23.586+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 71.6, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C0000006666666665A7284100000000700258413333333333935240CDCCCCCC6BA72841666666066F02584133333333339352409A99999963A72841333333336E0258413333333333935240CDCCCCCC66A72841000000A06D02584133333333339352409A9999995BA72841000000806C0258413333333333B352400000000054A72841CDCCCCAC6D0258413333333333935240333333335BA72841333333336E0258413333333333935240CDCCCCCC5EA72841666666266E02584133333333339352409A99999960A72841333333536E0258413333333333935240CDCCCCCC5DA72841000000206F02584133333333339352400000000063A728419A9999B96F02584133333333339352406666666665A7284100000000700258413333333333935240', 'BATIMENT0000000336718578', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.3, 69.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000009A9999994FAC28419A999959E701584100000000008052400000000046AC284100000040E601584100000000006052409A9999994FAC28419A999919E501584166666666666652403333333354AC2841666666A6E501584166666666666652409A9999995AAC284166666666E601584166666666666652403333333356AC284133333313E701584166666666668652406666666653AC2841666666C6E60158416666666666865240CDCCCCCC51AC284166666606E701584166666666668652409A9999994FAC28419A999959E70158410000000000805240', 'BATIMENT0000000336718484', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.7, 71.4, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999C4B728419A999959440258416666666666E6544033333333BDB72841CDCCCC8C45025841CDCCCCCCCCEC5440CDCCCCCCB0B728410000004044025841CDCCCCCCCCEC544000000000B9B728419A99991943025841CDCCCCCCCCEC54409A999999C4B728419A999959440258416666666666E65440', 'BATIMENT0000000336718486', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 80.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000006666666677B528419A999959EEFF57416666666666465D406666666676B5284166666686EFFF5741CDCCCCCCCC6C5D403333333366B5284166666666EFFF5741CDCCCCCCCC6C5D409A99999967B52841CDCCCC6CEDFF5741CDCCCCCCCC6C5D403333333370B5284166666666EDFF5741CDCCCCCCCC6C5D40CDCCCCCC6FB5284166666646EEFF5741CDCCCCCCCC6C5D406666666677B528419A999959EEFF57416666666666465D40', 'BATIMENT0000000336718526', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 114.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCFEAE2841CDCCCCEC170158410000000000C056400000000000AF2841666666261A0158410000000000C05640CDCCCCCCF5AE2841CDCCCC2C1A0158410000000000C0564033333333F5AE284100000040190158410000000000C0564066666666EEAE284100000040190158410000000000C0564033333333EDAE284133333333180158410000000000C05640CDCCCCCCFEAE2841CDCCCCEC170158410000000000C05640', 'BATIMENT0000000336718542', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 87.3, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000D000000CDCCCCCC33AC2841000000E0F00158419A99999999795240CDCCCCCC2EAC284133333353F00158419A999999997952409A99999933AC284133333393EF0158419A99999999795240333333332EAC2841CDCCCCECEE0158419A99999999795240000000003DAC2841CDCCCCCCEC0158419A999999997952403333333344AC2841000000A0ED015841CDCCCCCCCC6C52409A9999993CAC2841333333D3EE015841CDCCCCCCCC6C52406666666644AC2841CDCCCCACEF015841CDCCCCCCCC6C52406666666640AC284100000040F0015841CDCCCCCCCC6C5240000000003FAC284133333373F0015841CDCCCCCCCC6C5240000000003BAC284166666606F10158419A999999997952403333333339AC2841CDCCCC4CF10158419A99999999795240CDCCCCCC33AC2841000000E0F00158419A99999999795240', 'BATIMENT0000000336718560', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 70.2, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333A7B42841000000C0B701584133333333339355403333333395B4284100000060B90158413333333333935540666666668EB428419A999919B80158413333333333935540CDCCCCCC9FB4284166666686B6015841333333333393554033333333A7B42841000000C0B70158413333333333935540', 'BATIMENT0000000336718664', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 83.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCF0A7284166666686DD0058419A99999999996040CDCCCCCCECA728419A999959DF0058419A99999999996040CDCCCCCCDCA72841000000E0DE0058419A9999999999604000000000E1A7284166666606DD0058419A99999999996040CDCCCCCCF0A7284166666686DD0058419A99999999996040', 'BATIMENT0000000336718634', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.1, 129.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCFFAB28419A999939EE0158413333333333335340666666660EAC2841CDCCCCCCEE01584133333333331353403333333312AC284100000020ED015841CDCCCCCCCCAC52406666666605AC2841666666A6EC015841CDCCCCCCCCAC52406666666603AC284133333393EC015841CDCCCCCCCCAC5240CDCCCCCCFFAB28419A999939EE0158413333333333335340', 'BATIMENT0000000336718635', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.3, 70.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333B5B32841666666E6CDFF57416666666666E65B4033333333ADB32841CDCCCC4CCEFF5741CDCCCCCCCCEC5B4066666666A8B32841CDCCCCECCCFF5741CDCCCCCCCCEC5B4033333333B0B328419A999979CCFF5741CDCCCCCCCCEC5B4033333333B5B32841666666E6CDFF57416666666666E65B40', 'BATIMENT0000000336718662', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 109.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000039AB2841666666C6D901584100000000006052403333333337AB28419A999979DB01584166666666666652409A99999922AB28419A999919DB01584166666666666652409A99999924AB284133333373D901584166666666666652400000000039AB2841666666C6D90158410000000000605240', 'BATIMENT0000000336718663', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.6, 70.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A99999980B528419A9999F9F0FF57413333333333D35D40333333337FB52841CDCCCC0CF2FF57413333333333D35D409A99999969B52841000000A0F1FF57413333333333D35D40CDCCCCCC69B52841CDCCCC0CF1FF57413333333333D35D40CDCCCCCC6DB5284133333313F1FF57413333333333D35D40333333336EB52841666666A6F0FF57413333333333D35D409A99999980B528419A9999F9F0FF57413333333333D35D40', 'BATIMENT0000000336718667', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 115.6, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999D9B628419A999959FC0158419A9999999939564033333333D8B6284100000020FE0158419A9999999959564000000000B7B62841CDCCCCCCFD0158419A9999999959564066666666B8B628419A9999F9FB0158419A999999995956409A999999D9B628419A999959FC0158419A99999999395640', 'BATIMENT0000000336718669', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 86.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA0A72841333333B36D0258416666666666265240CDCCCCCC91A728419A9999D96F025841CDCCCCCCCC2C52403333333388A728419A9999D96E025841CDCCCCCCCC2C52406666666697A72841333333B36C025841CDCCCCCCCC4C5240CDCCCCCCA0A72841333333B36D0258416666666666265240', 'BATIMENT0000000336718670', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 70.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F9A528419A999959240158410000000000805640CDCCCCCCF6A528413333335325015841000000000080564000000000E8A52841333333B3240158410000000000805640CDCCCCCCEAA52841666666C623015841000000000080564033333333F9A528419A999959240158410000000000805640', 'BATIMENT0000000336718671', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.1, 86.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC87B12841666666A694FF57416666666666A65B409A99999990B12841000000E094FF5741CDCCCCCCCCAC5B40000000008EB128410000008096FF5741CDCCCCCCCCAC5B409A99999984B128419A99993996FF5741CDCCCCCCCCAC5B40CDCCCCCC87B12841666666A694FF57416666666666A65B40', 'BATIMENT0000000336718672', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 107.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000D4AF2841666666C6A9FF57410000000000C0574066666666D1AF2841CDCCCCECAAFF57416666666666C6574066666666C5AF284166666686AAFF57416666666666C6574000000000C8AF28419A999959A9FF57416666666666C6574000000000D4AF2841666666C6A9FF57410000000000C05740', 'BATIMENT0000000336718673', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.0, 93.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333348A4284133333333D201584100000000004053403333333346A4284133333333D301584166666666664653409A99999937A42841666666C6D20158416666666666465340000000003AA42841666666C6D101584166666666664653403333333348A4284133333333D20158410000000000405340', 'BATIMENT0000000336718677', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 74.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B000000CDCCCCCCFDA728419A999959DA0058419A999999996960409A999999FBA72841333333B3DB0058419A999999996960409A999999EFA7284166666686DB0058419A9999999969604066666666EFA7284166666666DB0058419A9999999969604000000000EBA7284166666646DB0058419A9999999969604033333333EBA7284133333353DA0058419A9999999979604000000000F0A7284166666666DA0058419A99999999796040CDCCCCCCF0A728419A9999D9D90058419A99999999796040CDCCCCCCF7A72841CDCCCCECD90058419A9999999979604033333333F7A7284133333333DA0058419A99999999796040CDCCCCCCFDA728419A999959DA0058419A99999999696040', 'BATIMENT0000000336718693', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 129.2, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCB6B72841CDCCCCAC410258410000000000C054409A999999ADB7284100000020430258416666666666C654400000000098B72841CDCCCC0C410258416666666666C6544000000000A2B72841333333933F0258416666666666C65440CDCCCCCCB6B72841CDCCCCAC410258410000000000C05440', 'BATIMENT0000000336718694', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.1, 80.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333354B5284133333353AC0158410000000000A056403333333357B528419A999999B30158410000000000A05640CDCCCCCC47B52841000000C0B30158410000000000A056403333333345B528419A999979AC0158410000000000A056403333333354B5284133333353AC0158410000000000A05640', 'BATIMENT0000000336718695', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 86.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000006666666625AD28419A9999B92B0058419A99999999D958409A99999910AD2841333333D32B0058419A99999999D958409A99999910AD2841666666062A0058419A99999999D958409A99999920AD2841333333F3290058419A99999999F958403333333325AD28419A9999F9290058419A99999999D958403333333325AD2841000000A02A0058419A99999999D958406666666625AD2841666666462B0058419A99999999D958406666666625AD28419A9999B92B0058419A99999999D95840', 'BATIMENT0000000336718699', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 96.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999992EAD2841CDCCCC2C87045841CDCCCCCCCC0C4D409A9999992AAD284166666626850458419A99999999994D403333333320AD284166666666850458419A99999999994D40CDCCCCCC21AD2841CDCCCC4C870458413333333333B34C409A9999992EAD2841CDCCCC2C87045841CDCCCCCCCC0C4D40', 'BATIMENT0000000336750617', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.2, 53.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333B6AC2841333333D37A0458416666666666264B40CDCCCCCCBDAC2841000000C0800458416666666666264B40CDCCCCCCAEAC2841CDCCCC0C810458416666666666264B4000000000A6AC2841CDCCCC4C7B0458416666666666264B4033333333B6AC2841333333D37A0458416666666666264B40', 'BATIMENT0000000336750714', 'Serre', 'Agricole', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.5, 50.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333306B22841666666E662035841000000000060524066666666FAB128419A9999196303584166666666666652409A999999F6B128410000000061035841CDCCCCCCCC8C52400000000004B228419A9999F9600358410000000000C052406666666605B22841CDCCCC2C6203584166666666668652403333333306B22841666666E6620358410000000000605240', 'BATIMENT0000000336750674', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.6, 69.4, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000001EB32841666666A6220458410000000000005340CDCCCCCC1FB328410000006025045841666666666606534000000000F7B22841CDCCCCAC2504584166666666660653409A999999F5B228419A999919230458416666666666065340000000001EB32841666666A6220458410000000000005340', 'BATIMENT0000000336750686', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.4, 71.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000000DB3284166666646270458410000000000005340000000000EB32841000000C029045841666666666606534033333333E6B228419A9999192A0458416666666666065340CDCCCCCCE4B22841666666C6270458416666666666065340000000000DB3284166666646270458410000000000005340', 'BATIMENT0000000336750688', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.3, 70.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666694AC28419A9999197C0458413333333333B34A40666666669BAC284166666686810458413333333333B34A40333333338DAC2841333333D3810458413333333333B34A406666666686AC28419A9999797C0458413333333333B34A406666666694AC28419A9999197C0458413333333333B34A40', 'BATIMENT0000000336750706', 'Serre', 'Agricole', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.6, 50.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999E6AC284100000060A7025841000000000000524000000000E8AC2841CDCCCC8CA8025841666666666606524066666666D3AC2841000000E0A8025841666666666606524066666666D1AC2841333333B3A702584166666666660652409A999999E6AC284100000060A70258410000000000005240', 'BATIMENT0000000336750771', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.7, 69.4, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000066666666E9C1284133333373C102584100000000004055409A999999E7C128419A999959C3025841000000000040554033333333DCC1284166666646C302584100000000004055409A999999DBC128419A999999C3025841000000000040554000000000CCC128419A999959C3025841000000000040554033333333CDC12841666666E6C10258410000000000405540CDCCCCCCCFC12841666666E6C102584100000000004055409A999999D1C1284100000020C10258413333333333535540CDCCCCCCE7C12841CDCCCC6CC1025841000000000040554066666666E9C1284133333373C10258410000000000405540', 'BATIMENT0000000336750801', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:21:26.99+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.0, 81.3, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA2BA284133333373040158410000000000A0574033333333A3BA284133333393050158416666666666A657406666666691BA2841666666A6050158416666666666A65740CDCCCCCC90BA28419A999999040158416666666666A65740CDCCCCCCA2BA284133333373040158410000000000A05740', 'BATIMENT0000000336754834', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 15:25:50.055+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.1, 91.5, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000099BA284100000060090158410000000000C05740CDCCCCCC9ABA2841666666C60A0158410000000000C05740CDCCCCCC88BA2841333333330B0158410000000000C05740CDCCCCCC85BA284100000040090158410000000000C05740CDCCCCCC8DBA284166666606090158410000000000A057409A9999998EBA2841CDCCCC8C090158410000000000C057400000000099BA284100000060090158410000000000C05740', 'BATIMENT0000000336754835', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 15:25:50.055+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.2, 90.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000FEBB2841000000803D0158416666666666865840CDCCCCCC00BC28419A9999393F015841CDCCCCCCCC8C58409A999999F2BB2841333333933F015841CDCCCCCCCC8C5840CDCCCCCCEFBB28419A9999F93D015841CDCCCCCCCC8C584000000000FEBB2841000000803D0158416666666666865840', 'BATIMENT0000000336754840', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 15:26:07.782+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.2, 95.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000072C32841333333F34501584133333333335357409A99999973C32841666666464901584133333333335357403333333366C32841333333734901584133333333335357403333333364C32841333333334601584133333333335357400000000072C32841333333F3450158413333333333535740', 'BATIMENT0000000336754885', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 15:28:18.106+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 89.6, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000083C32841000000C04101584133333333337357409A99999984C32841000000E04301584133333333337357400000000072C32841CDCCCC0C4401584133333333337357400000000070C32841CDCCCCEC4101584133333333337357400000000083C32841000000C0410158413333333333735740', 'BATIMENT0000000336754886', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 15:28:18.106+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.7, 88.1, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000E000000CDCCCCCC5CB22841333333B35F0358413333333333B352409A9999996EB22841000000A05F0358413333333333335340666666666EB228419A9999995D0358413333333333335340CDCCCCCC6AB22841333333935D0358416666666666E652409A9999996BB22841CDCCCC4C590358416666666666C65240000000007FB2284133333353590358416666666666C652409A9999997EB22841CDCCCC4C5F0358416666666666C652400000000080B228419A9999595F0358416666666666C65240CDCCCCCC7FB228419A999999610358416666666666C652400000000070B22841666666C6610358416666666666A65240CDCCCCCC6FB2284166666606620358416666666666A65240333333335EB2284133333313620358416666666666865240000000005DB228413333331360035841CDCCCCCCCCAC5240CDCCCCCC5CB22841333333B35F0358413333333333B35240', 'BATIMENT0000000336750773', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-05-27 18:14:18.417+02', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.9, 69.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000010000000CDCCCCCCD3AD28416666660649015841333333333313584066666666DCAD28419A999959490158413333333333135840CDCCCCCCDFAD2841000000E048015841333333333313584066666666E4AD2841666666A64801584133333333331358409A999999E8AD2841666666C648015841333333333313584000000000ECAD2841CDCCCC0C49015841333333333313584066666666EDAD2841000000A049015841333333333313584000000000EDAD2841333333334A0158413333333333135840CDCCCCCCEAAD2841333333934A01584133333333331358409A999999E5AD2841666666E64A0158413333333333135840CDCCCCCCE2AD2841333333F34A015841333333333313584033333333DEAD2841333333B34A015841333333333313584066666666D9AD2841666666E64B015841333333333313584033333333CCAD2841666666064B0158413333333333135840CDCCCCCCCDAD28419A9999994A0158413333333333135840CDCCCCCCD3AD284166666606490158413333333333135840', 'BATIMENT0000000314347626', 'Château', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2016-09-26 11:04:53.601+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 13.9, 82.4, 96.3, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333A4B8284133333313770058410000000000605940CDCCCCCC8BB82841666666867F005841000000000060594066666666F5B72841666666E6780058410000000000A05940CDCCCCCC0EB828413333333370005841000000000060594033333333A4B8284133333313770058410000000000605940', 'BATIMENT0000000336718649', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2014-07-30 18:21:33.522+02', '2016-12-09 17:12:28.38+01', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 7.3, 95.2, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000E0000009A999999F3B82841000000A06B0058416666666666C658409A999999EBB82841CDCCCC0C6E0058416666666666C6584066666666DAB82841000000206D0058416666666666C6584033333333D9B82841333333136D0058416666666666C6584066666666E9B828419A999959680058416666666666C658409A999999ECB8284100000080680058416666666666C658409A999999FBB82841CDCCCC4C690058416666666666C6584033333333FEB82841CDCCCC6C690058416666666666C658406666666620B92841000000406B0058416666666666C658409A99999924B92841666666066A0058416666666666C65840333333332FB928419A9999996A0058416666666666C658409A99999922B92841333333336E0058416666666666C6584066666666F6B82841666666C66B0058416666666666C658409A999999F3B82841000000A06B0058416666666666C65840', 'BATIMENT0000000314349996', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2012-10-19 08:32:01.716+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 94.1, 99.1, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999927B9284166666646820058416666666666065840333333332EB928419A9999B98200584166666666660658406666666640B92841333333F3830058416666666666065840666666663DB92841666666A68400584166666666660658409A99999924B92841666666268300584166666666660658409A99999927B9284166666646820058416666666666065840', 'BATIMENT0000000027747421', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 1.1, 95.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000FEAC284166666646910458416666666666A64C409A999999FDAC28419A99999993045841CDCCCCCCCC8C4D40CDCCCCCC2EAD28410000002093045841CDCCCCCCCC8C4D400000000032AD28419A9999D99A0458413333333333F34D40CDCCCCCCE8AC2841000000A09B0458413333333333F34D40CDCCCCCCE4AC2841666666A6910458416666666666A64C4000000000FEAC284166666646910458416666666666A64C40', 'BATIMENT0000000336750766', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-12-09 17:12:28.38+01', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 7.0, 52.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333333EAB2841000000609F0158410000000000205540333333333FAB2841000000609F0158410000000000205540000000003AAB2841666666A6A601584100000000002055400000000027AB284166666666A601584100000000002055409A9999992BAB2841333333339F0158410000000000205540333333333EAB2841000000609F0158410000000000205540', 'BATIMENT0000000314349204', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 10.4, 74.1, 84.5, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666689AA2841666666A694015841CDCCCCCCCCAC5340666666668AAA2841000000E093015841CDCCCCCCCCAC534033333333A4AA28410000004094015841CDCCCCCCCCAC534033333333A3AA2841CDCCCC0C95015841CDCCCCCCCCAC53406666666689AA2841666666A694015841CDCCCCCCCCAC5340', 'BATIMENT0000000314349314', 'Industriel, agricole ou commercial', 'Commercial et services', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 74.0, 78.7, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666668AAA2841000000E0930158419A99999999D95340CDCCCCCC93AA2841333333938B0158419A99999999D9534066666666C8AA2841CDCCCC6C8C0158419A99999999D9534033333333BFAA2841000000C0940158419A99999999D9534033333333A4AA284100000040940158419A99999999D95340666666668AAA2841000000E0930158419A99999999D95340', 'BATIMENT0000000314349315', 'Industriel, agricole ou commercial', 'Commercial et services', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.6, 72.8, 79.4, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999EFA92841CDCCCC8C88035841CDCCCCCCCC4C50409A99999910AA28410000004087035841CDCCCCCCCC4C50403333333318AA2841000000608A035841CDCCCCCCCC4C504066666666F8A92841666666A68B035841CDCCCCCCCC4C50409A999999EFA92841CDCCCC8C88035841CDCCCCCCCC4C5040', 'BATIMENT0000000314340951', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:10:48.171+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 59.5, 65.2, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000003333333380AA28419A999999C0035841CDCCCCCCCCCC4C40CDCCCCCC8BAA28419A999919B8035841CDCCCCCCCCCC4C4033333333BFAA284133333333B9035841CDCCCCCCCCCC4C40000000009AAA284100000020D3035841CDCCCCCCCCCC4C400000000077AA284100000060D2035841CDCCCCCCCCCC4C403333333374AA28419A999959D0035841CDCCCCCCCCCC4C40CDCCCCCC77AA284133333373CE035841CDCCCCCCCCCC4C40666666668BAA2841CDCCCCECC0035841CDCCCCCCCCCC4C403333333380AA28419A999999C0035841CDCCCCCCCCCC4C40', 'BATIMENT0000000314340955', 'Industriel, agricole ou commercial', 'Industriel', NULL, false, 'En service', '2012-10-19 08:10:48.171+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.7, 49.9, 57.6, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999992AB92841666666867D00584166666666660658403333333315B9284133333313820058416666666666065840333333331DB92841666666E68200584166666666660658409A99999932B928419A9999397E00584166666666660658409A9999992AB92841666666867D0058416666666666065840', 'BATIMENT0000000027747422', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 1.1, 95.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C00000033333333D8B42841666666863E0358416666666666E6504000000000D8B42841000000C040035841CDCCCCCCCCAC50409A999999B2B42841CDCCCC8C410358410000000000E0504066666666B5B4284100000020440358419A9999999959504000000000BCB428419A9999D946035841333333333373504000000000E7B428419A999999440358410000000000C0504066666666E1B4284166666646420358413333333333F350403333333359B528419A9999193D0358413333333333F350409A999999C2B528419A9999D9370358413333333333F35040CDCCCCCCB5B528419A999919340358413333333333F35040333333335BB528419A9999F9380358413333333333F3504033333333D8B42841666666863E0358416666666666E65040', 'BATIMENT0000000027742003', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 7.8, 60.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C0000009A99999927B9284166666646820058410000000000005840666666662AB928419A9999B98100584166666666660658406666666643B928419A9999598300584166666666660658409A9999994BB92841666666E6800058416666666666065840CDCCCCCC56B92841000000808100584166666666660658409A9999994AB928419A999939850058416666666666065840666666663DB92841666666A68400584166666666660658406666666640B92841333333F38300584166666666660658409A99999930B92841666666E6820058416666666666065840333333332EB928419A9999B98200584166666666660658409A9999992CB928419A9999998200584166666666660658409A99999927B9284166666646820058410000000000005840', 'BATIMENT0000000336754824', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2014-07-31 15:25:26.454+02', '2016-12-09 17:12:28.38+01', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.2, 91.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCDAB32841000000A0B70158413333333333535740CDCCCCCC78B328419A999939BA01584133333333335357400000000074B3284100000060B7015841333333333353574033333333D6B32841333333D3B40158413333333333535740CDCCCCCCDAB32841000000A0B70158413333333333535740', 'BATIMENT0000000314350118', 'Industriel, agricole ou commercial', 'Industriel', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 88.6, 93.3, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333332AB2841CDCCCC4C060258419A999999991952409A9999991BAB284133333333050258419A999999991952403333333320AB2841000000A0030258419A99999999195240CDCCCCCC36AB2841333333B3040258419A999999991952403333333332AB2841CDCCCC4C060258419A99999999195240', 'BATIMENT0000000314348767', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.4, 70.0, 72.4, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999992EAB2841000000C0590358413333333333B35140666666664CAB2841CDCCCC2C590358413333333333B35140333333334FAB2841CDCCCC8C5B0358413333333333B351403333333343AB2841000000C05B0358413333333333B351406666666631AB28419A9999195C0358413333333333B35140CDCCCCCC30AB2841000000A05B0358413333333333B351409A9999992EAB2841000000C0590358413333333333B35140', 'BATIMENT0000000314341028', 'Industriel, agricole ou commercial', 'Industriel', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 66.0, 70.8, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000066666666E1B4284166666646420358413333333333F3504000000000E7B428419A999999440358410000000000C05040CDCCCCCCCCB528419A9999993A0358410000000000C0504000000000C5B52841333333D3370358410000000000C0504000000000CEB5284166666666370358410000000000C0504066666666C3B52841000000A0330358416666666666E65040CDCCCCCCB5B528419A999919340358413333333333F350409A999999C2B528419A9999D9370358413333333333F350403333333359B528419A9999193D0358413333333333F3504066666666E1B4284166666646420358413333333333F35040', 'BATIMENT0000000206310065', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2008-09-25 16:47:29.261+02', '2016-12-09 17:12:28.38+01', NULL, '2006-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.9, 61.9, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333302AA2841333333D35E0358410000000000405140333333330CAA28419A9999B95E0358410000000000405140000000000EAA2841333333336103584100000000004051409A99999903AA2841CDCCCC4C610358413333333333B350403333333302AA2841333333D35E0358410000000000405140', 'BATIMENT0000000357803231', 'Industriel, agricole ou commercial', 'Industriel', NULL, false, 'En service', '2016-06-30 17:09:04.829+02', '2016-12-09 17:12:28.38+01', NULL, '2015-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.2, 62.8, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000F0000003333333322AA284133333373650358416666666666A65140CDCCCCCC22AA2841333333F3650358416666666666A65140CDCCCCCC23AA28419A999939660358410000000000A051406666666626AA28419A999999660358419A999999999951406666666629AA2841000000E066035841CDCCCCCCCC8C5140666666662CAA2841333333F36603584100000000008051409A99999931AA2841333333F3660358419A999999997951409A99999935AA2841CDCCCCCC660358419A99999999795140CDCCCCCC37AA2841666666A6660358413333333333735140CDCCCCCC39AA284133333353660358413333333333535140666666663DAA284100000020690358416666666666E65040000000004DAA2841333333D36803584133333333331351409A9999993EAA2841333333535E03584100000000004051409A99999943AA28419A9999196503584100000000004051403333333322AA284133333373650358416666666666A65140', 'BATIMENT0000000357803415', 'Industriel, agricole ou commercial', 'Industriel', NULL, false, 'En service', '2016-06-30 17:09:04.829+02', '2016-12-09 17:12:28.38+01', NULL, '2015-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 7.6, 63.0, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000066666666FAB52841CDCCCC0C530158410000000000C057400000000003B62841333333134D0158416666666666C6574033333333ECB52841666666864C0158413333333333D357409A999999E9B52841000000004E015841CDCCCCCCCCCC57409A999999E1B52841000000C04D0158410000000000A0574000000000DFB528419A9999594F0158416666666666A6574033333333E7B52841333333934F0158416666666666C6574000000000E3B5284166666686520158413333333333D3574066666666FAB52841CDCCCC0C530158410000000000C05740', 'BATIMENT0000000357803020', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2016-06-30 17:09:04.829+02', '2016-12-09 17:12:28.38+01', NULL, '2015-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 5.1, 90.2, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666D9AA284133333333950158416666666666465540CDCCCCCCDAAA28419A9999D99301584166666666664655400000000003AB28419A999959940158416666666666465540CDCCCCCC08AB2841000000609401584166666666664655409A99999907AB28419A9999F995015841666666666646554066666666D9AA284133333333950158416666666666465540', 'BATIMENT0000000314349202', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 11.0, 74.1, 85.1, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333334BAF2841CDCCCC4C4E0158410000000000408FC0666666665AAF28419A9999D94E0158410000000000408FC0CDCCCCCC56AF284133333313500158410000000000408FC03333333345AF28419A9999594F0158410000000000408FC0333333334BAF2841CDCCCC4C4E0158410000000000408FC0', 'BATIMENT0000000314347672', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 85.2, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000006666666620B92841000000406B0058410000000000408FC033333333FEB82841CDCCCC6C690058410000000000408FC09A999999FBB82841CDCCCC4C690058410000000000408FC0CDCCCCCCFFB82841CDCCCC0C680058410000000000408FC06666666602B9284133333333680058410000000000408FC09A99999924B92841666666066A0058410000000000408FC06666666620B92841000000406B0058410000000000408FC0', 'BATIMENT0000000314349995', 'Industriel, agricole ou commercial', 'Agricole', NULL, true, 'En service', '2012-10-19 08:32:01.716+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 94.1, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC6FA92841CDCCCC4C7B01584133333333333355406666666631A92841CDCCCC8C7C01584133333333333355409A99999923A92841000000807101584133333333333355406666666661A9284100000040700158413333333333335540CDCCCCCC6FA92841CDCCCC4C7B0158413333333333335540', 'BATIMENT0000000314347491', 'Indifférenciée', 'Sportif', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2016-12-09 17:12:28.38+01', NULL, '2016-01-01', 'MSS_2016', 'MSS:201073', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.9, 77.9, 84.8, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999990AAB28419A999999020258410000000000408FC06666666606AB284133333333040258410000000000408FC0CDCCCCCCE5AA28419A999999020258410000000000408FC033333333EAAA2841CDCCCC0C010258410000000000408FC09A9999990AAB28419A999999020258410000000000408FC0', 'BATIMENT0000000314348766', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 70.0, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000003AB28419A999959940158410000000000605540CDCCCCCCDAAA28419A9999D993015841000000000060554066666666E2AA2841666666468B0158410000000000605540666666660AAB2841666666C68B01584100000000006055400000000003AB28419A999959940158410000000000605540', 'BATIMENT0000000314349205', 'Industriel, agricole ou commercial', 'Industriel', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 11.4, 74.1, 85.5, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC3DB02841666666A6280258410000000000408FC00000000041B02841CDCCCCAC270258410000000000408FC0CDCCCCCC46B02841666666E6270258410000000000408FC00000000044B02841CDCCCCEC280258410000000000408FC0CDCCCCCC3DB02841666666A6280258410000000000408FC0', 'BATIMENT0000000314349892', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 85.6, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333C9B42841CDCCCC8C4B0358416666666666E650406666666680B528419A99999943035841CDCCCCCCCCEC504000000000BDB528419A9999B93E035841CDCCCCCCCCEC504000000000B5B52841666666C63B0358410000000000C0504066666666E8B42841666666C6440358410000000000C0504000000000BCB428419A9999D9460358410000000000C0504033333333C9B42841CDCCCC8C4B0358416666666666E65040', 'BATIMENT0000000336750759', 'Industriel, agricole ou commercial', 'Agricole', NULL, false, 'En service', '2014-07-31 13:20:43.411+02', '2016-12-09 17:12:28.38+01', NULL, '2012-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 7.0, 60.7, NULL, NULL, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000130000000000000028AB2841000000009501584100000000000055400000000029AB2841666666A6940158410000000000005540CDCCCCCC2AAB28419A999959940158410000000000005540CDCCCCCC2DAB2841333333139401584100000000000055406666666631AB28419A9999F9930158410000000000005540CDCCCCCC35AB2841CDCCCC0C940158410000000000005540CDCCCCCC38AB2841CDCCCC4C940158410000000000005540CDCCCCCC3AAB28419A999999940158410000000000005540000000003CAB28419A9999F9940158410000000000005540000000003CAB28419A999979950158410000000000005540333333333AAB2841000000009601584100000000000055403333333338AB284100000040960158410000000000005540CDCCCCCC35AB2841666666669601584100000000000055403333333332AB284100000080960158410000000000005540333333332FAB284133333373960158410000000000005540000000002CAB2841000000409601584100000000000055406666666629AB2841CDCCCCEC9501584100000000000055400000000028AB2841CDCCCC6C9501584100000000000055400000000028AB284100000000950158410000000000005540', 'BATIMENT0000002000558126', 'Silo', 'Agricole', NULL, false, 'En service', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 9.9, 74.1, 84.0, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000130000006666666631AB2841CDCCCCAC8F0158410000000000408FC00000000031AB2841333333538F0158410000000000408FC09A99999931AB28419A9999F98E0158410000000000408FC03333333333AB2841CDCCCCAC8E0158410000000000408FC03333333335AB28419A9999798E0158410000000000408FC0CDCCCCCC37AB28419A9999598E0158410000000000408FC0333333333BAB2841000000608E0158410000000000408FC0000000003EAB2841666666868E0158410000000000408FC09A99999940AB2841CDCCCCEC8E0158410000000000408FC06666666641AB2841333333538F0158410000000000408FC06666666641AB28419A9999598F0158410000000000408FC0CDCCCCCC40AB2841000000C08F0158410000000000408FC0666666663FAB284166666606900158410000000000408FC0333333333DAB284100000040900158410000000000408FC0CDCCCCCC39AB284100000060900158410000000000408FC09A99999936AB284133333353900158410000000000408FC09A99999934AB284133333333900158410000000000408FC0CDCCCCCC32AB28419A9999F98F0158410000000000408FC06666666631AB2841CDCCCCAC8F0158410000000000408FC0', 'BATIMENT0000002000558127', 'Silo', 'Agricole', NULL, false, 'En service', '2016-12-09 17:12:28.38+01', NULL, NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Pas de Z', 9999.0, NULL, NULL, NULL, NULL, 0.0, 74.1, NULL, NULL, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666678A7284100000080BE0158410000000000205440000000007DA728419A999979BE0158410000000000205440000000007DA728419A9999B9BC01584100000000002054406666666678A728419A9999B9BC01584100000000002054406666666678A7284100000080BE0158410000000000205440', 'BATIMENT0000000314346875', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.1, 75.4, 80.5, 81.9, 75.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666BCA7284100000000CC015841CDCCCCCCCC0C534000000000C4A72841CDCCCCCCCB015841CDCCCCCCCC0C53409A999999C2A72841333333D3CA015841CDCCCCCCCC0C534000000000BBA728419A9999F9CA015841CDCCCCCCCC0C534066666666BCA7284100000000CC015841CDCCCCCCCC0C5340', 'BATIMENT0000000314346903', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 73.2, 76.3, 77.0, 73.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333301A8284100000060B60158410000000000805340CDCCCCCCF6A7284133333373B6015841000000000080534033333333F7A72841666666A6B7015841000000000080534033333333FBA72841666666A6B70158410000000000805340CDCCCCCCFBA72841666666C6B801584100000000008053400000000002A82841000000C0B801584100000000008053403333333301A8284100000060B60158410000000000805340', 'BATIMENT0000000314346929', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 74.8, 78.0, 79.3, 75.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333BCA828419A999959C3015841333333333313534000000000BAA8284133333313C201584133333333331353409A999999B5A82841CDCCCC2CC201584133333333331353409A999999B7A828419A999979C3015841333333333313534033333333BCA828419A999959C30158413333333333135340', 'BATIMENT0000000314349539', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 73.2, 76.3, 77.1, 73.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCF8AF2841CDCCCCEC090158410000000000205A4033333333F6AF28419A9999D9090158410000000000205A4033333333F2AF28419A9999B9090158410000000000205A4066666666ECAF2841666666A60C0158410000000000205A40CDCCCCCCF2AF28419A9999D90C0158410000000000205A40CDCCCCCCF8AF2841CDCCCCEC090158410000000000205A40', 'BATIMENT0000000314347091', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 97.7, 104.6, 105.4, 99.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC14B128419A9999F9D10058413333333333F35A40CDCCCCCC19B12841000000E0D00058413333333333F35A409A9999990CB12841333333F3CF0058413333333333F35A409A99999907B12841CDCCCC0CD10058413333333333F35A40CDCCCCCC14B128419A9999F9D10058413333333333F35A40', 'BATIMENT0000000314341199', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.3, 103.6, 107.8, 109.3, 105.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333324AB28419A999939850158410000000000605340CDCCCCCC27AB2841000000A08501584100000000006053406666666630AB284100000040840158410000000000605340000000002DAB2841000000E08301584100000000006053403333333324AB28419A999939850158410000000000605340', 'BATIMENT0000000314348384', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 73.9, 77.6, 77.9, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666C2B028413333337307015841CDCCCCCCCCEC5B40CDCCCCCCC4B02841CDCCCC6C07015841CDCCCCCCCCEC5B4033333333C4B028419A99997906015841CDCCCCCCCCEC5B409A999999BBB028419A99999906015841CDCCCCCCCCEC5B409A999999BCB028416666668607015841CDCCCCCCCCEC5B4066666666C2B028413333337307015841CDCCCCCCCCEC5B40', 'BATIMENT0000000314341185', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 108.5, 111.8, 113.1, 109.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333CAB028410000006004015841CDCCCCCCCCEC5B409A999999C9B028410000000004015841CDCCCCCCCCEC5B4000000000B8B028416666664604015841CDCCCCCCCCEC5B4033333333B9B02841CDCCCC0C05015841CDCCCCCCCCEC5B4066666666CAB028419A9999D904015841CDCCCCCCCCEC5B4033333333CAB028410000006004015841CDCCCCCCCCEC5B40', 'BATIMENT0000000314341187', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 108.0, 111.8, 112.9, 109.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000F7AF28410000000010015841CDCCCCCCCC4C5A4066666666E9AF2841CDCCCC4C10015841CDCCCCCCCC4C5A40CDCCCCCCEAAF28416666660611015841CDCCCCCCCC4C5A409A999999F7AF2841CDCCCCAC10015841CDCCCCCCCC4C5A4000000000F7AF28410000000010015841CDCCCCCCCC4C5A40', 'BATIMENT0000000314347099', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.7, 96.6, 105.3, 107.1, 98.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666606AE2841000000800F0158416666666666C65740333333330DAE2841000000A00F0158416666666666C65740CDCCCCCC0EAE28419A9999590E0158416666666666C657403333333308AE2841666666460E0158416666666666C657406666666606AE2841000000800F0158416666666666C65740', 'BATIMENT0000000314347641', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.1, 93.1, 95.2, 95.5, 93.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC1BAA28419A999959B4015841CDCCCCCCCC0C5340333333332BAA284100000080B4015841CDCCCCCCCC0C5340666666662BAA2841666666A6B3015841CDCCCCCCCC0C5340000000001CAA284166666686B3015841CDCCCCCCCC0C5340CDCCCCCC1BAA28419A999959B4015841CDCCCCCCCC0C5340', 'BATIMENT0000000314349488', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 72.6, 76.3, 78.7, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666664DAB284100000080AD01584166666666664653406666666640AB284100000040AD0158416666666666465340333333333FAB2841CDCCCC6CAE0158416666666666465340CDCCCCCC3DAB28419A9999D9AF0158416666666666465340000000003CAB2841666666E6B101584166666666664653403333333349AB284100000020B20158416666666666465340666666664DAB284100000080AD0158416666666666465340', 'BATIMENT0000000314349563', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.4, 71.8, 77.2, 77.9, 72.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCA0AA284100000000AD01584100000000002053409A999999B7AA284100000040AD015841000000000020534066666666B8AA284100000040AC01584100000000002053409A999999A1AA28419A9999F9AB015841000000000020534066666666A1AA284100000040AC0158410000000000205340CDCCCCCCA0AA284100000000AD0158410000000000205340', 'BATIMENT0000000314349771', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 72.4, 76.5, 80.6, 72.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666657A9284166666646B10158419A99999999195340CDCCCCCC60A9284100000000B10158419A999999991953409A9999995FA92841333333F3AF0158419A999999991953403333333356A92841CDCCCC2CB00158419A999999991953406666666657A9284166666646B10158419A99999999195340', 'BATIMENT0000000314349842', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 73.7, 76.4, 76.8, 73.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333394AA2841CDCCCC6CE0015841CDCCCCCCCC6C52403333333395AA2841CDCCCC6CDF015841CDCCCCCCCC6C52406666666689AA2841CDCCCC4CDF015841CDCCCCCCCC6C52409A99999988AA284166666646E0015841CDCCCCCCCC6C52403333333394AA2841CDCCCC6CE0015841CDCCCCCCCC6C5240', 'BATIMENT0000000314349872', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.4, 71.4, 73.8, 73.9, 71.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333C4AD28419A99997961015841CDCCCCCCCC4C54409A999999C6AD28413333339360015841CDCCCCCCCC4C544033333333BFAD28413333333360015841CDCCCCCCCC4C544033333333BCAD28419A99991961015841CDCCCCCCCC4C544033333333C4AD28419A99997961015841CDCCCCCCCC4C5440', 'BATIMENT0000000314347662', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 77.1, 81.3, 81.6, 77.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC10AE2841666666665C0158410000000000C054406666666615AE2841000000C05C0158410000000000C054406666666617AE2841000000605C0158410000000000C054409A9999991CAE2841000000C05C0158410000000000C05440666666661FAE2841000000005C0158410000000000C054403333333314AE2841666666465B0158410000000000C05440CDCCCCCC10AE2841666666665C0158410000000000C05440', 'BATIMENT0000000314347663', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 78.6, 83.0, 84.5, 79.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999A7AD2841333333F3860158419A9999999959544000000000AEAD2841CDCCCC0C870158419A99999999595440CDCCCCCCAEAD2841CDCCCC6C860158419A9999999959544066666666ACAD284100000060860158419A999999995954409A999999A8AD2841CDCCCC4C860158419A999999995954409A999999A7AD2841333333F3860158419A99999999595440', 'BATIMENT0000000314348313', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 74.5, 81.4, 82.9, 74.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A99999903AE2841000000208701584133333333339354400000000002AE284133333373870158413333333333935440CDCCCCCC0AAE28419A9999198801584133333333339354400000000015AE2841CDCCCCEC850158413333333333935440CDCCCCCC12AE2841666666C68501584133333333339354409A9999990CAE28419A9999598501584133333333339354406666666609AE2841333333F38501584133333333339354409A99999903AE284100000020870158413333333333935440', 'BATIMENT0000000314348362', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.8, 75.6, 82.4, 83.8, 76.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC2AAE2841000000E09E0158410000000000A054403333333322AE2841333333F39E0158410000000000A054409A9999991BAE2841000000009F0158410000000000A05440666666661CAE284166666646A00158410000000000A054400000000027AE28419A999939A00158410000000000A05440333333332BAE284133333333A00158410000000000A05440CDCCCCCC2AAE2841000000E09E0158410000000000A05440', 'BATIMENT0000000314348396', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.7, 75.9, 82.6, 83.3, 77.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999997EB62841CDCCCC8CAEFE5741CDCCCCCCCC0C54406666666684B628419A999959ADFE5741CDCCCCCCCC0C5440000000007BB6284100000080ACFE5741CDCCCCCCCC0C54409A99999963B6284100000000B1FE5741CDCCCCCCCC0C5440CDCCCCCC6CB62841666666C6B1FE5741CDCCCCCCCC0C54409A9999997EB62841CDCCCC8CAEFE5741CDCCCCCCCC0C5440', 'BATIMENT0000000314331669', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:14.231+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.5, 76.8, 80.3, 84.5, 78.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666F9AC2841000000409D01584133333333335354409A999999F0AC2841000000A09D015841333333333353544033333333F4AC28419A9999F99E015841333333333353544000000000FCAC2841333333539E015841333333333353544066666666F9AC2841000000409D0158413333333333535440', 'BATIMENT0000000314349411', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.9, 73.5, 81.4, 81.7, 73.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666662CAD2841666666A6A30158413333333333B353400000000027AD28419A9999B9A30158413333333333B353406666666622AD2841666666C6A30158413333333333B353403333333322AD284100000080A40158413333333333B35340666666662BAD284166666666A40158413333333333B35340CDCCCCCC2BAD284166666666A40158413333333333B35340666666662CAD2841666666A6A30158413333333333B35340', 'BATIMENT0000000314348467', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.3, 73.6, 78.8, 79.8, 73.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000066666666E8AB2841CDCCCC0CF6015841333333333353524066666666E3AB284166666626F8015841333333333353524000000000E8AB284133333353F8015841333333333353524033333333EAAB284100000060F7015841333333333353524000000000EDAB284133333373F7015841333333333353524033333333EFAB2841CDCCCC4CF6015841333333333353524066666666E8AB2841CDCCCC0CF60158413333333333535240', 'BATIMENT0000000314348749', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 69.5, 73.3, 73.9, 69.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666C5AB2841000000A0D60158419A99999999D9524033333333C7AB2841CDCCCCCCD40158419A99999999D9524033333333BBAB2841CDCCCC8CD40158419A99999999D952409A999999B9AB284100000060D60158419A99999999D9524066666666C5AB2841000000A0D60158419A99999999D95240', 'BATIMENT0000000314348780', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.6, 69.9, 75.5, 76.3, 70.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000006CAC284166666666F70158416666666666A652400000000067AC2841CDCCCC6CF70158416666666666A652406666666667AC28419A9999F9F80158416666666666A65240CDCCCCCC6BAC28419A9999F9F80158416666666666A65240000000006CAC284166666666F70158416666666666A65240', 'BATIMENT0000000314348792', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.8, 69.9, 74.6, 75.7, 70.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000093AC2841CDCCCC2CEE0158416666666666A652409A99999989AC28419A9999B9ED0158416666666666A652406666666687AC2841CDCCCC8CEE0158416666666666A652409A99999990AC2841333333F3EE0158416666666666A652400000000093AC2841CDCCCC2CEE0158416666666666A65240', 'BATIMENT0000000314348797', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.6, 70.1, 74.7, 75.3, 70.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000002AC284100000040EF01584100000000002052400000000003AC2841333333B3EE015841000000000020524033333333FDAB28419A999979EE015841000000000020524000000000FCAB284166666606EF01584100000000002052400000000002AC284100000040EF0158410000000000205240', 'BATIMENT0000000314348814', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.4, 70.1, 72.5, 72.9, 70.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000CDCCCCCCE7AB2841333333D3EC015841666666666686524033333333ECAB2841666666C6EA015841666666666686524066666666E7AB284133333393EA015841666666666686524000000000EAAB284100000080E901584166666666668652409A999999FDAB284166666626EA015841666666666686524000000000FFAB2841CDCCCC8CE9015841666666666686524000000000E6AB2841333333B3E8015841666666666686524066666666DEAB28419A999979EC0158416666666666865240CDCCCCCCE7AB2841333333D3EC0158416666666666865240', 'BATIMENT0000000314348816', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.9, 69.3, 74.2, 75.5, 69.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC6CAB284166666666BC01584100000000008052409A9999997BAB2841CDCCCCACBC0158410000000000805240CDCCCCCC7DAB2841333333F3BA01584100000000008052403333333377AB2841333333D3BA01584100000000008052403333333376AB2841333333D3BB0158410000000000805240000000006EAB2841333333B3BB0158410000000000805240CDCCCCCC6CAB284166666666BC0158410000000000805240', 'BATIMENT0000000314349845', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 71.0, 74.0, 75.2, 71.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000073AD2841CDCCCC6CA40158416666666666C652403333333373AD284166666646A50158416666666666C65240CDCCCCCC7FAD284133333333A50158416666666666C652409A99999980AD28419A999919A40158416666666666C65240666666667CAD284100000040A40158416666666666C65240666666667CAD284166666666A40158416666666666C652400000000073AD2841CDCCCC6CA40158416666666666C65240', 'BATIMENT0000000314348957', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.4, 72.7, 75.1, 77.4, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC64AC284100000060AA015841CDCCCCCCCC6C5340000000006CAC284133333333AA015841CDCCCCCCCC6C5340000000006AAC284100000000A9015841CDCCCCCCCC6C53400000000063AC284133333333A9015841CDCCCCCCCC6C5340CDCCCCCC64AC284100000060AA015841CDCCCCCCCC6C5340', 'BATIMENT0000000314348998', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.8, 72.0, 77.8, 80.8, 72.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000028AC2841666666E69C0158410000000000205340000000002CAC2841333333D39C01584100000000002053409A9999992AAC2841666666069C0158410000000000205340CDCCCCCC26AC2841000000209C01584100000000002053400000000028AC2841666666E69C0158410000000000205340', 'BATIMENT0000000314349014', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 72.6, 76.5, 77.5, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333335AAC2841CDCCCC0C9D0158413333333333F353409A9999994BAC28419A9999D99C0158413333333333F35340000000004FAC2841CDCCCCEC9E0158413333333333F353409A9999995CAC28419A9999999E0158413333333333F35340333333335AAC2841CDCCCC0C9D0158413333333333F35340', 'BATIMENT0000000314349016', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.2, 72.7, 79.9, 80.7, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000333333335AAC2841CDCCCC0C9D0158416666666666E653406666666656AC2841CDCCCCCC9A0158416666666666E65340CDCCCCCC50AC2841666666E69A0158416666666666E65340CDCCCCCC48AC28419A9999199B0158416666666666E65340CDCCCCCC49AC2841333333B39B0158416666666666E653409A9999994BAC28419A9999D99C0158416666666666E65340333333335AAC2841CDCCCC0C9D0158416666666666E65340', 'BATIMENT0000000314349017', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.0, 72.7, 79.7, 80.7, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCC49AC2841333333B39B0158410000000000205440CDCCCCCC48AC28419A9999199B0158410000000000205440CDCCCCCC47AC2841000000609A01584100000000002054409A9999993AAC2841333333B39A01584100000000002054403333333339AC2841000000C09A0158410000000000205440CDCCCCCC3AAC2841CDCCCCAC9B0158410000000000205440666666663BAC2841CDCCCC0C9C0158410000000000205440CDCCCCCC49AC2841333333B39B0158410000000000205440', 'BATIMENT0000000314349018', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.8, 72.7, 80.5, 81.7, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666D2AC2841666666C6D00158410000000000405240CDCCCCCCD7AC2841000000E0D00158410000000000405240CDCCCCCCD9AC284133333353CF015841000000000040524066666666D4AC28419A999939CF015841000000000040524066666666D2AC2841666666C6D00158410000000000405240', 'BATIMENT0000000314349152', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 70.7, 73.0, 73.6, 70.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCEFAC284166666606AD0158416666666666065440CDCCCCCCE8AC28419A9999F9AC015841666666666606544066666666CEAC2841666666C6AC015841666666666606544000000000CEAC284133333333B001584166666666660654409A999999E8AC2841CDCCCC6CB0015841666666666606544066666666E8AC2841333333F3B001584166666666660654409A999999EEAC284100000000B10158416666666666065440CDCCCCCCEFAC284166666606AD0158416666666666065440', 'BATIMENT0000000314349155', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.3, 71.9, 80.2, 80.8, 72.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666630AD2841CDCCCC8CB0015841CDCCCCCCCCCC5240333333332BAD284166666686B0015841CDCCCCCCCCCC5240000000002BAD284166666646B1015841CDCCCCCCCCCC52403333333330AD284166666646B1015841CDCCCCCCCCCC52406666666630AD2841CDCCCC8CB0015841CDCCCCCCCCCC5240', 'BATIMENT0000000314349180', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.8, 72.5, 75.3, 76.5, 72.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC90AD2841CDCCCC8CB30158416666666666665340666666668FAD2841CDCCCC8CB301584166666666666653400000000088AD2841CDCCCC8CB301584166666666666653409A99999988AD2841CDCCCC8CB401584166666666666653409A99999990AD2841CDCCCC8CB40158416666666666665340CDCCCCCC90AD2841CDCCCC8CB30158416666666666665340', 'BATIMENT0000000314349181', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.2, 72.5, 77.7, 79.2, 72.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666EBAC284133333333AB0158410000000000A0534066666666E9AC28419A999919A90158410000000000A05340CDCCCCCCDFAC284166666646A90158410000000000A05340CDCCCCCCE0AC284100000020AB0158410000000000A0534066666666EBAC284133333333AB0158410000000000A05340', 'BATIMENT0000000314349281', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.4, 72.2, 78.5, 79.8, 72.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC7BAD284166666626B8015841CDCCCCCCCC0C5340CDCCCCCC7BAD2841666666C6B6015841CDCCCCCCCC0C5340CDCCCCCC6FAD2841666666A6B6015841CDCCCCCCCC0C53403333333370AD284100000000B8015841CDCCCCCCCC0C5340CDCCCCCC7BAD284166666626B8015841CDCCCCCCCC0C5340', 'BATIMENT0000000314349356', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 72.3, 76.3, 77.2, 72.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999BDAC2841000000E0C60158410000000000A053409A99999975AC284166666686C50158410000000000A053400000000070AC284100000060CA0158410000000000A0534000000000A8AC2841CDCCCCCCCB0158410000000000A0534000000000B4AC284100000020CC0158410000000000A053409A999999BDAC2841000000E0C60158410000000000A05340', 'BATIMENT0000000314349369', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 71.1, 78.6, 79.9, 72.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000800000066666666FCAB284166666686BC015841666666666686534066666666F8AB284133333373BF015841666666666686534066666666F7AB284100000060C001584166666666668653409A99999900AC284100000080C00158416666666666865340000000000CAC2841000000A0C00158416666666666865340CDCCCCCC0DAC284133333353BF01584166666666668653406666666611AC2841000000E0BC015841666666666686534066666666FCAB284166666686BC0158416666666666865340', 'BATIMENT0000000314349395', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 70.8, 78.2, 79.1, 71.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999916AC284133333333B9015841CDCCCCCCCC8C5340CDCCCCCC01AC2841333333B3B8015841CDCCCCCCCC8C534066666666FCAB284166666686BC015841CDCCCCCCCC8C53406666666611AC2841000000E0BC015841CDCCCCCCCC8C5340CDCCCCCC13AC28419A999919BB015841CDCCCCCCCC8C53409A99999916AC284133333333B9015841CDCCCCCCCC8C5340', 'BATIMENT0000000314349397', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.3, 71.0, 78.3, 79.1, 71.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333329AC2841000000A0CC015841CDCCCCCCCCAC52403333333330AC2841000000C0CC015841CDCCCCCCCCAC52403333333331AC28419A9999F9CB015841CDCCCCCCCCAC52409A99999932AC2841CDCCCCECCA015841CDCCCCCCCCAC5240000000002DAC2841333333D3CA015841CDCCCCCCCCAC5240000000002BAC2841666666C6CA015841CDCCCCCCCCAC52403333333329AC2841000000A0CC015841CDCCCCCCCCAC5240', 'BATIMENT0000000314349467', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 70.9, 74.8, 77.2, 71.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666A5AB284166666646A40158419A9999999919534066666666A5AB2841CDCCCC6CA40158419A9999999919534000000000A5AB2841CDCCCCCCA40158419A9999999919534000000000ABAB2841CDCCCCECA40158419A9999999919534066666666ABAB284166666666A40158419A9999999919534066666666A5AB284166666646A40158419A99999999195340', 'BATIMENT0000000314349632', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 72.7, 76.5, 77.8, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666664AAD284166666646E2015841CDCCCCCCCCCC5240666666664DAD284100000060E2015841CDCCCCCCCCCC5240CDCCCCCC4FAD284166666666E1015841CDCCCCCCCCCC52409A9999994CAD2841CDCCCC4CE1015841CDCCCCCCCCCC5240666666664AAD284166666646E2015841CDCCCCCCCCCC5240', 'BATIMENT0000000314349686', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 70.9, 75.3, 77.2, 71.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000EFB1284166666626B90058419A99999999B95C409A999999FFB12841000000E0B70058419A99999999B95C409A999999FCB1284100000040B70058419A99999999B95C40CDCCCCCCEBB1284166666686B80058419A99999999B95C4000000000EFB1284166666626B90058419A99999999B95C40', 'BATIMENT0000000314341215', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 107.6, 115.0, 115.6, 109.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000F1B328419A9999792B015841CDCCCCCCCCAC5840CDCCCCCC04B42841333333932C015841CDCCCCCCCCAC58406666666616B42841CDCCCC0C28015841CDCCCCCCCCAC58400000000002B428410000000027015841CDCCCCCCCCAC584000000000F1B328419A9999792B015841CDCCCCCCCCAC5840', 'BATIMENT0000000314341224', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 94.4, 98.7, 99.4, 97.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC99B128419A999999850158419A999999997959403333333399B12841CDCCCCCC840158419A999999997959406666666697B12841333333D3840158419A99999999795940333333338EB12841333333F3840158419A99999999795940CDCCCCCC8EB12841000000C0850158419A99999999795940CDCCCCCC99B128419A999999850158419A99999999795940', 'BATIMENT0000000314350007', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 97.9, 101.9, 102.1, 98.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999A4B128419A99999989015841666666666646594033333333A4B128419A9999B9880158416666666666465940000000009CB12841333333D3880158416666666666465940666666669CB12841CDCCCCAC89015841666666666646594066666666A1B12841000000A08901584166666666664659409A999999A4B128419A999999890158416666666666465940', 'BATIMENT0000000314350009', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 98.0, 101.2, 101.5, 98.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCE3B2284100000040BA015841000000000080574033333333F8B228419A9999B9B9015841000000000080574033333333F7B22841CDCCCC8CB8015841000000000080574000000000E2B2284100000020B90158410000000000805740CDCCCCCCE3B2284100000040BA0158410000000000805740', 'BATIMENT0000000314350061', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.5, 91.5, 94.0, 95.7, 91.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999EEB128413333337389015841666666666646594000000000F7B128419A99995989015841666666666646594033333333F6B1284100000020880158416666666666465940CDCCCCCCEDB12841000000408801584166666666664659409A999999EEB1284133333373890158416666666666465940', 'BATIMENT0000000314350069', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 98.1, 101.2, 101.9, 98.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666AAB12841666666668D015841CDCCCCCCCC6C59409A999999A8B128419A9999F98A015841CDCCCCCCCC6C594000000000A3B12841000000008B015841CDCCCCCCCC6C5940CDCCCCCCA4B12841000000808D015841CDCCCCCCCC6C594066666666AAB12841666666668D015841CDCCCCCCCC6C5940', 'BATIMENT0000000314350094', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 97.8, 101.8, 103.5, 98.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333E4AF284133333333BC0158419A9999999939544066666666E4AF2841CDCCCC4CBB0158419A99999999395440CDCCCCCCDDAF2841CDCCCC2CBB0158419A9999999939544066666666DDAF284100000020BC0158419A9999999939544033333333E4AF284133333333BC0158419A99999999395440', 'BATIMENT0000000314349871', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 77.7, 80.9, 81.2, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B0000000000000089AE2841000000E0A201584100000000000055409A99999987AE28419A9999F9A30158410000000000005540CDCCCCCC85AE2841333333F3A301584100000000000055409A99999983AE28419A9999F9A40158410000000000005540333333337FAE2841666666E6A40158410000000000005540666666667EAE284166666646A501584100000000000055409A9999998EAE28419A999999A501584100000000000055406666666692AE2841666666A6A501584100000000000055400000000097AE284166666666A301584100000000000055409A99999995AE2841CDCCCC2CA301584100000000000055400000000089AE2841000000E0A20158410000000000005540', 'BATIMENT0000000314348499', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 77.1, 84.0, 85.0, 78.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999F7AE2841333333D3BE01584100000000008054409A999999FFAE284166666646BF01584100000000008054403333333302AF284133333373BE015841000000000080544066666666F9AE2841000000E0BD01584100000000008054409A999999F7AE2841333333D3BE0158410000000000805440', 'BATIMENT0000000314348505', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.1, 75.9, 82.0, 82.2, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333C2AF284133333353AF0158410000000000A05440CDCCCCCCC1AF2841333333D3AF0158410000000000A054409A999999CAAF28419A9999D9AF0158410000000000A054409A999999CAAF284100000060AF0158410000000000A0544033333333C2AF284133333353AF0158410000000000A05440', 'BATIMENT0000000314348926', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 79.6, 82.5, 84.3, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000003333333399AF2841666666C6B1015841CDCCCCCCCC6C5540666666668DAF2841666666A6B1015841CDCCCCCCCC6C5540666666668DAF28419A9999B9B1015841CDCCCCCCCC6C5540CDCCCCCC8CAF2841CDCCCCECB2015841CDCCCCCCCC6C5540CDCCCCCC91AF28419A9999F9B2015841CDCCCCCCCC6C55400000000092AF2841000000A0B2015841CDCCCCCCCC6C55403333333399AF2841CDCCCCACB2015841CDCCCCCCCC6C55403333333399AF2841666666C6B1015841CDCCCCCCCC6C5540', 'BATIMENT0000000314349111', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.3, 78.5, 85.8, 86.7, 79.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666641AF284133333353B7015841CDCCCCCCCC2C54400000000042AF284133333353B6015841CDCCCCCCCC2C54409A99999942AF284133333353B5015841CDCCCCCCCC2C5440333333333EAF28419A999939B5015841CDCCCCCCCC2C5440000000003DAF284133333333B7015841CDCCCCCCCC2C54406666666641AF284133333353B7015841CDCCCCCCCC2C5440', 'BATIMENT0000000314349257', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 76.6, 80.8, 83.7, 77.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999992AAF284133333393910158419A99999999B954406666666626AF2841CDCCCC8C910158419A99999999B954403333333326AF2841000000E0910158419A99999999B95440666666662AAF2841000000E0910158419A99999999B954409A9999992AAF284133333393910158419A99999999B95440', 'BATIMENT0000000314349376', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 79.7, 83.0, 83.3, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999C6AE284133333373960158419A99999999D95440CDCCCCCCC6AE28419A999979950158419A99999999D9544066666666C3AE2841CDCCCC6C950158419A99999999D9544033333333C3AE284166666666960158419A99999999D954409A999999C6AE284133333373960158419A99999999D95440', 'BATIMENT0000000314349436', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 79.9, 83.4, 84.3, 80.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCCBAF28419A9999599C015841CDCCCCCCCCAC544066666666CBAF2841333333F39C015841CDCCCCCCCCAC544000000000D5AF28419A9999F99C015841CDCCCCCCCCAC54409A999999D5AF2841333333739C015841CDCCCCCCCCAC5440CDCCCCCCCBAF28419A9999599C015841CDCCCCCCCCAC5440', 'BATIMENT0000000314349859', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.5, 81.3, 82.8, 83.5, 81.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333C8AF2841000000E0A2015841CDCCCCCCCCAC544033333333CCAF2841333333F3A2015841CDCCCCCCCCAC544066666666CCAF2841CDCCCC6CA2015841CDCCCCCCCCAC54409A999999C8AF28419A999959A2015841CDCCCCCCCCAC544033333333C8AF2841000000E0A2015841CDCCCCCCCCAC5440', 'BATIMENT0000000314349860', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 80.8, 82.8, 83.2, 81.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999C7AF284166666606B101584100000000006054409A999999C1AF284100000000B1015841000000000060544033333333C1AF28419A999999B1015841000000000060544066666666C7AF284133333393B101584100000000006054409A999999C7AF284166666606B10158410000000000605440', 'BATIMENT0000000314349861', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.1, 79.4, 81.5, 82.0, 79.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000B7AF284133333373B0015841666666666666544066666666B7AF2841CDCCCCACAF015841666666666666544000000000B3AF2841000000A0AF0158416666666666665440CDCCCCCCB2AF284166666666B0015841666666666666544000000000B7AF284133333373B00158416666666666665440', 'BATIMENT0000000314349864', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 79.5, 81.6, 81.7, 79.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000666666668BAF2841666666A6B50158419A999999997954409A9999998BAF284133333353B50158419A99999999795440CDCCCCCC8BAF2841CDCCCCACB40158419A99999999795440000000007DAF284166666686B40158419A99999999795440666666667CAF28419A9999B9B50158419A99999999795440333333337CAF2841000000A0B60158419A999999997954406666666680AF2841333333B3B60158419A99999999795440CDCCCCCC8AAF2841000000E0B60158419A99999999795440666666668BAF2841666666A6B50158419A99999999795440', 'BATIMENT0000000314349102', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.3, 77.7, 82.0, 83.4, 78.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC29B1284166666606660158410000000000E05940CDCCCCCC2BB128419A9999B9650158410000000000E05940666666662DB12841CDCCCC0C650158410000000000E05940CDCCCCCC24B128419A999999640158410000000000E059406666666622B12841000000E0640158410000000000E059400000000027B128419A999919660158410000000000E05940CDCCCCCC29B1284166666606660158410000000000E05940', 'BATIMENT0000000314341103', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 100.4, 103.5, 104.4, 100.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC28B0284133333313610158416666666666265740CDCCCCCC2DB02841333333D35E01584166666666662657400000000028B02841666666A65E01584166666666662657409A99999924B02841CDCCCC8C5E01584166666666662657406666666620B028419A9999D9600158416666666666265740CDCCCCCC28B0284133333313610158416666666666265740', 'BATIMENT0000000314347089', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 89.8, 92.7, 93.8, 90.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666DCAF28419A99991923015841000000000020594033333333ECAF2841666666462301584100000000002059409A999999EEAF2841333333731E0158410000000000205940CDCCCCCCDEAF2841666666461E015841000000000020594066666666DCAF28419A999919230158410000000000205940', 'BATIMENT0000000314347095', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 93.2, 100.6, 106.0, 94.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000000DB02841333333D331015841CDCCCCCCCCEC5840333333330CB028419A9999F930015841CDCCCCCCCCEC584066666666EAAF28416666668631015841CDCCCCCCCCEC584000000000EBAF28413333335332015841CDCCCCCCCCEC5840000000000DB02841333333D331015841CDCCCCCCCCEC5840', 'BATIMENT0000000314347101', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.7, 94.1, 99.7, 100.1, 96.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333331EAF28419A9999797301584100000000000056400000000024AF2841000000C07301584100000000000056409A99999925AF2841000000407301584100000000000056400000000023AF28419A999919730158410000000000005640333333331EAF28419A999979730158410000000000005640', 'BATIMENT0000000314347167', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.6, 83.4, 88.0, 88.5, 83.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666657AF2841000000405C0158410000000000C05640CDCCCCCC51AF28419A9999195D0158410000000000C056403333333356AF2841333333735D0158410000000000C05640333333335BAF2841CDCCCCAC5C0158410000000000C056406666666657AF2841000000405C0158410000000000C05640', 'BATIMENT0000000314347324', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 85.2, 91.1, 91.2, 85.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000000000006DAF28419A999939590158410000000000205640000000006BAF284166666686590158410000000000205640CDCCCCCC62AF2841CDCCCCCC5A01584100000000002056409A99999969AF2841CDCCCC8C5B01584100000000002056400000000074AF2841333333F3590158410000000000205640000000006DAF28419A999939590158410000000000205640', 'BATIMENT0000000314347391', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 85.9, 88.5, 90.0, 86.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666665BAF2841000000005A015841CDCCCCCCCC6C56406666666659AF28419A9999595A015841CDCCCCCCCC6C5640000000005DAF2841666666C65A015841CDCCCCCCCC6C5640333333335FAF2841CDCCCC6C5A015841CDCCCCCCCC6C5640666666665BAF2841000000005A015841CDCCCCCCCC6C5640', 'BATIMENT0000000314347392', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 85.4, 89.8, 90.2, 86.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000C0AE2841666666A6290158413333333333935540CDCCCCCCBEAE28419A9999392701584133333333339355409A999999B9AE28419A9999392701584133333333339355409A999999BAAE2841666666A629015841333333333393554000000000C0AE2841666666A6290158413333333333935540', 'BATIMENT0000000314347415', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.4, 85.0, 86.4, 86.6, 85.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C0000006666666622B02841CDCCCC2C3E0158413333333333B35840CDCCCCCC36B02841CDCCCCAC3D0158413333333333B358400000000037B02841000000E03D0158413333333333B35840000000003EB02841333333B33D0158413333333333B358409A9999993BB02841666666263C0158413333333333B358400000000035B02841333333533C0158413333333333B358403333333334B028419A9999B93B0158413333333333B35840CDCCCCCC32B028419A9999D93A0158413333333333B35840333333332BB02841666666063B0158413333333333B35840000000002CB02841333333933B0158413333333333B35840CDCCCCCC1EB02841666666E63B0158413333333333B358406666666622B02841CDCCCC2C3E0158413333333333B35840', 'BATIMENT0000000314347608', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 95.5, 98.8, 99.4, 96.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999993BB02841666666263C0158419A999999999958409A9999993AB02841CDCCCC8C3B0158419A999999999958403333333334B028419A9999B93B0158419A999999999958400000000035B02841333333533C0158419A999999999958409A9999993BB02841666666263C0158419A99999999995840', 'BATIMENT0000000314347610', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.4, 96.1, 98.5, 98.8, 96.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333338BAF2841333333937201584100000000008055409A99999986AF2841666666467301584100000000008055409A9999998FAF2841CDCCCC2C7401584100000000008055400000000094AF284100000080730158410000000000805540333333338BAF284133333393720158410000000000805540', 'BATIMENT0000000314347677', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 84.1, 86.1, 86.3, 84.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC5CA82841CDCCCCEC510158413333333333D354409A9999995CA8284133333353510158413333333333D354409A99999958A8284133333353510158413333333333D35440CDCCCCCC58A82841CDCCCCEC510158413333333333D35440CDCCCCCC5CA82841CDCCCCEC510158413333333333D35440', 'BATIMENT0000000314346859', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:24:56.193+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.9, 81.5, 83.3, 83.7, 82.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000084B128419A9999D9830158410000000000E05840333333338BB12841CDCCCCCC830158410000000000E05840000000008AB1284166666666810158410000000000E05840000000008AB1284166666606810158410000000000E058403333333383B1284166666606810158410000000000E058400000000084B128419A9999D9830158410000000000E05840', 'BATIMENT0000000314341124', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 97.3, 99.5, 101.3, 98.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000800000066666666B6B12841000000803D0158410000000000405D409A999999B6B12841666666263E0158410000000000405D4000000000C1B12841333333133E0158410000000000405D4033333333C1B12841666666A63E0158410000000000405D4066666666C5B12841000000A03E0158410000000000405D409A999999C6B12841666666863D0158410000000000405D40CDCCCCCCBDB12841000000803D0158410000000000405D4066666666B6B12841000000803D0158410000000000405D40', 'BATIMENT0000000314341177', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.6, 111.4, 117.0, 118.3, 112.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000120000000000000034B228419A9999D9BE015841CDCCCCCCCC4C56406666666642B228419A999979BE015841CDCCCCCCCC4C56403333333340B22841333333B3BC015841CDCCCCCCCC4C56406666666635B22841CDCCCCECBC015841CDCCCCCCCC4C56400000000035B22841CDCCCCACBC015841CDCCCCCCCC4C5640CDCCCCCC30B2284133333373B9015841CDCCCCCCCC4C56400000000028B22841000000A0B9015841CDCCCCCCCC4C56406666666627B2284133333353B9015841CDCCCCCCCC4C56400000000035B22841666666E6B8015841CDCCCCCCCC4C56409A99999930B22841333333D3B6015841CDCCCCCCCC4C56400000000035B22841666666A6B6015841CDCCCCCCCC4C56403333333332B2284133333393B5015841CDCCCCCCCC4C5640CDCCCCCC20B228419A999919B6015841CDCCCCCCCC4C56403333333325B2284133333353B8015841CDCCCCCCCC4C56409A9999991EB2284166666686B8015841CDCCCCCCCC4C5640CDCCCCCC24B2284166666606BD015841CDCCCCCCCC4C5640CDCCCCCC31B22841333333B3BC015841CDCCCCCCCC4C56400000000034B228419A9999D9BE015841CDCCCCCCCC4C5640', 'BATIMENT0000000314350058', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.3, 84.0, 89.3, 92.3, 88.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999970B228419A999959B70158410000000000805640666666666FB22841CDCCCC8CB601584100000000008056409A9999995AB2284133333313B70158410000000000805640666666665BB22841000000C0B701584100000000008056409A99999970B228419A999959B70158410000000000805640', 'BATIMENT0000000314350077', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 85.0, 90.0, 92.0, 85.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333330EB22841CDCCCC8C990158413333333333F358400000000014B228419A9999399B0158413333333333F358409A99999917B22841666666069B0158413333333333F358409A99999911B22841CDCCCC4C990158413333333333F35840333333330EB22841CDCCCC8C990158413333333333F35840', 'BATIMENT0000000314350152', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.0, 91.9, 99.9, 100.4, 94.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666663BAB2841333333B310025841CDCCCCCCCCAC51406666666643AB2841000000800F025841CDCCCCCCCCAC5140CDCCCCCC3FAB2841000000200F025841CDCCCCCCCCAC51406666666637AB28410000006010025841CDCCCCCCCCAC5140666666663BAB2841333333B310025841CDCCCCCCCCAC5140', 'BATIMENT0000000314349877', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 68.2, 70.8, 71.2, 68.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999E6AD28419A99999968025841666666666646544066666666EAAD2841333333F3660258416666666666465440CDCCCCCCE4AD2841000000C066025841666666666646544000000000E1AD2841666666666802584166666666664654409A999999E6AD28419A999999680258416666666666465440', 'BATIMENT0000000314349903', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 77.9, 81.2, 81.4, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC59AB2841333333731602584133333333331352409A99999950AB284166666686150258413333333333135240666666664DAB28419A9999191602584133333333331352409A99999955AB2841CDCCCC0C170258413333333333135240CDCCCCCC59AB284133333373160258413333333333135240', 'BATIMENT0000000314348788', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 68.0, 72.3, 74.2, 68.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC32A82841333333B3D3015841CDCCCCCCCC2C53409A99999927A828419A9999D9D3015841CDCCCCCCCC2C5340CDCCCCCC27A82841CDCCCC4CD4015841CDCCCCCCCC2C53403333333333A8284166666626D4015841CDCCCCCCCC2C5340CDCCCCCC32A82841333333B3D3015841CDCCCCCCCC2C5340', 'BATIMENT0000000314346865', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 72.6, 76.7, 77.7, 72.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000F00000033333333B8AC28413333339371015841CDCCCCCCCCCC544066666666B6AC2841CDCCCCAC73015841CDCCCCCCCCCC54409A999999C2AC28416666668674015841CDCCCCCCCCCC5440CDCCCCCCC2AC28410000002074015841CDCCCCCCCCCC544033333333C0AC2841CDCCCC0C74015841CDCCCCCCCCCC54409A999999C1AC28413333337372015841CDCCCCCCCCCC54409A999999DAAC2841CDCCCC0C73015841CDCCCCCCCCCC54409A999999F0AC28419A99999973015841CDCCCCCCCCCC5440CDCCCCCCF4AC2841666666A674015841CDCCCCCCCCCC5440CDCCCCCCFBAC2841CDCCCC2C74015841CDCCCCCCCCCC54406666666615AD2841CDCCCC6C72015841CDCCCCCCCCCC544066666666FDAC2841666666C671015841CDCCCCCCCCCC544000000000D0AC2841CDCCCC8C70015841CDCCCCCCCCCC54409A999999B9AC2841333333F36F015841CDCCCCCCCCCC544033333333B8AC28413333339371015841CDCCCCCCCCCC5440', 'BATIMENT0000000314347400', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.3, 75.0, 83.3, 85.5, 75.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999B7AC284166666626E1015841666666666646524033333333A3AC284166666686E0015841666666666646524033333333A2AC284166666626E1015841666666666646524033333333B6AC2841333333D3E101584166666666664652409A999999B7AC284166666626E10158416666666666465240', 'BATIMENT0000000314348694', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 70.4, 73.1, 75.0, 70.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666C5AB2841000000A0D6015841CDCCCCCCCCAC52409A999999B9AB284100000060D6015841CDCCCCCCCCAC524033333333B8AB28419A9999F9D7015841CDCCCCCCCCAC524000000000C4AB284166666626D8015841CDCCCCCCCCAC524066666666C5AB2841000000A0D6015841CDCCCCCCCCAC5240', 'BATIMENT0000000314348781', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 69.8, 74.8, 75.8, 70.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999964AC2841CDCCCC8CD40158413333333333B35240CDCCCCCC67AC28419A999999D40158413333333333B352400000000069AC2841333333D3D30158413333333333B352409A99999965AC28419A9999B9D30158413333333333B352409A99999964AC2841CDCCCC8CD40158413333333333B35240', 'BATIMENT0000000314348823', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 70.7, 74.8, 76.7, 70.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666691AC284100000060EB015841CDCCCCCCCCEC51406666666694AC28419A9999D9E8015841CDCCCCCCCCEC51403333333390AC2841666666C6E8015841CDCCCCCCCCEC5140CDCCCCCC8CAC284100000040EB015841CDCCCCCCCCEC51406666666691AC284100000060EB015841CDCCCCCCCCEC5140', 'BATIMENT0000000314348842', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.6, 70.2, 71.8, 72.8, 70.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333339DAB2841666666A600025841000000000000524033333333A4AB28410000000001025841000000000000524033333333A8AB2841666666C6FF0158410000000000005240CDCCCCCCA0AB2841CDCCCC6CFF01584100000000000052409A9999999FAB2841CDCCCCCCFF0158410000000000005240333333339DAB2841666666A6000258410000000000005240', 'BATIMENT0000000314348861', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 69.4, 72.0, 74.3, 69.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000004DAB2841CDCCCC8C98015841CDCCCCCCCC2C5340000000004DAB2841666666C697015841CDCCCCCCCC2C53400000000047AB2841000000C097015841CDCCCCCCCC2C5340CDCCCCCC46AB28416666668698015841CDCCCCCCCC2C5340000000004DAB2841CDCCCC8C98015841CDCCCCCCCC2C5340', 'BATIMENT0000000314349846', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 73.2, 76.8, 81.8, 73.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000E9AA2841CDCCCC8CBE015841000000000060534033333333EEAA28419A999999BE0158410000000000605340CDCCCCCCEEAA2841000000C0BD01584100000000006053409A999999E9AA2841333333B3BD015841000000000060534000000000E9AA2841CDCCCC8CBE0158410000000000605340', 'BATIMENT0000000314349288', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.5, 72.0, 77.5, 78.7, 72.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999913AC28419A9999B9C00158419A99999999F95240CDCCCCCC14AC2841CDCCCC6CBF0158419A99999999F95240CDCCCCCC0DAC284133333353BF0158419A99999999F95240000000000CAC2841000000A0C00158419A99999999F952409A99999913AC28419A9999B9C00158419A99999999F95240', 'BATIMENT0000000314349398', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.1, 70.9, 75.9, 77.3, 71.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333B8A92841000000E0BB0158413333333333B3524066666666C5A92841CDCCCCECBB0158413333333333B352409A999999C5A9284100000060BB0158413333333333B3524033333333B8A92841CDCCCC4CBB0158413333333333B3524033333333B8A92841000000E0BB0158413333333333B35240', 'BATIMENT0000000314349505', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.9, 73.0, 74.9, 75.0, 73.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000066666666DDA828413333337392015841CDCCCCCCCCEC534033333333EFA828419A99999992015841CDCCCCCCCCEC5340CDCCCCCCEEA82841CDCCCCEC93015841CDCCCCCCCCEC534000000000ECA82841CDCCCCEC93015841CDCCCCCCCCEC534033333333EBA82841CDCCCCCC95015841CDCCCCCCCCEC5340CDCCCCCCF1A82841333333D395015841CDCCCCCCCCEC534033333333F3A82841000000C091015841CDCCCCCCCCEC53409A999999DDA82841666666A691015841CDCCCCCCCCEC534066666666DDA828413333337392015841CDCCCCCCCCEC5340', 'BATIMENT0000000314349534', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.1, 74.7, 79.8, 80.8, 75.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666A9AB284100000080CC015841000000000060524066666666A1AB284100000060CC01584100000000006052409A999999A0AB284100000020CD0158410000000000605240CDCCCCCCA8AB284100000040CD015841000000000060524066666666A9AB284100000080CC0158410000000000605240', 'BATIMENT0000000314349706', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 70.6, 73.5, 77.5, 70.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC10AB28419A999939BA0158410000000000A052409A9999990EAB284166666626BD0158410000000000A052400000000017AB284100000040BD0158410000000000A052403333333319AB28419A999959BA0158410000000000A05240CDCCCCCC10AB28419A999939BA0158410000000000A05240', 'BATIMENT0000000314349760', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 71.4, 74.5, 74.6, 71.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999969AD284133333393BC0158410000000000405340000000006BAD284100000000BC0158410000000000405340CDCCCCCC66AD28419A9999D9BB01584100000000004053403333333364AD2841666666E6BC01584100000000004053406666666668AD284133333313BD01584100000000004053409A99999969AD284133333393BC0158410000000000405340', 'BATIMENT0000000314349822', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.8, 72.2, 77.0, 79.0, 72.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333334FAA2841CDCCCCECE8015841CDCCCCCCCC2C52409A99999948AA2841000000E0E8015841CDCCCCCCCC2C5240CDCCCCCC48AA2841CDCCCCECE9015841CDCCCCCCCC2C5240000000004FAA2841333333F3E9015841CDCCCCCCCC2C5240333333334FAA2841CDCCCCECE8015841CDCCCCCCCC2C5240', 'BATIMENT0000000314349874', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.6, 71.2, 72.8, 74.4, 71.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000D00000033333333F6AF284133333373C4015841666666666686554066666666FAAF28419A999979C4015841666666666686554066666666FBAF28419A999979C40158416666666666865540CDCCCCCCFFAF28419A999979C40158416666666666865540000000000CB0284100000080C401584166666666668655406666666615B0284100000080C401584166666666668655400000000014B02841000000E0C20158416666666666865540666666660AB028419A9999D9C20158416666666666865540CDCCCCCCFDAF2841666666C6C201584166666666668655409A999999F6AF2841000000C0C2015841666666666686554000000000F5AF2841000000C0C2015841666666666686554000000000F5AF284166666606C3015841666666666686554033333333F6AF284133333373C40158416666666666865540', 'BATIMENT0000000314348525', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.1, 78.1, 86.2, 86.6, 78.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCBFA92841666666C6B7025841000000000000504033333333C6A92841333333F3B70258410000000000005040CDCCCCCCC9A9284100000000B6025841000000000000504066666666C3A92841333333D3B50258410000000000005040CDCCCCCCBFA92841666666C6B70258410000000000005040', 'BATIMENT0000000314340983', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 61.1, 64.1, 65.8, 61.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000024AB28419A999939AE0258410000000000C051409A99999920AB284166666626B10258410000000000C051409A99999924AB284166666646B10258410000000000C05140CDCCCCCC27AB2841CDCCCC6CAE0258410000000000C051403333333325AB284166666646AE0258410000000000C051400000000024AB28419A999939AE0258410000000000C05140', 'BATIMENT0000000314340988', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 66.9, 71.0, 71.9, 67.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000DDAB28410000006091025841CDCCCCCCCCAC52409A999999D6AB28419A99991991025841CDCCCCCCCCAC524000000000D4AB28410000000092025841CDCCCCCCCCAC52409A999999DAAB2841CDCCCC4C92025841CDCCCCCCCCAC524000000000DDAB28410000006091025841CDCCCCCCCCAC5240', 'BATIMENT0000000314341000', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 71.2, 74.8, 76.3, 71.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333330FAC2841000000C037025841CDCCCCCCCCEC5240666666660DAC28419A99995938025841CDCCCCCCCCEC52403333333312AC28416666668638025841CDCCCCCCCCEC5240CDCCCCCC13AC28419A9999F937025841CDCCCCCCCCEC5240333333330FAC2841000000C037025841CDCCCCCCCCEC5240', 'BATIMENT0000000314349591', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.5, 71.3, 75.8, 76.6, 71.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999CEAC28410000002077025841666666666646534033333333D6AC2841CDCCCC8C77025841666666666646534066666666DAAC284133333373760258416666666666465340CDCCCCCCD2AC2841000000007602584166666666664653409A999999CEAC284100000020770258416666666666465340', 'BATIMENT0000000314348595', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.9, 75.2, 77.1, 77.5, 75.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999A7AD28419A999919470258413333333333F3554033333333ACAD2841CDCCCC4C470258413333333333F35540CDCCCCCCAEAD284100000020460258413333333333F3554066666666AAAD2841333333F3450258413333333333F355409A999999A7AD28419A999919470258413333333333F35540', 'BATIMENT0000000314348634', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.3, 81.5, 87.8, 89.3, 81.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666638AD2841CDCCCC8C3E0258419A99999999F954403333333342AD2841CDCCCCEC3E0258419A99999999F954403333333343AD28419A9999F93E0258419A99999999F95440CDCCCCCC43AD2841CDCCCC6C3E0258419A99999999F954403333333339AD2841CDCCCC2C3E0258419A99999999F954406666666638AD2841CDCCCC8C3E0258419A99999999F95440', 'BATIMENT0000000314348647', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.5, 79.4, 83.9, 84.1, 80.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000FDAC2841CDCCCC4C650258410000000000E05340666666660FAD2841CDCCCC2C660258410000000000E05340CDCCCCCC11AD284100000060650258410000000000E053409A999999FFAC2841CDCCCC6C640258410000000000E0534000000000FDAC2841CDCCCC4C650258410000000000E05340', 'BATIMENT0000000314348668', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 77.5, 79.5, 83.3, 77.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCD0B52841000000A0B5FE5741000000000020584000000000CBB5284133333313B5FE5741000000000020584066666666C9B528419A999939B5FE574100000000002058409A999999A8B5284133333393B1FE574100000000002058406666666697B52841666666E6B3FE5741000000000020584033333333C9B5284133333393B9FE5741000000000020584033333333DCB5284100000000B7FE57410000000000205840CDCCCCCCD0B52841000000A0B5FE57410000000000205840', 'BATIMENT0000000314331664', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:14.231+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.5, 88.0, 96.5, 98.1, 92.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000666666665EAF28410000004058015841CDCCCCCCCC6C5640CDCCCCCC51AF28419A9999F956015841CDCCCCCCCC6C5640CDCCCCCC49AF28410000002058015841CDCCCCCCCC6C5640666666665BAF2841000000005A015841CDCCCCCCCC6C5640333333335FAF2841CDCCCC6C5A015841CDCCCCCCCC6C5640CDCCCCCC62AF2841CDCCCCCC5A015841CDCCCCCCCC6C5640000000006BAF28416666668659015841CDCCCCCCCC6C5640666666665EAF28410000004058015841CDCCCCCCCC6C5640', 'BATIMENT0000000314347390', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.8, 84.9, 89.7, 91.2, 86.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333330CAC2841666666E6760158419A99999999195340333333330CAC28419A9999F9750158419A999999991953403333333305AC284100000000760158419A999999991953406666666605AC2841666666E6760158419A99999999195340333333330CAC2841666666E6760158419A99999999195340', 'BATIMENT0000000314347652', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 74.5, 76.5, 76.8, 74.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333334DAE2841CDCCCC6C9101584100000000000055409A99999942AE2841333333539101584100000000000055409A99999940AE2841333333D3920158410000000000005540CDCCCCCC4CAE2841CDCCCCEC920158410000000000005540000000004DAE284100000040920158410000000000005540333333334DAE2841CDCCCC6C910158410000000000005540', 'BATIMENT0000000314349456', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.1, 77.0, 84.1, 84.9, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCFFAD2841CDCCCC2C8F0158419A9999999919544033333333E3AD2841000000208F0158419A999999991954409A999999E2AD28419A9999F9900158419A9999999919544066666666FEAD284100000000910158419A99999999195440CDCCCCCCFFAD2841CDCCCC2C8F0158419A99999999195440', 'BATIMENT0000000314348442', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.7, 74.8, 80.4, 80.7, 75.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666664DAE2841333333D3EF0158419A99999999B95440CDCCCCCC4DAE284166666686F00158419A99999999B95440666666665FAE28419A999959F00158419A99999999B95440666666665FAE28419A999999EF0158419A99999999B95440666666664DAE2841333333D3EF0158419A99999999B95440', 'BATIMENT0000000314348775', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.6, 76.4, 82.9, 83.8, 76.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333338BAB28419A999979000258416666666666665340666666668EAB28419A9999990002584166666666666653403333333392AB2841CDCCCC4CFF01584166666666666653409A9999998DAB28419A999919FF01584166666666666653409A99999989AB2841CDCCCC6C000258416666666666665340333333338BAB28419A999979000258416666666666665340', 'BATIMENT0000000314348860', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.6, 69.1, 77.7, 78.3, 69.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000E9AF2841666666C6B70158419A9999999939544066666666E9AF284133333393B60158419A999999993954409A999999E5AF284166666686B60158419A9999999939544000000000E5AF2841000000C0B70158419A9999999939544000000000E9AF2841666666C6B70158419A99999999395440', 'BATIMENT0000000314348920', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 78.3, 80.9, 81.2, 78.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333397AD2841666666C69D01584100000000008053409A99999998AD2841333333D39E0158410000000000805340CDCCCCCCA0AD2841CDCCCCAC9E0158410000000000805340333333339FAD28419A9999999D01584100000000008053403333333397AD2841666666C69D0158410000000000805340', 'BATIMENT0000000314348952', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 73.0, 78.0, 79.7, 73.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666C5AD2841000000E09E015841CDCCCCCCCC2C544000000000C4AD2841CDCCCC0C9E015841CDCCCCCCCC2C54409A999999B6AD2841CDCCCC4C9E015841CDCCCCCCCC2C54409A999999B7AD2841666666269F015841CDCCCCCCCC2C544066666666C5AD2841000000E09E015841CDCCCCCCCC2C5440', 'BATIMENT0000000314348956', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 73.3, 80.8, 81.3, 73.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666668FAD2841CDCCCC8CB30158410000000000E053409A9999998FAD28419A999999B00158410000000000E05340CDCCCCCC86AD2841666666A6B00158410000000000E05340CDCCCCCC86AD284100000060B10158410000000000E053400000000087AD2841CDCCCC8CB30158410000000000E053400000000088AD2841CDCCCC8CB30158410000000000E05340666666668FAD2841CDCCCC8CB30158410000000000E05340', 'BATIMENT0000000314349174', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.0, 72.5, 79.5, 79.8, 72.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666694AE284166666626CE015841CDCCCCCCCC0C5440666666669FAE2841333333F3CD015841CDCCCCCCCC0C5440CDCCCCCC9CAE28419A999919CC015841CDCCCCCCCC0C54406666666694AE284100000080CC015841CDCCCCCCCC0C54400000000092AE28419A999999CC015841CDCCCCCCCC0C54406666666694AE284166666626CE015841CDCCCCCCCC0C5440', 'BATIMENT0000000314349246', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.1, 74.2, 80.3, 80.8, 74.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B0000009A999999F0AC2841000000A09D015841000000000020544066666666EEAC2841000000C09C01584100000000002054409A999999E5AC2841CDCCCC2C9D015841000000000020544000000000E1AC2841CDCCCC8C9B015841000000000020544033333333D7AC2841000000009C015841000000000020544066666666DAAC2841CDCCCC4C9D015841000000000020544033333333E2AC2841333333539D015841000000000020544033333333EBAC2841333333B39F015841000000000020544033333333F3AC2841CDCCCC0C9F015841000000000020544033333333F4AC28419A9999F99E01584100000000002054409A999999F0AC2841000000A09D0158410000000000205440', 'BATIMENT0000000314349413', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.1, 73.4, 80.5, 81.5, 73.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666EEAB284100000080C80158413333333333B3524066666666EDAB284133333373C90158413333333333B3524033333333F4AB28419A999999C90158413333333333B35240CDCCCCCCF5AB2841666666A6C80158413333333333B3524066666666EEAB284100000080C80158413333333333B35240', 'BATIMENT0000000314349468', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.6, 70.3, 74.9, 76.3, 70.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666664FAD284166666606B10158416666666666E652406666666652AD284166666606B10158416666666666E652406666666652AD284166666646B00158416666666666E65240333333334FAD284100000040B00158416666666666E65240666666664FAD284166666606B10158416666666666E65240', 'BATIMENT0000000314349848', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 72.5, 75.7, 75.9, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000064AE284100000060BF015841CDCCCCCCCC2C53406666666664AE2841000000E0BF015841CDCCCCCCCC2C53403333333365AE284166666606C1015841CDCCCCCCCC2C5340333333336CAE2841333333F3C0015841CDCCCCCCCC2C5340000000006BAE2841CDCCCC4CBF015841CDCCCCCCCC2C53400000000064AE284100000060BF015841CDCCCCCCCC2C5340', 'BATIMENT0000000314349853', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 73.6, 76.7, 76.9, 73.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999994DAF2841000000E09101584100000000008054406666666654AF2841666666E69101584100000000008054400000000055AF284166666606910158410000000000805440333333334EAF2841666666069101584100000000008054409A9999994DAF2841000000E0910158410000000000805440', 'BATIMENT0000000314349858', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 80.1, 82.1, 82.3, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666CFAF284133333313CA015841CDCCCCCCCCEC5340CDCCCCCCCBAF284133333313CA015841CDCCCCCCCCEC53409A999999CCAF284166666686CA015841CDCCCCCCCCEC53409A999999CFAF2841CDCCCC8CCA015841CDCCCCCCCCEC534066666666CFAF284133333313CA015841CDCCCCCCCCEC5340', 'BATIMENT0000000314349862', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 77.8, 79.8, 80.8, 77.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999992CAE284133333353520158419A99999999D95440333333332AAE284100000020530158419A99999999D954403333333333AE284133333393530158419A99999999D954403333333334AE284100000040530158419A99999999D954409A99999935AE2841CDCCCCCC520158419A99999999D954403333333332AE2841000000A0520158419A99999999D954409A9999992CAE284133333353520158419A99999999D95440', 'BATIMENT0000000314347166', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 80.3, 83.5, 85.8, 80.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000D0AD2841666666E65B0158410000000000E054409A999999BFAD2841333333135B0158410000000000E0544000000000B8AD2841333333F35D0158410000000000E0544033333333C6AD2841666666A65E0158410000000000E0544000000000D0AD2841666666E65B0158410000000000E05440', 'BATIMENT0000000314347195', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.3, 77.2, 83.5, 84.6, 77.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333334AE28419A9999597D0158416666666666865440333333332FAE28419A9999597E0158416666666666865440000000002EAE28419A9999997E01584166666666668654403333333336AE2841000000407F0158416666666666865440666666663CAE2841000000007E01584166666666668654403333333334AE28419A9999597D0158416666666666865440', 'BATIMENT0000000314347210', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 77.2, 82.2, 83.5, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666664AAA2841000000C07701584100000000002053400000000053AA2841CDCCCCAC7701584100000000002053409A99999952AA2841333333937601584100000000002053406666666649AA2841CDCCCCAC760158410000000000205340666666664AAA2841000000C0770158410000000000205340', 'BATIMENT0000000314347644', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 74.5, 76.5, 77.8, 74.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCFAA7284100000060AB01584133333333337354409A999999FBA7284166666666AA015841333333333373544033333333F4A7284133333353AA0158413333333333735440CDCCCCCCF3A7284133333353AB0158413333333333735440CDCCCCCCFAA7284100000060AB0158413333333333735440', 'BATIMENT0000000314346915', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.8, 76.1, 81.9, 81.9, 76.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666A2A82841333333B3A2015841666666666606534033333333A2A82841CDCCCC4CA201584166666666660653406666666696A828419A999979A20158416666666666065340CDCCCCCC96A828419A9999D9A2015841666666666606534066666666A2A82841333333B3A20158416666666666065340', 'BATIMENT0000000314349546', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.5, 74.7, 76.2, 76.8, 74.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999913AB284166666606C201584100000000004053406666666614AB28419A9999F9C001584100000000004053403333333308AB2841333333D3C001584100000000004053409A99999907AB2841000000E0C101584100000000004053409A9999990FAB28419A9999F9C101584100000000004053409A99999913AB284166666606C20158410000000000405340', 'BATIMENT0000000314349762', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.6, 71.4, 77.0, 80.8, 71.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999990FAB28419A9999F9C10158416666666666A653409A99999907AB2841000000E0C10158416666666666A6534033333333FCAA2841000000C0C10158416666666666A65340CDCCCCCCF9AA284166666606C50158416666666666A65340333333330DAB284100000040C50158416666666666A653409A9999990FAB28419A9999F9C10158416666666666A65340', 'BATIMENT0000000314349763', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.3, 71.4, 78.7, 79.3, 71.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333343AE284100000060960158413333333333335440333333333CAE2841666666469601584133333333333354409A9999993BAE2841000000409701584133333333333354406666666642AE2841CDCCCC4C9701584133333333333354403333333343AE284100000060960158413333333333335440', 'BATIMENT0000000314349850', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 77.9, 80.8, 81.0, 78.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC91AF28419A9999F9B20158419A99999999595540CDCCCCCC8CAF2841CDCCCCECB20158419A99999999595540666666668CAF284100000080B30158419A99999999595540666666668CAF2841000000C0B30158419A999999995955403333333391AF2841CDCCCCCCB30158419A99999999595540CDCCCCCC91AF28419A9999F9B20158419A99999999595540', 'BATIMENT0000000314349110', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.2, 78.3, 85.4, 85.7, 78.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC0BAF2841CDCCCCACAD0158410000000000E053403333333310AF2841CDCCCCECAD0158410000000000E053406666666614AF2841333333B3AC0158410000000000E053409A9999990FAF284133333373AC0158410000000000E05340CDCCCCCC0BAF2841CDCCCCACAD0158410000000000E05340', 'BATIMENT0000000314349856', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 77.5, 79.5, 79.7, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333367AF284166666606B80158419A99999999B95340333333336CAF2841CDCCCC0CB80158419A99999999B95340000000006DAF2841333333D3B60158419A99999999B953400000000068AF28419A9999B9B60158419A99999999B953403333333367AF284166666606B80158419A99999999B95340', 'BATIMENT0000000314349865', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.9, 77.1, 79.0, 79.5, 77.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333EEAE284100000000EF01584100000000000054409A999999F4AE284100000020EF0158410000000000005440CDCCCCCCF4AE28419A999999EE015841000000000000544000000000EFAE284100000080EE015841000000000000544033333333EEAE284100000000EF0158410000000000005440', 'BATIMENT0000000314348872', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 76.4, 80.1, 81.3, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC37B128419A9999D98101584166666666660659409A9999993DB1284166666686810158416666666666065940CDCCCCCC3BB128419A9999198101584166666666660659406666666636B12841CDCCCC4C810158416666666666065940CDCCCCCC37B128419A9999D9810158416666666666065940', 'BATIMENT0000000314341096', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.8, 92.4, 100.2, 100.6, 93.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666675B22841000000C0780158416666666666A65840666666667EB22841CDCCCCCC7A0158416666666666A65840CDCCCCCC87B22841000000207A0158416666666666A65840333333337FB2284166666606780158416666666666A658406666666675B22841000000C0780158416666666666A65840', 'BATIMENT0000000314341130', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.3, 93.4, 98.7, 99.8, 94.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999CDB728413333339345025841666666666626564066666666C7B72841666666E6440258416666666666265640CDCCCCCCC0B72841CDCCCCCC45025841666666666626564066666666C7B72841000000804602584166666666662656409A999999CDB7284133333393450258416666666666265640', 'BATIMENT0000000314350012', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.3, 80.4, 88.7, 88.9, 80.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC60B12841CDCCCC6CAF0158419A999999995956400000000068B12841CDCCCC6CAF0158419A999999995956406666666668B12841000000A0AE0158419A99999999595640CDCCCCCC60B12841666666A6AE0158419A99999999595640CDCCCCCC60B12841CDCCCC6CAF0158419A99999999595640', 'BATIMENT0000000314350056', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 82.5, 89.4, 89.7, 83.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333395B12841CDCCCCAC8D01584100000000004059403333333393B12841CDCCCC2C8B0158410000000000405940666666668CB12841000000408B01584100000000004059409A9999998EB12841333333B38D01584100000000004059403333333395B12841CDCCCCAC8D0158410000000000405940', 'BATIMENT0000000314350093', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 97.1, 101.0, 101.8, 97.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000087B22841666666069D01584166666666666656409A99999985B228419A9999799E01584166666666666656409A9999998BB22841333333B39E01584166666666666656409A9999998CB228419A9999399E01584166666666666656400000000092B22841666666669E01584166666666666656400000000093B22841333333B39D01584166666666666656400000000087B22841666666069D0158416666666666665640', 'BATIMENT0000000314350190', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 86.6, 89.6, 90.4, 87.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666B0AF28419A999939770158410000000000E05540CDCCCCCCBDAF284100000000770158410000000000E055409A999999BDAF2841000000A0760158410000000000E05540CDCCCCCCAFAF2841CDCCCCCC760158410000000000E0554066666666B0AF28419A999939770158410000000000E05540', 'BATIMENT0000000314347071', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 84.6, 87.5, 88.0, 85.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999988AE2841333333736D01584133333333339354409A9999997FAE2841CDCCCCCC6E0158413333333333935440333333337BAE28419A9999796F01584133333333339354406666666695AE2841666666A671015841333333333393544033333333A1AE2841666666C66F01584133333333339354409A99999988AE2841333333736D0158413333333333935440', 'BATIMENT0000000314347295', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 79.1, 82.3, 85.5, 80.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999912AF28416666664680015841CDCCCCCCCC6C5540000000000CAF28416666660680015841CDCCCCCCCC6C5540CDCCCCCC0AAF2841CDCCCC8C80015841CDCCCCCCCC6C55409A99999911AF2841000000E080015841CDCCCCCCCC6C55409A99999912AF28416666664680015841CDCCCCCCCC6C5540', 'BATIMENT0000000314347526', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 81.7, 85.8, 85.9, 82.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666622AE2841CDCCCC6C8A0158419A99999999595540000000002BAE28419A9999798A0158419A999999995955400000000035AE2841333333B3880158419A999999995955403333333330AE2841CDCCCCEC870158419A999999995955406666666622AE2841CDCCCC6C8A0158419A99999999595540', 'BATIMENT0000000314348377', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 9.7, 75.8, 85.5, 86.7, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000015AE284133333313A501584100000000000054406666666608AE284166666646A501584100000000000054409A9999990AAE2841333333D3A601584100000000000054406666666614AE2841CDCCCC0CA701584100000000000054409A99999916AE284133333313A701584100000000000054400000000015AE284133333313A50158410000000000005440', 'BATIMENT0000000314348411', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.4, 73.7, 80.1, 81.2, 74.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCEBAD2841666666C69301584100000000008054409A999999E8AD28419A9999B9930158410000000000805440CDCCCCCCDDAD28416666668693015841000000000080544033333333DCAD28419A9999B994015841000000000080544066666666E4AD2841CDCCCCCC940158410000000000805440CDCCCCCCE4AD2841CDCCCC6C95015841000000000080544000000000ECAD284133333373950158410000000000805440CDCCCCCCEBAD2841666666C6930158410000000000805440', 'BATIMENT0000000314348435', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 74.7, 82.0, 82.3, 75.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999994FAE284133333333A801584100000000000054406666666655AE2841CDCCCC8CA80158410000000000005440CDCCCCCC58AE2841CDCCCCCCA701584100000000000054403333333353AE284133333373A701584100000000000054409A9999994FAE284133333333A80158410000000000005440', 'BATIMENT0000000314348439', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.2, 74.9, 80.1, 80.8, 75.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000097AE284166666666A301584133333333333355406666666692AE2841666666A6A50158413333333333335540CDCCCCCC9AAE2841000000E0A501584133333333333355409A999999A2AE284133333313A601584133333333333355409A999999A4AE2841333333B3A301584133333333333355400000000097AE284166666666A30158413333333333335540', 'BATIMENT0000000314348483', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 77.4, 84.8, 85.4, 78.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999965AF2841000000C0C40158410000000000E054409A99999960AF28419A999979C40158410000000000E054403333333360AF284100000080C50158410000000000E05440CDCCCCCC67AF2841333333F3C50158410000000000E054406666666668AF2841CDCCCCECC40158410000000000E054409A99999965AF2841000000C0C40158410000000000E05440', 'BATIMENT0000000314348526', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 76.6, 83.5, 86.0, 76.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333E6AF28419A999959C5015841000000000020544066666666D6AF284133333353C5015841000000000020544033333333D6AF2841333333B3C5015841000000000020544033333333E6AF2841000000C0C5015841000000000020544033333333E6AF28419A999959C50158410000000000205440', 'BATIMENT0000000314348527', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 77.8, 80.5, 81.8, 78.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333334BAF284133333373C10158413333333333F35440CDCCCCCC40AF28419A999999C20158413333333333F354406666666646AF2841CDCCCCECC20158413333333333F35440CDCCCCCC4EAF2841CDCCCC6CC30158413333333333F35440333333334BAF284133333373C10158413333333333F35440', 'BATIMENT0000000314348539', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.6, 76.3, 83.9, 84.7, 76.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999C3AF28419A999959AC0158410000000000C0544033333333C3AF28419A9999F9AC0158410000000000C0544033333333D3AF2841CDCCCC0CAD0158410000000000C0544066666666D3AF284166666666AC0158410000000000C054409A999999C3AF28419A999959AC0158410000000000C05440', 'BATIMENT0000000314348922', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 79.9, 83.0, 85.3, 80.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000047AF2841333333130B0258410000000000005540333333335FAF2841333333930A0258410000000000005540666666665DAF2841333333730902584100000000000055409A99999945AF2841CDCCCCEC0902584100000000000055400000000047AF2841333333130B0258410000000000005540', 'BATIMENT0000000314348794', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.9, 79.2, 84.1, 85.2, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B00000000000000B4AE2841CDCCCC4CDF015841CDCCCCCCCC6C544066666666C5AE284166666626DF015841CDCCCCCCCC6C544066666666C9AE28419A999919DF015841CDCCCCCCCC6C544066666666C8AE28419A999959DD015841CDCCCCCCCC6C544033333333C4AE284166666666DD015841CDCCCCCCCC6C5440CDCCCCCCC3AE2841000000C0DC015841CDCCCCCCCC6C544000000000C3AE284166666686DB015841CDCCCCCCCC6C544000000000B5AE2841666666C6DB015841CDCCCCCCCC6C544000000000B7AE2841000000C0DE015841CDCCCCCCCC6C54409A999999B3AE2841666666C6DE015841CDCCCCCCCC6C544000000000B4AE2841CDCCCC4CDF015841CDCCCCCCCC6C5440', 'BATIMENT0000000314348886', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.5, 75.3, 81.8, 82.5, 75.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC20B0284100000020C50158419A99999999795540CDCCCCCC36B02841CDCCCCECC40158419A999999997955409A99999949B02841CDCCCCACC40158419A999999997955403333333348B0284100000060C20158419A99999999795540000000001FB02841333333D3C20158419A99999999795540CDCCCCCC20B0284100000020C50158419A99999999795540', 'BATIMENT0000000314348929', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 78.5, 86.0, 86.5, 79.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC44AF284100000020A60158419A999999997954409A9999993FAF2841CDCCCC0CA60158419A99999999795440CDCCCCCC3EAF2841333333D3A60158419A99999999795440CDCCCCCC43AF2841CDCCCCECA60158419A99999999795440CDCCCCCC44AF284100000020A60158419A99999999795440', 'BATIMENT0000000314349094', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 78.4, 81.9, 82.5, 78.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCC6AF28419A999959950158413333333333135640CDCCCCCCBEAF2841000000609501584133333333331356409A999999BEAF28419A9999B9950158413333333333135640CDCCCCCCC6AF2841CDCCCCAC950158413333333333135640CDCCCCCCC6AF28419A999959950158413333333333135640', 'BATIMENT0000000314349233', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.8, 81.6, 88.3, 89.0, 81.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC2AAF284100000060B0015841CDCCCCCCCCAC5440666666662FAF284166666686B0015841CDCCCCCCCCAC54400000000030AF28419A999919B0015841CDCCCCCCCCAC5440333333332CAF2841333333F3AF015841CDCCCCCCCCAC5440CDCCCCCC2AAF284100000060B0015841CDCCCCCCCCAC5440', 'BATIMENT0000000314349256', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.4, 77.4, 82.8, 83.8, 77.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000098AE2841CDCCCC6C940158419A99999999F954400000000093AE284100000060940158419A99999999F95440CDCCCCCC91AE28419A999999950158419A99999999F954409A99999997AE2841CDCCCCAC950158419A99999999F954400000000098AE2841CDCCCC6C940158419A99999999F95440', 'BATIMENT0000000314349292', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 79.5, 83.9, 84.2, 79.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999939AF284100000020C70158410000000000C053400000000028AF28419A9999B9C70158410000000000C05340CDCCCCCC29AF2841CDCCCC6CC80158410000000000C05340CDCCCCCC33AF284100000020C80158410000000000C053409A99999939AF284100000020C70158410000000000C05340', 'BATIMENT0000000314349423', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 76.4, 79.0, 79.4, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C000000CDCCCCCC4CAE2841666666A6BB015841CDCCCCCCCC6C5440000000004DAE284100000020BD015841CDCCCCCCCC6C5440000000004DAE2841000000A0BD015841CDCCCCCCCC6C5440CDCCCCCC52AE284133333393BD015841CDCCCCCCCC6C54406666666657AE284133333313BD015841CDCCCCCCCC6C54400000000056AE2841666666E6BB015841CDCCCCCCCC6C5440CDCCCCCC61AE2841CDCCCCCCBB015841CDCCCCCCCC6C54406666666660AE28419A999979BA015841CDCCCCCCCC6C54409A9999995EAE28419A999919B9015841CDCCCCCCCC6C5440CDCCCCCC4CAE284166666646B9015841CDCCCCCCCC6C5440CDCCCCCC4CAE28419A999959B9015841CDCCCCCCCC6C5440CDCCCCCC4CAE2841666666A6BB015841CDCCCCCCCC6C5440', 'BATIMENT0000000314349575', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.3, 73.4, 81.7, 83.0, 73.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCEBAE28419A9999398C0158410000000000C055409A999999ECAE2841333333338A0158410000000000C055409A999999E0AE2841333333338A0158410000000000C0554066666666E0AE2841666666268C0158410000000000C05540CDCCCCCCEBAE28419A9999398C0158410000000000C05540', 'BATIMENT0000000314349586', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.8, 79.3, 87.1, 87.7, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCD2AF2841000000A006025841000000000040554033333333D3AF284166666666060258410000000000405540CDCCCCCCD4AF2841666666A605025841000000000040554066666666D0AF28416666668605025841000000000040554066666666CEAF284100000080060258410000000000405540CDCCCCCCD2AF2841000000A0060258410000000000405540', 'BATIMENT0000000314349896', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.1, 80.0, 85.1, 85.6, 80.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666C8B028419A99991920025841000000000040574033333333BAB0284133333373200258410000000000405740CDCCCCCCBBB028416666664621025841000000000040574000000000CAB02841333333D320025841000000000040574066666666C8B028419A999919200258410000000000405740', 'BATIMENT0000000314350029', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.2, 86.8, 93.0, 93.6, 87.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333B2B02841666666C6A3015841CDCCCCCCCC6C554033333333B6B02841666666C6A3015841CDCCCCCCCC6C554033333333B6B02841666666C6A1015841CDCCCCCCCC6C554033333333B2B02841666666C6A1015841CDCCCCCCCC6C554033333333B2B02841666666C6A3015841CDCCCCCCCC6C5540', 'BATIMENT0000000314350074', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 82.5, 85.8, 86.7, 83.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999999CB0284100000060F40058413333333333735A4066666666ABB02841CDCCCCECF40058413333333333735A409A999999ACB028419A999959F40058413333333333735A409A9999999EB02841CDCCCCCCF30058413333333333735A409A9999999CB0284100000060F40058413333333333735A40', 'BATIMENT0000000314341205', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.5, 104.4, 105.8, 106.3, 105.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000E5B1284100000020540158419A99999999F95B4033333333E9B1284166666646550158419A99999999F95B406666666606B22841000000C0530158419A99999999F95B406666666602B22841333333B3520158419A99999999F95B40CDCCCCCCFFB12841CDCCCCCC520158419A99999999F95B40CDCCCCCCEAB12841333333D3530158419A99999999F95B4000000000E5B1284100000020540158419A99999999F95B40', 'BATIMENT0000000314341140', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.6, 105.4, 112.0, 113.2, 106.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000047B22841666666C64A0158419A99999999995B40CDCCCCCC49B22841000000C0480158419A99999999995B40CDCCCCCC42B22841000000A0480158419A99999999995B403333333340B22841CDCCCCAC4A0158419A99999999995B400000000047B22841666666C64A0158419A99999999995B40', 'BATIMENT0000000314341158', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.7, 103.8, 110.4, 111.1, 104.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCBFB12841000000000B015841666666666606604066666666B1B12841CDCCCC0C0B015841666666666606604000000000B2B12841333333D30B015841666666666606604066666666C0B12841000000C00B0158416666666666066040CDCCCCCCBFB12841000000000B0158416666666666066040', 'BATIMENT0000000314341188', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.4, 119.9, 128.3, 130.3, 120.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000006DB528419A9999799E005841CDCCCCCCCCEC5A406666666668B528419A9999799E005841CDCCCCCCCCEC5A409A99999968B52841666666069F005841CDCCCCCCCCEC5A40333333336DB52841000000009F005841CDCCCCCCCCEC5A40000000006DB528419A9999799E005841CDCCCCCCCCEC5A40', 'BATIMENT0000000314341249', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 103.8, 107.8, 108.7, 104.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666DFAF284133333373510158416666666666E6574066666666E2AF284100000080510158416666666666E657409A999999E3AF2841CDCCCC4C500158416666666666E657409A999999D4AF2841333333F34F0158416666666666E6574033333333D3AF28419A999939510158416666666666E6574066666666DFAF284133333373510158416666666666E65740', 'BATIMENT0000000314347076', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.5, 91.2, 95.7, 96.2, 91.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999994BAF284166666686520158410000000000A055400000000045AF284100000020520158410000000000A05540CDCCCCCC42AF2841000000A0520158410000000000A055403333333349AF284166666606530158410000000000A055409A9999994BAF284166666686520158410000000000A05540', 'BATIMENT0000000314347282', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 84.3, 86.5, 90.0, 84.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000009A9999995CAD2841000000203D0158413333333333F35540CDCCCCCC5CAD2841666666263D0158413333333333F35540CDCCCCCC5DAD2841CDCCCC2C3D0158413333333333F355400000000068AD2841666666663D0158413333333333F355403333333368AD2841000000203D0158413333333333F355406666666669AD28419A9999393C0158413333333333F355403333333364AD2841CDCCCC0C3C0158413333333333F35540666666665EAD2841333333F33B0158413333333333F35540CDCCCCCC5CAD2841000000203D0158413333333333F355409A9999995CAD2841000000203D0158413333333333F35540', 'BATIMENT0000000314347442', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 83.7, 87.8, 88.4, 84.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000034B02841000000A0FA0058413333333333B35A409A9999993AB0284100000000FB0058413333333333B35A40CDCCCCCC44B02841CDCCCC2CF80058413333333333B35A406666666640B028419A9999F9F70058413333333333B35A40CDCCCCCC38B0284166666646FA0058413333333333B35A409A99999935B028419A999919FA0058413333333333B35A400000000034B02841000000A0FA0058413333333333B35A40', 'BATIMENT0000000314347505', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 100.9, 106.8, 107.2, 101.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999931AE2841666666A6550158413333333333B354409A99999927AE284133333313550158413333333333B354406666666624AE28419A999919560158413333333333B35440000000002EAE284133333393560158413333333333B354409A99999931AE2841666666A6550158413333333333B35440', 'BATIMENT0000000314347667', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 79.7, 82.8, 83.3, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC1EB02841666666E63B015841CDCCCCCCCC8C5840000000002CB02841333333933B015841CDCCCCCCCC8C5840333333332BB02841666666063B015841CDCCCCCCCC8C5840000000001EB02841000000603B015841CDCCCCCCCC8C5840666666661EB02841000000A03B015841CDCCCCCCCC8C58409A9999991EB02841000000C03B015841CDCCCCCCCC8C5840CDCCCCCC1EB02841666666E63B015841CDCCCCCCCC8C5840', 'BATIMENT0000000314347606', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 95.7, 98.3, 98.7, 96.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000003333333335A82841666666E69D0158419A99999999F95340CDCCCCCC30A828419A9999D99D0158419A99999999F953406666666631A82841000000409D0158419A99999999F953409A9999992AA82841666666269D0158419A99999999F953400000000027A82841666666669F0158419A99999999F95340CDCCCCCC2DA82841666666869F0158419A99999999F95340000000002DA8284166666626A00158419A99999999F953409A99999942A8284100000080A00158419A99999999F953409A99999945A82841CDCCCC2C9E0158419A99999999F953403333333335A82841666666E69D0158419A99999999F95340', 'BATIMENT0000000314346897', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.3, 75.6, 79.9, 80.4, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999B4A82841666666C6BE015841333333333313534000000000B8A82841333333D3C0015841333333333313534033333333BDA82841333333B3C00158413333333333135340CDCCCCCCB9A82841666666A6BE01584133333333331353409A999999B4A82841666666C6BE0158413333333333135340', 'BATIMENT0000000314349542', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 73.4, 76.4, 77.0, 73.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC39AE28410000000053015841CDCCCCCCCC0C55409A99999935AE2841CDCCCCCC52015841CDCCCCCCCC0C55403333333334AE28410000004053015841CDCCCCCCCC0C55400000000038AE28413333337353015841CDCCCCCCCC0C5540CDCCCCCC39AE28410000000053015841CDCCCCCCCC0C5540', 'BATIMENT0000000314347165', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 80.4, 84.3, 86.3, 80.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A999999F1B02841666666C67201584100000000004058409A999999EDB02841CDCCCCEC7201584100000000004058409A999999EFB028413333331374015841000000000040584000000000ECB02841CDCCCC2C740158410000000000405840CDCCCCCCEEB02841000000C075015841000000000040584033333333F7B02841CDCCCC6C7501584100000000004058409A999999F1B02841666666C6720158410000000000405840', 'BATIMENT0000000314341108', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 93.7, 97.1, 98.4, 95.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666640B128419A9999596A0158410000000000A059400000000047B12841333333F3690158410000000000A05940000000003FB12841333333F3670158410000000000A059409A99999936B1284166666666680158410000000000A05940333333333EB12841333333736A0158410000000000A059406666666640B128419A9999596A0158410000000000A05940', 'BATIMENT0000000314341114', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 100.4, 102.6, 104.2, 101.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999F5B12841CDCCCCCC590158410000000000A05B4066666666F3B12841666666E6590158410000000000A05B4033333333F5B12841000000805A0158410000000000A05B409A999999F9B12841CDCCCC4C5A0158410000000000A05B4000000000F9B128419A9999195A0158410000000000A05B409A999999F5B12841CDCCCCCC590158410000000000A05B40', 'BATIMENT0000000314341238', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.6, 103.9, 110.5, 111.3, 104.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333389AF28419A9999196F015841CDCCCCCCCCCC55400000000083AF2841666666866E015841CDCCCCCCCCCC55409A99999980AF2841666666E66E015841CDCCCCCCCCCC5540CDCCCCCC86AF2841000000806F015841CDCCCCCCCCCC55403333333389AF28419A9999196F015841CDCCCCCCCCCC5540', 'BATIMENT0000000314347181', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 84.6, 87.3, 87.8, 85.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999997CAF28419A9999D9560158413333333333535640000000006DAF28419A9999395901584133333333335356400000000074AF2841333333F35901584133333333335356406666666685AF2841CDCCCC4C5701584133333333335356409A9999997CAF28419A9999D9560158413333333333535640', 'BATIMENT0000000314347388', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 86.4, 89.3, 91.1, 87.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000061AF2841CDCCCC2C160158410000000000E057406666666661AF2841333333F3140158410000000000E05740333333335CAF2841666666E6140158410000000000E05740333333335BAF284100000020160158410000000000E057400000000061AF2841CDCCCC2C160158410000000000E05740', 'BATIMENT0000000314347434', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 90.5, 95.5, 98.0, 91.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333FDB02841CDCCCC8C9E0158416666666666A6554066666666F5B02841000000809E0158416666666666A65540CDCCCCCCF4B028419A999959A00158416666666666A65540CDCCCCCCFCB0284166666666A00158416666666666A6554033333333FDB02841CDCCCC8C9E0158416666666666A65540', 'BATIMENT0000000314350187', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.5, 84.2, 86.7, 87.3, 85.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000003333333372AD2841000000C03B01584100000000000056406666666673AD2841333333D33A0158410000000000005640666666666AAD2841333333933A0158410000000000005640CDCCCCCC69AD28419A9999F93A01584100000000000056406666666665AD2841000000E03A01584100000000000056403333333364AD2841CDCCCC0C3C01584100000000000056406666666669AD28419A9999393C01584100000000000056403333333371AD2841CDCCCC6C3C01584100000000000056403333333372AD2841000000C03B0158410000000000005640', 'BATIMENT0000000314347444', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 84.3, 88.0, 91.8, 85.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999D3AE2841CDCCCC2C870158413333333333F354409A999999D2AE284133333373880158413333333333F3544033333333D2AE28419A999939890158413333333333F354409A999999D5AE284100000040890158413333333333F35440CDCCCCCCD6AE284133333333870158413333333333F354409A999999D3AE2841CDCCCC2C870158413333333333F35440', 'BATIMENT0000000314348391', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 79.5, 83.8, 84.5, 80.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000BEB1284166666666BC015841000000000060554033333333BBB1284100000080BA015841000000000060554066666666AFB12841333333D3BA01584100000000006055409A999999B2B128419A9999B9BC015841000000000060554000000000BEB1284166666666BC0158410000000000605540', 'BATIMENT0000000314350114', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.5, 83.1, 85.6, 89.5, 84.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC9FB028419A9999D99D015841CDCCCCCCCC2C574000000000A8B028419A9999D99D015841CDCCCCCCCC2C574033333333A8B02841CDCCCC8C9C015841CDCCCCCCCC2C5740CDCCCCCC9FB028419A9999999C015841CDCCCCCCCC2C5740CDCCCCCC9FB028419A9999D99D015841CDCCCCCCCC2C5740', 'BATIMENT0000000314350183', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 9.5, 83.3, 92.8, 95.0, 83.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333D3AF28416666666606025841CDCCCCCCCC0C554000000000DCAF2841CDCCCCAC06025841CDCCCCCCCC0C554066666666DDAF2841333333F305025841CDCCCCCCCC0C5540CDCCCCCCD4AF2841666666A605025841CDCCCCCCCC0C554033333333D3AF28416666666606025841CDCCCCCCCC0C5540', 'BATIMENT0000000314349895', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 80.2, 84.3, 84.5, 80.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000017AC28419A9999D9850158416666666666E65240333333331DAC2841666666C6850158416666666666E65240000000001CAC284166666626800158416666666666E652403333333316AC284100000020800158416666666666E652400000000017AC28419A9999D9850158416666666666E65240', 'BATIMENT0000000314347680', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 73.5, 75.7, 76.2, 73.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999E4AD284100000080990158416666666666065440CDCCCCCCE5AD2841333333F39A015841666666666606544033333333F1AD2841CDCCCCAC9A015841666666666606544000000000FCAD2841666666669A015841666666666606544033333333FBAD2841333333139A01584166666666660654409A999999F3AD2841666666269A0158416666666666065440CDCCCCCCF2AD2841666666469901584166666666660654409A999999E4AD284100000080990158416666666666065440', 'BATIMENT0000000314348417', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.5, 74.7, 80.2, 80.9, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC60AC2841333333B39F0158410000000000E05340666666665FAC2841CDCCCC8C9E0158410000000000E053409A9999995CAC28419A9999999E0158410000000000E05340000000004FAC2841CDCCCCEC9E0158410000000000E05340000000004EAC2841333333F39E0158410000000000E05340CDCCCCCC4FAC28419A999919A00158410000000000E05340CDCCCCCC60AC2841333333B39F0158410000000000E05340', 'BATIMENT0000000314349015', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 72.6, 79.5, 80.3, 72.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666669AA928419A9999B9B70258410000000000405040CDCCCCCCA6A92841CDCCCCCCB7025841000000000040504033333333A7A928419A9999B9B602584100000000004050409A9999999AA92841666666A6B60258410000000000405040666666669AA928419A9999B9B70258410000000000405040', 'BATIMENT0000000314341035', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 61.3, 65.0, 67.9, 61.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C00000066666666F7AA284166666626E2015841CDCCCCCCCC8C534066666666D1AA2841000000A0E1015841CDCCCCCCCC8C534000000000D1AA2841333333F3E1015841CDCCCCCCCC8C534000000000D0AA2841CDCCCC4CE3015841CDCCCCCCCC8C5340CDCCCCCCD9AA284166666666E3015841CDCCCCCCCC8C534000000000D8AA284166666626E6015841CDCCCCCCCC8C534000000000D6AA284133333313E9015841CDCCCCCCCC8C534066666666DCAA284133333333E9015841CDCCCCCCCC8C534000000000DCAA2841000000A0E9015841CDCCCCCCCC8C53409A999999F1AA2841CDCCCCECE9015841CDCCCCCCCC8C534033333333F4AA28419A999999E6015841CDCCCCCCCC8C534066666666F7AA284166666626E2015841CDCCCCCCCC8C5340', 'BATIMENT0000000314348733', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.1, 70.2, 78.3, 79.7, 71.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999973AC284133333393D20158419A999999997952406666666674AC284100000000D20158419A999999997952400000000066AC2841000000A0D10158419A999999997952400000000065AC284166666686D20158419A999999997952403333333373AC2841000000E0D20158419A999999997952409A99999973AC284133333393D20158419A99999999795240', 'BATIMENT0000000314348824', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 70.6, 73.9, 74.2, 70.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCF0AE284100000080D9015841CDCCCCCCCC4C544033333333EEAE284133333393D6015841CDCCCCCCCC4C544000000000E3AE2841666666C6D6015841CDCCCCCCCC4C5440CDCCCCCCE3AE2841CDCCCCCCD7015841CDCCCCCCCC4C5440CDCCCCCCE4AE284166666606D9015841CDCCCCCCCC4C544066666666E5AE2841333333B3D9015841CDCCCCCCCC4C5440CDCCCCCCF0AE284100000080D9015841CDCCCCCCCC4C5440', 'BATIMENT0000000314348879', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 75.4, 81.3, 81.9, 75.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC03AC2841333333F39A0158413333333333F353400000000002AC2841333333339C0158413333333333F353409A99999917AC2841333333939B0158413333333333F353409A99999915AC2841CDCCCC6C9A0158413333333333F35340CDCCCCCC03AC2841333333F39A0158413333333333F35340', 'BATIMENT0000000314348997', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.1, 72.8, 79.8, 80.7, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000096AC2841333333D3A20158410000000000E05340000000009BAC2841CDCCCCECA50158410000000000E0534033333333A0AC284166666626A90158410000000000E0534033333333A9AC284100000080A80158410000000000E053409A9999999FAC2841CDCCCCACA20158410000000000E053403333333398AC2841CDCCCCCCA20158410000000000E053400000000096AC2841333333D3A20158410000000000E05340', 'BATIMENT0000000314349072', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 72.0, 79.5, 80.9, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000EDAA28419A9999B9B9015841CDCCCCCCCC4C534000000000ECAA2841CDCCCC0CBB015841CDCCCCCCCC4C5340CDCCCCCCEEAA28419A999919BB015841CDCCCCCCCC4C534033333333EFAA2841CDCCCC8CBA015841CDCCCCCCCC4C53409A999999F5AA2841666666A6BA015841CDCCCCCCCC4C534033333333F6AA2841000000E0B9015841CDCCCCCCCC4C534000000000EDAA28419A9999B9B9015841CDCCCCCCCC4C5340', 'BATIMENT0000000314349290', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.3, 72.0, 77.3, 79.0, 72.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999C4AF2841CDCCCCAC87015841CDCCCCCCCCCC55409A999999C4AF2841CDCCCC0C87015841CDCCCCCCCCCC554000000000BBAF2841CDCCCC2C87015841CDCCCCCCCCCC554033333333BBAF2841000000E087015841CDCCCCCCCCCC55409A999999C4AF2841CDCCCCAC87015841CDCCCCCCCCCC5540', 'BATIMENT0000000314349362', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 82.3, 87.3, 87.6, 83.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333358AA28419A9999D9CB015841CDCCCCCCCC0C5340CDCCCCCC59AA28419A999919C9015841CDCCCCCCCC0C5340CDCCCCCC52AA284166666606C9015841CDCCCCCCCC0C53409A99999950AA2841000000C0CB015841CDCCCCCCCC0C53403333333358AA28419A9999D9CB015841CDCCCCCCCC0C5340', 'BATIMENT0000000314349381', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.9, 71.4, 76.3, 77.2, 71.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCCBAB284133333353CE015841CDCCCCCCCC2C52409A999999CCAB284133333393CD015841CDCCCCCCCC2C524066666666C4AB284133333373CD015841CDCCCCCCCC2C524000000000C4AB28419A999939CE015841CDCCCCCCCC2C5240CDCCCCCCCBAB284133333353CE015841CDCCCCCCCC2C5240', 'BATIMENT0000000314349699', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 70.2, 72.8, 74.7, 70.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000060AE2841666666A6BE01584166666666662653400000000061AE2841666666E6BF01584166666666662653406666666664AE2841000000E0BF01584166666666662653400000000064AE284100000060BF01584166666666662653406666666663AE2841000000A0BE01584166666666662653400000000060AE2841666666A6BE0158416666666666265340', 'BATIMENT0000000314349854', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 73.6, 76.6, 76.7, 73.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999972AF284100000000CA0158410000000000A05340666666666FAF284100000000CA0158410000000000A05340666666666FAF28419A9999D9CA0158410000000000A05340CDCCCCCC73AF2841333333D3CA0158410000000000A053409A99999972AF284100000000CA0158410000000000A05340', 'BATIMENT0000000314349863', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.7, 76.9, 78.6, 79.8, 77.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC3CAD284166666686EB01584100000000006052403333333341AD2841CDCCCCACEB01584100000000006052403333333343AD2841666666C6EA0158410000000000605240000000003FAD2841000000A0EA0158410000000000605240CDCCCCCC3CAD284166666686EB0158410000000000605240', 'BATIMENT0000000314349880', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.5, 72.0, 73.5, 74.1, 72.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333354AA2841CDCCCC4CAE02584166666666662650400000000053AA284133333353AF02584166666666662650409A99999956AA284166666666AF0258416666666666265040CDCCCCCC57AA28419A999959AE02584166666666662650403333333354AA2841CDCCCC4CAE0258416666666666265040', 'BATIMENT0000000314340990', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.4, 63.3, 64.7, 70.2, 63.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000049AC2841333333931F0258416666666666665240666666663EAC2841000000201F0258416666666666665240CDCCCCCC3AAC2841CDCCCC4C2002584166666666666652406666666645AC28419A9999B92002584166666666666652400000000049AC2841333333931F0258416666666666665240', 'BATIMENT0000000314349561', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 70.8, 73.6, 74.0, 71.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCBFAD2841CDCCCC8C20025841666666666626554000000000BDAD284133333313200258416666666666265540CDCCCCCCAEAD28413333335321025841666666666626554066666666B1AD2841CDCCCCCC210258416666666666265540CDCCCCCCBFAD2841CDCCCC8C200258416666666666265540', 'BATIMENT0000000314349619', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.4, 80.3, 84.7, 85.0, 81.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999BFB12841666666A6300258410000000000E055409A999999BEB12841CDCCCCEC2F0258410000000000E0554033333333A8B1284166666686300258410000000000E0554000000000AAB1284166666646310258410000000000E055409A999999B2B1284166666606310258410000000000E055409A999999BFB12841666666A6300258410000000000E05540', 'BATIMENT0000000314350030', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 84.3, 87.6, 88.1, 84.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC85AB2841CDCCCCCC380458410000000000404E40CDCCCCCC86AB2841CDCCCC0C3B0458410000000000404E4000000000A2AB28419A9999D93A0458410000000000404E409A9999999FAB28419A999999380458410000000000404E40CDCCCCCC85AB2841CDCCCCCC380458410000000000404E40', 'BATIMENT0000000314340963', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:48.171+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.6, 51.9, 60.5, 66.0, 52.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000007BA9284133333333420358410000000000404F40333333337FA928419A9999D9400358410000000000404F40000000007CA928419A999999400358410000000000404F406666666677A9284166666606420358410000000000404F40000000007BA9284133333333420358410000000000404F40', 'BATIMENT0000000314341037', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.9, 55.7, 62.6, 65.8, 56.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCF8AB2841000000E077015841CDCCCCCCCC0C534066666666F8AB28419A99995976015841CDCCCCCCCC0C534066666666F0AB28413333335376015841CDCCCCCCCC0C534000000000F1AB2841000000E077015841CDCCCCCCCC0C5340CDCCCCCCF8AB2841000000E077015841CDCCCCCCCC0C5340', 'BATIMENT0000000314347653', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.7, 74.6, 76.3, 77.3, 74.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999995FAB28419A999919900158419A99999999395340CDCCCCCC58AB2841333333F38F0158419A999999993953403333333358AB284100000080900158419A99999999395340000000005FAB2841666666A6900158419A999999993953409A9999995FAB28419A999919900158419A99999999395340', 'BATIMENT0000000314349625', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 73.4, 77.0, 78.7, 73.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC3EB22841CDCCCCCC5D0158419A99999999595A400000000044B22841000000805D0158419A99999999595A409A9999993FB22841CDCCCC4C5C0158419A99999999595A40000000004BB22841CDCCCCAC5B0158419A99999999595A403333333349B22841666666065B0158419A99999999595A400000000038B22841666666E65B0158419A99999999595A40CDCCCCCC3EB22841CDCCCCCC5D0158419A99999999595A40', 'BATIMENT0000000314341129', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.6, 99.9, 105.4, 107.0, 101.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000006666666684B12841333333D3430158410000000000A05C403333333392B128419A999919430158410000000000A05C40333333338BB12841333333F3400158410000000000A05C406666666683B128419A999959410158410000000000A05C406666666680B12841CDCCCC6C400158410000000000A05C40333333337AB12841000000C0400158410000000000A05C403333333374B12841CDCCCC0C410158410000000000A05C409A99999977B12841CDCCCC0C420158410000000000A05C40666666667DB12841000000C0410158410000000000A05C406666666684B12841333333D3430158410000000000A05C40', 'BATIMENT0000000314341244', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.2, 108.3, 114.5, 117.2, 110.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333333EB12841000000A0E0005841CDCCCCCCCC6C5C40CDCCCCCC3FB1284100000040E0005841CDCCCCCCCC6C5C409A99999937B12841CDCCCCACDF005841CDCCCCCCCC6C5C40CDCCCCCC35B12841CDCCCC0CE0005841CDCCCCCCCC6C5C40333333333EB12841000000A0E0005841CDCCCCCCCC6C5C40', 'BATIMENT0000000314341246', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.6, 107.2, 113.8, 114.0, 108.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666C7B22841333333F30E015841CDCCCCCCCC6C5D4033333333C8B228419A9999F90E015841CDCCCCCCCC6C5D4033333333CEB22841666666260F015841CDCCCCCCCC6C5D4000000000D0B22841333333530E015841CDCCCCCCCC6C5D4000000000C9B22841000000200E015841CDCCCCCCCC6C5D4066666666C7B22841333333F30E015841CDCCCCCCCC6C5D40', 'BATIMENT0000000314341254', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 113.9, 117.8, 118.0, 115.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666DCAF28419A999919230158416666666666E6584033333333D2AF2841666666E6220158416666666666E6584033333333CEAF28419A9999B9250158416666666666E6584000000000DAAF2841CDCCCCEC250158416666666666E6584066666666DCAF28419A999919230158416666666666E65840', 'BATIMENT0000000314347093', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.8, 92.8, 99.6, 100.4, 94.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCBBAF28416666668621015841000000000040584000000000BDAF2841000000E020015841000000000040584000000000B8AF2841666666C620015841000000000040584000000000B7AF2841CDCCCC6C210158410000000000405840CDCCCCCCBBAF284166666686210158410000000000405840', 'BATIMENT0000000314347096', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.1, 90.9, 97.0, 98.5, 91.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC11B02841333333D319015841CDCCCCCCCC8C5A40CDCCCCCC13B02841000000601B015841CDCCCCCCCC8C5A403333333321B02841333333131B015841CDCCCCCCCC8C5A409A9999991EB02841CDCCCC8C19015841CDCCCCCCCC8C5A40CDCCCCCC11B02841333333D319015841CDCCCCCCCC8C5A40', 'BATIMENT0000000314347097', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.9, 97.4, 106.3, 107.0, 99.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333359AF2841666666666A0158419A99999999B955403333333369AF28419A9999996B0158419A99999999B955409A9999996EAF2841333333B36A0158419A99999999B95540333333335FAF28419A999979690158419A99999999B955403333333359AF2841666666666A0158419A99999999B95540', 'BATIMENT0000000314347183', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.9, 85.1, 86.9, 87.6, 85.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000002CAE284133333333470158419A99999999395640CDCCCCCC38AE284100000000480158419A99999999395640666666663FAE2841000000E0450158419A99999999395640CDCCCCCC38AE284133333393450158419A99999999395640000000002CAE284133333333470158419A99999999395640', 'BATIMENT0000000314347200', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.7, 82.3, 88.9, 89.4, 82.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333E6AE28413333335370015841CDCCCCCCCC4C554066666666E2AE2841CDCCCCEC70015841CDCCCCCCCC4C55409A999999E7AE28410000006071015841CDCCCCCCCC4C554000000000EBAE2841666666C670015841CDCCCCCCCC4C554033333333E6AE28413333335370015841CDCCCCCCCC4C5540', 'BATIMENT0000000314347232', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 82.1, 85.2, 86.0, 82.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999B6AE2841000000C05E015841CDCCCCCCCC0C554066666666AAAE28419A9999B95D015841CDCCCCCCCC0C5540CDCCCCCCA7AE2841000000805D015841CDCCCCCCCC0C554066666666A3AE28419A9999395E015841CDCCCCCCCC0C55409A999999B2AE2841CDCCCC8C5F015841CDCCCCCCCC0C55409A999999B6AE2841000000C05E015841CDCCCCCCCC0C5540', 'BATIMENT0000000314347328', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 80.6, 84.3, 87.0, 80.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333351AD2841333333933D0158410000000000C05540333333334EAD2841000000803D0158410000000000C05540000000004BAD2841666666E63F0158410000000000C05540000000004EAD28419A9999F93F0158410000000000C055403333333351AD2841333333933D0158410000000000C05540', 'BATIMENT0000000314347440', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.5, 82.5, 87.0, 88.5, 83.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC5DAD2841CDCCCC4C370158410000000000005640CDCCCCCC5AAD28419A9999393701584100000000000056400000000059AD2841000000E03801584100000000000056409A9999995CAD2841CDCCCCEC380158410000000000005640CDCCCCCC5DAD2841CDCCCC4C370158410000000000005640', 'BATIMENT0000000314347446', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 84.2, 88.0, 89.4, 84.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A000000CDCCCCCC4AAE2841000000E03E0158413333333333D355403333333358AE2841CDCCCCAC3D0158413333333333D355400000000068AE2841CDCCCC0C3D0158413333333333D355400000000078AE28419A9999793C0158413333333333D35540CDCCCCCC68AE2841CDCCCCCC360158413333333333D35540333333335CAE284100000060370158413333333333D35540CDCCCCCC63AE2841000000603B0158413333333333D355403333333357AE2841666666E63B0158413333333333D355400000000049AE2841666666263E0158413333333333D35540CDCCCCCC4AAE2841000000E03E0158413333333333D35540', 'BATIMENT0000000314347454', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.2, 82.2, 87.3, 89.4, 83.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333330B02841000000E0FB005841CDCCCCCCCCCC5A409A99999932B028419A9999F9FA005841CDCCCCCCCCCC5A40CDCCCCCC2CB02841333333B3FA005841CDCCCCCCCCCC5A40CDCCCCCC2AB02841CDCCCC6CFB005841CDCCCCCCCCCC5A40666666662AB028419A999999FB005841CDCCCCCCCCCC5A403333333330B02841000000E0FB005841CDCCCCCCCCCC5A40', 'BATIMENT0000000314347504', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.4, 100.9, 107.3, 108.0, 101.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666B5AF28419A9999393C01584166666666664658409A999999BAAF2841666666663C015841666666666646584066666666BCAF2841000000A03B015841666666666646584000000000B7AF2841333333733B015841666666666646584066666666B5AF28419A9999393C0158416666666666465840', 'BATIMENT0000000314347540', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.3, 88.8, 97.1, 97.6, 89.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000066666666B0AF2841CDCCCC6C3E01584100000000006058409A999999C5AF2841666666263F01584100000000006058409A999999CBAF2841333333733C01584100000000006058409A999999C2AF2841666666263C015841000000000060584033333333C3AF28419A9999D93B015841000000000060584066666666BCAF2841000000A03B01584100000000006058409A999999BAAF2841666666663C015841000000000060584066666666B5AF28419A9999393C015841000000000060584066666666B0AF2841CDCCCC6C3E0158410000000000605840', 'BATIMENT0000000314347541', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 9.0, 88.6, 97.6, 98.3, 90.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000DEAC284100000040430158410000000000E0544033333333DEAC284133333393420158410000000000E054409A999999CFAC28419A999999420158410000000000E0544066666666CFAC284100000040430158410000000000E0544000000000DEAC284100000040430158410000000000E05440', 'BATIMENT0000000314347603', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 80.1, 83.5, 84.0, 80.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000CEAE2841000000205D0158419A99999999F954409A999999CAAE2841333333D35C0158419A99999999F95440CDCCCCCCC6AE2841333333535D0158419A99999999F9544033333333CAAE2841666666A65D0158419A99999999F9544000000000CEAE2841000000205D0158419A99999999F95440', 'BATIMENT0000000314347666', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 81.1, 84.0, 84.5, 81.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000A5AD284100000080430158413333333333F3554000000000A7AD284166666686420158413333333333F355409A9999999CAD28419A999939420158413333333333F355409A9999999AAD284133333333430158413333333333F3554000000000A5AD284100000080430158413333333333F35540', 'BATIMENT0000000314347668', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.0, 84.8, 87.8, 88.5, 86.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC63AD284100000040620158416666666666A65440666666665FAD284166666626620158416666666666A65440666666665EAD2841333333B3620158416666666666A654403333333363AD2841666666C6620158416666666666A65440CDCCCCCC63AD284100000040620158416666666666A65440', 'BATIMENT0000000314347669', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 76.8, 82.7, 83.1, 77.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC4AAF28419A9999D96C0158413333333333B35540CDCCCCCC46AF28419A9999796D0158413333333333B355409A9999994EAF2841333333336E0158413333333333B355406666666652AF28419A9999996D0158413333333333B35540CDCCCCCC4AAF28419A9999D96C0158413333333333B35540', 'BATIMENT0000000314347674', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.5, 84.4, 86.9, 87.0, 84.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000093AF284133333373D40158419A99999999F953406666666693AF284133333353D40158419A99999999F95340333333338EAF284100000060D40158419A99999999F953403333333391AF284100000080D70158419A99999999F953409A99999996AF284133333373D70158419A99999999F953400000000093AF284133333373D40158419A99999999F95340', 'BATIMENT0000000314349191', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 77.7, 80.0, 81.3, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A9999994AAD28419A999939F30158419A99999999F952409A99999951AD2841666666A6F30158419A99999999F952403333333350AD284166666606F40158419A99999999F95240CDCCCCCC5CAD2841CDCCCCCCF40158419A99999999F95240CDCCCCCC5EAD284166666646F40158419A99999999F952406666666660AD2841666666E6F30158419A99999999F95240666666664DAD2841000000A0F20158419A99999999F952409A9999994AAD28419A999939F30158419A99999999F95240', 'BATIMENT0000000314349727', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 72.6, 75.9, 76.3, 72.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999999DA92841333333B3D8015841CDCCCCCCCCAC52409A9999999DA928419A999999D8015841CDCCCCCCCCAC5240666666669EA92841666666C6D7015841CDCCCCCCCCAC5240CDCCCCCC94A92841CDCCCCACD7015841CDCCCCCCCCAC52403333333394A92841CDCCCC8CD8015841CDCCCCCCCCAC52409A9999999DA92841333333B3D8015841CDCCCCCCCCAC5240', 'BATIMENT0000000314349839', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.6, 72.2, 74.8, 76.2, 72.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666DAAB284133333373E90158416666666666E651409A999999D5AB284100000060E90158416666666666E651409A999999D4AB284100000000EA0158416666666666E6514033333333D9AB284133333313EA0158416666666666E6514066666666DAAB284133333373E90158416666666666E65140', 'BATIMENT0000000314349883', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.5, 69.2, 71.7, 72.5, 69.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000F0B028416666664613025841000000000000574033333333F6B0284133333313130258410000000000005740CDCCCCCCF2B02841333333731102584100000000000057409A999999ECB02841666666A611025841000000000000574000000000F0B0284166666646130258410000000000005740', 'BATIMENT0000000314350048', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 88.7, 92.0, 93.8, 89.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000DBAC28419A9999D9680158419A99999999D9534000000000D9AC2841000000406A0158419A99999999D9534033333333E4AC2841333333736A0158419A99999999D9534033333333E6AC28419A999919690158419A99999999D9534000000000DBAC28419A9999D9680158419A99999999D95340', 'BATIMENT0000000314347650', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 75.6, 79.4, 80.8, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666668AC28410000006047015841CDCCCCCCCC4C54406666666670AC28410000006047015841CDCCCCCCCC4C54409A99999970AC28410000008046015841CDCCCCCCCC4C54409A99999968AC28410000008046015841CDCCCCCCCC4C54406666666668AC28410000006047015841CDCCCCCCCC4C5440', 'BATIMENT0000000314347648', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.4, 78.9, 81.2, 82.2, 79.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666617AC28419A9999398801584166666666662653409A99999920AC2841CDCCCC2C8801584166666666662653409A99999920AC2841666666C68601584166666666662653403333333317AC2841CDCCCCCC8601584166666666662653406666666617AC28419A999939880158416666666666265340', 'BATIMENT0000000314348383', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 73.4, 76.7, 76.9, 73.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCDBAC2841666666C67F0158410000000000C05340CDCCCCCCBEAC2841333333537F0158410000000000C053409A999999BCAC2841333333B37F0158410000000000C0534066666666BDAC28419A9999F9800158410000000000C05340CDCCCCCCC9AC28419A999919810158410000000000C0534033333333CFAC284133333373800158410000000000C053409A999999DCAC284133333393800158410000000000C05340CDCCCCCCDBAC2841666666C67F0158410000000000C05340', 'BATIMENT0000000314347147', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 74.8, 79.0, 80.7, 74.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000066666666A9AE28416666664658015841000000000020554033333333AAAE2841CDCCCC0C580158410000000000205540000000009AAE2841333333F35601584100000000002055406666666698AE28419A99995957015841000000000020554000000000A0AE2841000000E057015841000000000020554000000000A1AE2841CDCCCCAC57015841000000000020554066666666A9AE284166666646580158410000000000205540', 'BATIMENT0000000314347395', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.2, 81.3, 84.5, 85.2, 81.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333E3AD2841666666A6970158419A99999999F95340CDCCCCCCEEAD28419A9999B9970158419A99999999F95340CDCCCCCCF9AD2841333333B3970158419A99999999F9534066666666FAAD284166666666960158419A99999999F9534033333333F0AD2841666666C6960158419A99999999F953409A999999E2AD2841000000E0960158419A99999999F9534033333333E3AD2841666666A6970158419A99999999F95340', 'BATIMENT0000000314348426', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.2, 74.8, 80.0, 81.2, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666E3AD28416666666627015841CDCCCCCCCCAC5640CDCCCCCCE8AD28419A99997927015841CDCCCCCCCCAC564000000000ECAD28419A9999F924015841CDCCCCCCCCAC5640CDCCCCCCE6AD2841CDCCCCCC24015841CDCCCCCCCCAC564000000000E4AD2841666666E626015841CDCCCCCCCCAC564066666666E3AD28416666666627015841CDCCCCCCCCAC5640', 'BATIMENT0000000314347463', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.7, 89.1, 90.8, 91.1, 89.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999E7AE284133333353350158410000000000005640CDCCCCCCF4AE28410000006035015841000000000000564000000000F5AE2841333333B33401584100000000000056409A999999E7AE2841CDCCCCAC3401584100000000000056409A999999E7AE284133333353350158410000000000005640', 'BATIMENT0000000314347465', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 84.7, 88.0, 89.2, 85.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666664EAC2841666666C678015841CDCCCCCCCCEC5240666666664AAC2841666666C678015841CDCCCCCCCCEC5240666666664AAC2841000000A079015841CDCCCCCCCCEC5240CDCCCCCC4EAC2841000000A079015841CDCCCCCCCCEC5240666666664EAC2841666666C678015841CDCCCCCCCCEC5240', 'BATIMENT0000000314347645', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.7, 74.1, 75.8, 77.5, 74.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCB5AC284166666666740158410000000000C0534066666666B2AC28419A999959740158410000000000C0534033333333B2AC2841666666A6740158410000000000C0534000000000AFAC2841000000A0740158410000000000C0534000000000AEAC28419A9999B9750158410000000000C053409A999999B4AC2841CDCCCCCC750158410000000000C05340CDCCCCCCB5AC284166666666740158410000000000C05340', 'BATIMENT0000000314347651', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 74.8, 79.0, 79.5, 75.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333381AD28413333331331015841CDCCCCCCCC2C56403333333383AD2841000000C02F015841CDCCCCCCCC2C56403333333379AD28419A9999992F015841CDCCCCCCCC2C56400000000077AD2841CDCCCCEC30015841CDCCCCCCCC2C56403333333381AD28413333331331015841CDCCCCCCCC2C5640', 'BATIMENT0000000314347659', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 86.1, 88.8, 89.7, 86.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000E2AD28419A999939510158410000000000E05440CDCCCCCCECAD2841666666C6510158410000000000E05440CDCCCCCCF2AD28419A999959500158410000000000E0544000000000E8AD2841333333D34F0158410000000000E0544000000000E2AD28419A999939510158410000000000E05440', 'BATIMENT0000000314347664', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.9, 79.7, 83.6, 84.7, 81.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999915AC2841000000207D01584166666666664653400000000016AC28419A9999197F01584166666666664653409A9999991FAC2841333333137F0158416666666666465340000000001FAC28419A9999197D01584166666666664653409A99999915AC2841000000207D0158416666666666465340', 'BATIMENT0000000314347681', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 73.9, 77.2, 77.7, 74.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666AFAD28419A9999B9820158413333333333B3534066666666BDAD2841CDCCCC2C830158413333333333B3534033333333BFAD28419A999999820158413333333333B3534033333333B3AD2841CDCCCC0C820158413333333333B3534000000000B2AD284100000040820158413333333333B3534066666666AFAD28419A9999B9820158413333333333B35340', 'BATIMENT0000000314347686', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 74.9, 78.8, 82.5, 75.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCABAD284100000060830158413333333333F3534033333333BBAD2841333333D3830158413333333333F3534066666666BDAD2841CDCCCC2C830158413333333333F3534066666666AFAD28419A9999B9820158413333333333F35340CDCCCCCCABAD284100000060830158413333333333F35340', 'BATIMENT0000000314348307', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.9, 74.9, 79.8, 82.0, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000D8AC2841000000808501584100000000000054409A999999D4AC2841666666E684015841000000000000544066666666CBAC2841CDCCCCAC85015841000000000000544033333333CBAC28413333335386015841000000000000544033333333CEAC28413333335386015841000000000000544000000000D3AC2841666666E685015841000000000000544000000000D8AC284100000080850158410000000000005440', 'BATIMENT0000000314348340', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.5, 74.5, 80.0, 80.9, 74.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666604AE284133333373890158410000000000005540CDCCCCCC0AAE28419A9999198801584100000000000055400000000002AE28413333337387015841000000000000554066666666FBAD28419A9999D98801584100000000000055400000000000AE2841666666268901584100000000000055406666666604AE284133333373890158410000000000005540', 'BATIMENT0000000314348363', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.8, 75.3, 84.1, 84.8, 75.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000006666666610AE2841333333F38C0158419A99999999F95440666666661AAE2841000000008D0158419A99999999F95440666666661BAE2841CDCCCC0C8B0158419A99999999F95440CDCCCCCC1BAE2841666666668A0158419A99999999F954400000000012AE2841333333538A0158419A99999999F954406666666611AE2841CDCCCC0C8B0158419A99999999F954406666666610AE2841333333F38C0158419A99999999F95440', 'BATIMENT0000000314348371', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.6, 75.4, 83.9, 84.9, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000150000006666666619AE2841000000C0940158419A999999995954406666666617AE2841333333B3940158419A99999999595440666666660EAE284166666686940158419A9999999959544000000000FCAD284100000020940158419A99999999595440CDCCCCCCEBAD2841666666C6930158419A9999999959544000000000ECAD284133333373950158419A99999999595440CDCCCCCCE4AD2841CDCCCC6C950158419A999999995954409A999999E2AD28419A999999950158419A999999995954409A999999D9AD284133333393950158419A999999995954409A999999D8AD284133333313950158419A9999999959544066666666BEAD28419A9999B9940158419A9999999959544000000000BFAD2841CDCCCC0C960158419A9999999959544066666666CDAD284100000000960158419A9999999959544033333333CFAD284100000060970158419A9999999959544033333333E3AD2841666666A6970158419A999999995954409A999999E2AD2841000000E0960158419A9999999959544033333333F0AD2841666666C6960158419A9999999959544066666666FAAD284166666666960158419A99999999595440CDCCCCCC0BAE284100000080960158419A999999995954400000000016AE2841666666A6960158419A999999995954406666666619AE2841000000C0940158419A99999999595440', 'BATIMENT0000000314348423', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 74.1, 81.5, 83.0, 77.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999967AC2841000000408A015841CDCCCCCCCC0C5440666666666BAC2841CDCCCC6C8B015841CDCCCCCCCC0C5440CDCCCCCC75AC2841666666068B015841CDCCCCCCCC0C54400000000070AC28419A9999F989015841CDCCCCCCCC0C54409A99999967AC2841000000408A015841CDCCCCCCCC0C5440', 'BATIMENT0000000314349120', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.5, 73.8, 80.3, 81.0, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCF9AE28419A99997993015841666666666646544033333333FEAE284166666686930158416666666666465440CDCCCCCCFEAE2841666666E691015841666666666646544066666666FAAE2841000000E091015841666666666646544000000000FAAE2841666666C6920158416666666666465440CDCCCCCCF9AE28419A999979930158416666666666465440', 'BATIMENT0000000314349448', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.6, 79.6, 81.2, 81.4, 79.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000E0000009A99999902B82841000000C02C045841CDCCCCCCCCCC54403333333304B82841333333532D045841CDCCCCCCCCCC5440666666660EB82841333333F32F045841CDCCCCCCCCCC54406666666658B82841CDCCCCEC2B045841CDCCCCCCCCCC5440333333334DB82841CDCCCC2C29045841CDCCCCCCCCCC54403333333317B828419A9999D92B045841CDCCCCCCCCCC54406666666611B828419A9999792A045841CDCCCCCCCCCC5440000000000DB82841666666A62A045841CDCCCCCCCCCC54409A9999990AB82841333333D329045841CDCCCCCCCCCC54409A99999904B82841000000202A045841CDCCCCCCCCCC5440CDCCCCCC07B828419A9999F92A045841CDCCCCCCCCCC54406666666602B82841CDCCCC4C2B045841CDCCCCCCCCCC54400000000007B82841CDCCCC8C2C045841CDCCCCCCCCCC54409A99999902B82841000000C02C045841CDCCCCCCCCCC5440', 'BATIMENT0000000314327578', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:00:31.396+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.0, 75.2, 83.2, 86.4, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000C3AB2841000000C03E0458419A99999999D94C4000000000C3AB2841333333933F0458419A99999999D94C4033333333DCAB2841CDCCCC6C3F0458419A99999999D94C4066666666DCAB2841000000803E0458419A99999999D94C4000000000C3AB2841000000C03E0458419A99999999D94C40', 'BATIMENT0000000314340972', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:48.171+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.2, 52.6, 57.8, 60.8, 53.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333316B02841333333532F0258413333333333935540CDCCCCCC13B02841666666462F02584133333333339355400000000010B02841000000C03102584133333333339355400000000013B02841333333D33102584133333333339355403333333316B02841333333532F0258413333333333935540', 'BATIMENT0000000314348544', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 82.8, 86.3, 86.4, 83.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000065AD28419A9999592C025841CDCCCCCCCC2C55403333333361AD28419A9999192C025841CDCCCCCCCC2C5540666666665BAD2841000000802D025841CDCCCCCCCC2C5540000000005FAD2841000000C02D025841CDCCCCCCCC2C55400000000065AD28419A9999592C025841CDCCCCCCCC2C5540', 'BATIMENT0000000314348664', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 79.8, 84.8, 85.0, 80.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000075AD28419A9999192E0258419A999999991955406666666677AD2841CDCCCC8C2D0258419A999999991955406666666672AD28419A9999392D0258419A999999991955403333333370AD2841666666C62D0258419A999999991955400000000075AD28419A9999192E0258419A99999999195540', 'BATIMENT0000000314348666', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 80.6, 84.4, 84.5, 81.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333369AB28419A999939080258410000000000E05140000000005FAB2841333333B3070258410000000000E05140CDCCCCCC5CAB284133333373080258410000000000E05140CDCCCCCC66AB2841666666E6080258410000000000E051403333333369AB28419A999939080258410000000000E05140', 'BATIMENT0000000314348834', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 68.7, 71.6, 72.0, 68.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666611AF28419A9999F90A0258419A999999995955403333333313AF2841333333F30A0258419A999999995955406666666610AF284100000080080258419A999999995955409A99999909AF2841000000A0080258419A99999999595540333333330CAF2841333333130B0258419A999999995955406666666611AF28419A9999F90A0258419A99999999595540', 'BATIMENT0000000314348892', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.8, 79.7, 85.4, 86.1, 80.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333330FAC2841000000C0370258419A99999999D95240CDCCCCCC13AC28419A9999F9370258419A99999999D952403333333315AC284166666686370258419A99999999D952406666666610AC284133333353370258419A99999999D95240333333330FAC2841000000C0370258419A99999999D95240', 'BATIMENT0000000314349590', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.2, 71.3, 75.4, 76.5, 71.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333315AC284166666686370258410000000000C05340CDCCCCCC13AC28419A9999F9370258410000000000C053400000000028AC2841333333D3380258410000000000C053403333333329AC28419A999959380258410000000000C053403333333315AC284166666686370258410000000000C05340', 'BATIMENT0000000314349592', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.7, 71.4, 79.1, 79.7, 72.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999993FAC2841000000601402584166666666660652409A99999938AC2841666666E61302584166666666660652406666666635AC2841CDCCCCAC140258416666666666065240000000003DAC2841000000201502584166666666660652409A9999993FAC284100000060140258416666666666065240', 'BATIMENT0000000314349879', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 70.2, 72.2, 72.5, 70.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666C1A9284100000040B10258419A999999995950409A999999BFA9284133333353B20258419A9999999959504000000000C5A9284133333393B20258419A9999999959504000000000C7A9284166666686B10258419A9999999959504066666666C1A9284100000040B10258419A99999999595040', 'BATIMENT0000000314341032', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 61.4, 65.4, 66.8, 61.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCF3A928419A9999D9B30258419A99999999594F4033333333F2A9284133333353B50258419A99999999594F409A999999F5A928419A999959B50258419A99999999594F409A999999F6A92841666666E6B30258419A99999999594F40CDCCCCCCF3A928419A9999D9B30258419A99999999594F40', 'BATIMENT0000000314341031', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.5, 61.3, 62.8, 63.4, 61.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333365AA2841000000400C0358410000000000E050400000000067AA2841333333B30B0358410000000000E05040333333335AAA2841CDCCCC0C0B0358410000000000E050403333333358AA28419A9999990B0358410000000000E050403333333365AA2841000000400C0358410000000000E05040', 'BATIMENT0000000314340980', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 61.7, 67.6, 68.2, 63.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333CEA928419A999999B70258419A99999999195040CDCCCCCCC9A928419A999979B70258419A999999991950409A999999C8A9284166666606B80258419A9999999919504033333333CDA9284166666626B80258419A9999999919504033333333CEA928419A999999B70258419A99999999195040', 'BATIMENT0000000314340982', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.5, 61.0, 64.5, 64.6, 61.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000000000001BAB2841000000A08B02584133333333339351406666666621AB2841000000608A0258413333333333935140CDCCCCCC26AB2841CDCCCCCC8A0258413333333333935140CDCCCCCC2CAB28419A9999998902584133333333339351409A99999922AB28419A9999D98802584133333333339351403333333316AB2841000000408B0258413333333333935140000000001BAB2841000000A08B0258413333333333935140', 'BATIMENT0000000314341005', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 67.0, 70.3, 72.6, 67.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999F6AC284100000020750258419A99999999B9534066666666F8AC2841000000A0740258419A99999999B9534066666666F1AC28419A999939740258419A99999999B9534033333333EFAC28419A9999B9740258419A99999999B953409A999999F6AC284100000020750258419A99999999B95340', 'BATIMENT0000000314348598', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.1, 75.8, 78.9, 79.2, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000BCAB2841333333933C025841CDCCCCCCCC4C534033333333BEAB2841CDCCCCEC39025841CDCCCCCCCC4C534033333333B2AB2841666666A639025841CDCCCCCCCC4C534000000000B0AB2841333333533C025841CDCCCCCCCC4C534000000000BCAB2841333333933C025841CDCCCCCCCC4C5340', 'BATIMENT0000000314348616', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 69.7, 77.2, 78.0, 70.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333334DAC2841333333733A025841CDCCCCCCCCAC53406666666647AC2841CDCCCC2C3A025841CDCCCCCCCCAC53409A99999946AC2841CDCCCC6C3A025841CDCCCCCCCCAC53406666666645AC2841000000C03A025841CDCCCCCCCCAC5340666666664BAC2841000000003B025841CDCCCCCCCCAC5340333333334DAC2841333333733A025841CDCCCCCCCCAC5340', 'BATIMENT0000000314349601', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.7, 73.1, 78.8, 80.1, 73.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999ADAC2841CDCCCCEC650258419A999999997953409A999999BBAC2841666666C6660258419A9999999979534066666666BEAC284166666606660258419A999999997953409A999999B0AC284166666626650258419A999999997953409A999999ADAC2841CDCCCCEC650258419A99999999795340', 'BATIMENT0000000314349900', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 75.7, 77.9, 78.1, 77.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000000000003DAD28419A9999794A0258410000000000C054403333333341AD2841000000E0480258410000000000C054409A99999934AD284100000060480258410000000000C054406666666630AD2841000000004A0258410000000000C05440CDCCCCCC31AD2841CDCCCC0C4A0258410000000000C05440000000003DAD28419A9999794A0258410000000000C05440', 'BATIMENT0000000314349901', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.4, 79.7, 83.1, 83.7, 80.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA4B0284166666626020158410000000000005B4066666666A7B02841CDCCCC4C010158410000000000005B40CDCCCCCC9EB02841000000E0000158410000000000005B40666666669CB028419A9999B9010158410000000000005B40CDCCCCCCA4B0284166666626020158410000000000005B40', 'BATIMENT0000000314341214', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 1.8, 106.3, 108.1, 108.3, 107.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC8AB02841666666265D01584133333333333358400000000083B02841000000605D01584133333333333358400000000087B028419A9999B95F0158413333333333335840666666668BB028419A9999995F0158413333333333335840666666668AB028419A9999D95E0158413333333333335840333333338DB02841666666C65E0158413333333333335840CDCCCCCC8AB02841666666265D0158413333333333335840', 'BATIMENT0000000314341111', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.0, 92.8, 96.8, 98.5, 94.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC1FAD2841000000207F0158410000000000E05440666666662BAD2841CDCCCCCC7E0158410000000000E054409A99999929AD2841CDCCCCAC7D0158410000000000E054409A9999991FAD2841333333537E0158410000000000E05440CDCCCCCC1FAD2841000000207F0158410000000000E05440', 'BATIMENT0000000314347155', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.5, 75.0, 83.5, 84.3, 75.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B0000006666666682AD2841000000C05E0158410000000000405440CDCCCCCC89AD28419A9999D95B0158410000000000405440CDCCCCCC82AD2841CDCCCC8C5B01584100000000004054409A99999981AD2841000000805B0158410000000000405440000000007AAD28419A9999795E01584100000000004054409A99999964AD28419A9999F95D01584100000000004054403333333364AD2841666666265E0158410000000000405440CDCCCCCC61AD2841333333535E01584100000000004054409A99999979AD2841666666465F0158410000000000405440CDCCCCCC80AD2841CDCCCC6C5F01584100000000004054406666666682AD2841000000C05E0158410000000000405440', 'BATIMENT0000000314347203', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.8, 77.3, 81.1, 83.0, 78.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333D5AE28419A9999D96F015841000000000080564033333333C5AE2841666666666E0158410000000000805640CDCCCCCCB7AE2841CDCCCCCC7001584100000000008056409A999999C7AE28419A99993972015841000000000080564033333333D5AE28419A9999D96F0158410000000000805640', 'BATIMENT0000000314347357', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 9.0, 81.0, 90.0, 91.2, 81.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000D00000066666666A2AC2841333333536F01584100000000004055409A999999B9AC2841333333F36F015841000000000040554000000000D0AC2841CDCCCC8C7001584100000000004055409A999999D4AC2841666666666D0158410000000000405540CDCCCCCCD4AC2841333333336D01584100000000004055409A999999D2AC2841000000206D015841000000000040554066666666D1AC2841CDCCCCAC6D015841000000000040554066666666ACAC2841000000A06C01584100000000004055409A999999A8AC2841CDCCCCEC6E0158410000000000405540CDCCCCCCA5AC28419A9999D96E015841000000000040554066666666A5AC28419A9999196F015841000000000040554000000000A3AC2841CDCCCC0C6F015841000000000040554066666666A2AC2841333333536F0158410000000000405540', 'BATIMENT0000000314347402', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 9.9, 75.2, 85.1, 86.5, 75.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333331AF2841333333F3590158419A99999999995540000000002EAF2841000000A0590158419A999999999955409A9999992AAF28419A9999195A0158419A99999999995540CDCCCCCC2DAF2841666666665A0158419A999999999955403333333331AF2841333333F3590158419A99999999995540', 'BATIMENT0000000314347670', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.7, 83.7, 86.4, 86.4, 84.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C0000009A999999B2B42841CDCCCC8C41035841333333333333514000000000D8B42841000000C040035841333333333333514033333333D8B42841666666863E035841333333333333514066666666D5B428419A9999D93B035841333333333333514066666666CFB42841CDCCCCEC3B0358413333333333335140CDCCCCCCCAB42841CDCCCC2C390358413333333333335140CDCCCCCCC1B428419A99997939035841333333333333514000000000C4B42841333333133C0358413333333333335140CDCCCCCCBDB42841333333533C035841333333333333514066666666BEB42841000000A03D0358413333333333335140CDCCCCCCADB42841666666263E03584133333333333351409A999999B2B42841CDCCCC8C410358413333333333335140', 'BATIMENT0000000314350212', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:10.193+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.6, 62.3, 68.9, 70.3, 63.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000003333333391B02841000000E0C10158416666666666A655406666666690B0284100000060C10158416666666666A65540CDCCCCCC88B0284133333373C10158416666666666A655406666666688B0284166666606C10158416666666666A65540CDCCCCCC7AB0284133333353C10158416666666666A65540000000007CB0284133333333C20158416666666666A655403333333391B02841000000E0C10158416666666666A65540', 'BATIMENT0000000314350054', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.2, 79.4, 86.6, 89.2, 79.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B00000066666666C8B02841CDCCCC4CAE0158419A9999999919564066666666D7B02841CDCCCC4CAE0158419A999999991956409A999999D7B02841CDCCCC6CAC0158419A999999991956409A999999DFB028419A999959AC0158419A999999991956409A999999DFB02841CDCCCC2CAA0158419A99999999195640CDCCCCCCD7B0284133333333AA0158419A99999999195640CDCCCCCCD7B02841CDCCCCECAA0158419A9999999919564066666666C6B02841CDCCCCECAA0158419A9999999919564033333333C6B0284166666646AC0158419A999999991956409A999999C8B02841CDCCCC4CAC0158419A9999999919564066666666C8B02841CDCCCC4CAE0158419A99999999195640', 'BATIMENT0000000314350120', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.5, 81.0, 88.5, 90.2, 81.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666614B12841000000E0C80158416666666666A655409A99999910B12841CDCCCCECC80158416666666666A65540CDCCCCCC10B1284133333353C90158416666666666A655406666666612B12841CDCCCC4CC90158416666666666A65540CDCCCCCC14B1284166666646C90158416666666666A655406666666614B12841000000E0C80158416666666666A65540', 'BATIMENT0000000314350184', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.9, 83.8, 86.7, 87.2, 84.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333333B12841666666C6D0015841CDCCCCCCCCCC5540CDCCCCCC2CB128419A9999F9D0015841CDCCCCCCCCCC5540666666662EB1284166666646D2015841CDCCCCCCCCCC55409A99999934B1284133333333D2015841CDCCCCCCCCCC55403333333333B12841666666C6D0015841CDCCCCCCCCCC5540', 'BATIMENT0000000314350186', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 85.1, 87.2, 88.0, 86.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333301AF2841666666A6ED0158416666666666A6534066666666F6AE28419A999979ED0158416666666666A65340CDCCCCCCE8AE284166666646ED0158416666666666A65340CDCCCCCCE6AE28419A9999F9ED0158416666666666A6534066666666FFAE284133333353EE0158416666666666A653403333333301AF2841666666A6ED0158416666666666A65340', 'BATIMENT0000000314348830', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 76.4, 78.7, 79.4, 76.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999C8AD284166666686A00158419A9999999919544066666666C5AD2841000000E09E0158419A999999991954409A999999B7AD2841666666269F0158419A9999999919544033333333AFAD2841CDCCCC4C9F0158419A99999999195440CDCCCCCCB1AD284100000000A10158419A9999999919544066666666B4AD2841333333F3A00158419A9999999919544066666666BDAD2841000000C0A00158419A999999991954409A999999C8AD284166666686A00158419A99999999195440', 'BATIMENT0000000314348966', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.4, 73.1, 80.5, 81.8, 73.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC64AE2841CDCCCC8C9B0158416666666666C654409A99999962AE2841000000809B0158416666666666C654409A99999961AE28419A9999799B0158416666666666C654403333333361AE28419A9999D99B0158416666666666C654406666666664AE2841CDCCCCEC9B0158416666666666C65440CDCCCCCC64AE2841CDCCCC8C9B0158416666666666C65440', 'BATIMENT0000000314349044', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.3, 78.8, 83.1, 83.8, 79.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC5FAE2841000000209D015841CDCCCCCCCC0C5540333333335FAE2841000000A09D015841CDCCCCCCCC0C5540CDCCCCCC62AE2841333333B39D015841CDCCCCCCCC0C55406666666663AE28419A9999399D015841CDCCCCCCCC0C5540CDCCCCCC5FAE2841000000209D015841CDCCCCCCCC0C5540', 'BATIMENT0000000314349058', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.9, 78.4, 84.3, 85.4, 78.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999A6AF2841CDCCCC2C99015841CDCCCCCCCCCC54409A999999ADAF28413333333399015841CDCCCCCCCCCC54409A999999ADAF28410000004099015841CDCCCCCCCCCC544000000000B1AF28416666664699015841CDCCCCCCCCCC544066666666B1AF28410000004097015841CDCCCCCCCCCC5440CDCCCCCCA9AF28413333333397015841CDCCCCCCCCCC544000000000A7AF28419A99999997015841CDCCCCCCCCCC54409A999999A6AF2841CDCCCC2C99015841CDCCCCCCCCCC5440', 'BATIMENT0000000314349222', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 81.1, 83.3, 84.8, 81.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA0AE28419A999939C20158419A99999999995340000000009EAE2841CDCCCCACC10158419A999999999953409A99999990AE284100000060C20158419A99999999995340CDCCCCCC92AE28419A999919C30158419A99999999995340CDCCCCCCA0AE28419A999939C20158419A99999999995340', 'BATIMENT0000000314349244', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.7, 73.8, 78.5, 80.3, 74.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC40AF28419A999999B8015841CDCCCCCCCCCC54400000000041AF2841CDCCCCECB7015841CDCCCCCCCCCC54406666666641AF284133333353B7015841CDCCCCCCCCCC5440000000003DAF284133333333B7015841CDCCCCCCCCCC5440CDCCCCCC3AAF284100000020B7015841CDCCCCCCCCCC5440333333333AAF2841CDCCCC8CB8015841CDCCCCCCCCCC5440CDCCCCCC40AF28419A999999B8015841CDCCCCCCCCCC5440', 'BATIMENT0000000314349258', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.0, 76.3, 83.3, 84.7, 76.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC1DAF2841CDCCCCCCC80158410000000000E05340CDCCCCCC29AF2841CDCCCC6CC80158410000000000E053400000000028AF28419A9999B9C70158410000000000E05340333333331CAF284100000020C80158410000000000E05340CDCCCCCC1DAF2841CDCCCCCCC80158410000000000E05340', 'BATIMENT0000000314349430', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 76.2, 79.5, 82.0, 76.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999D2AE2841666666E6D60158419A999999995953409A999999D3AE284166666646D80158419A99999999595340CDCCCCCCD7AE284100000040D80158419A999999995953409A999999D6AE2841CDCCCCCCD60158419A999999995953409A999999D2AE2841666666E6D60158419A99999999595340', 'BATIMENT0000000314349852', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.0, 75.5, 77.5, 77.7, 75.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC01B028419A999999C801584100000000002054409A99999901B02841000000A0C70158410000000000205440CDCCCCCCFDAF2841000000A0C7015841000000000020544000000000FEAF28419A999999C80158410000000000205440CDCCCCCC01B028419A999999C80158410000000000205440', 'BATIMENT0000000314349866', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.2, 78.4, 80.6, 80.8, 78.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C000000CDCCCCCC48AD28419A999999B401584133333333333354403333333348AD2841666666C6B201584133333333333354403333333348AD2841333333B3B20158413333333333335440666666662FAD2841CDCCCCACB20158413333333333335440666666662FAD2841000000C0B20158413333333333335440000000002EAD2841CDCCCC6CB501584133333333333354409A9999992DAD28419A9999D9B601584133333333333354406666666639AD2841CDCCCCECB60158413333333333335440CDCCCCCC3BAD2841333333F3B60158413333333333335440000000003DAD284100000040B50158413333333333335440CDCCCCCC48AD284100000020B50158413333333333335440CDCCCCCC48AD28419A999999B40158413333333333335440', 'BATIMENT0000000314349163', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.8, 72.1, 80.8, 81.4, 72.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC98AE28419A9999992C0158416666666666E65540CDCCCCCC83AE2841333333B32C0158416666666666E655400000000084AE2841333333D32D0158416666666666E655409A99999998AE2841666666C62D0158416666666666E65540CDCCCCCC98AE28419A9999992C0158416666666666E65540', 'BATIMENT0000000314347657', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.3, 84.4, 87.7, 87.9, 84.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A0000006666666607B6284166666606BEFE574133333333333356409A99999913B6284166666646BCFE574133333333333356406666666616B6284133333373BBFE574133333333333356403333333316B6284100000000BBFE574133333333333356403333333312B6284133333313BAFE574133333333333356400000000005B62841666666A6B8FE574133333333333356400000000002B6284166666606B9FE574133333333333356409A999999FAB528419A9999F9B9FE5741333333333333564000000000F0B5284133333353BBFE574133333333333356406666666607B6284166666606BEFE57413333333333335640', 'BATIMENT0000000314331667', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:14.231+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.8, 84.1, 88.8, 94.3, 87.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC18AC28419A99991963FF57413333333333135840CDCCCCCC0FAC28410000006062FF57413333333333135840666666660CAC28416666660663FF574133333333331358403333333315AC2841666666C663FF57413333333333135840CDCCCCCC18AC28419A99991963FF57413333333333135840', 'BATIMENT0000000314341409', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:13:23.414+02', '2017-01-24 13:25:20.595+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.4, 91.0, 96.3, 97.8, 92.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC91C12841000000C02B0158410000000000A058400000000092C12841000000802C0158410000000000A058400000000092C12841333333332E0158410000000000A058403333333398C12841333333332E0158410000000000A058406666666698C12841000000C02B0158410000000000A05840CDCCCCCC91C12841000000C02B0158410000000000A05840', 'BATIMENT0000000314350198', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:55.639+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.8, 92.8, 98.6, 99.7, 93.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333EFC128419A9999392E005841CDCCCCCCCCCC574066666666F0C12841000000802E005841CDCCCCCCCCCC574033333333F8C12841333333F32D005841CDCCCCCCCCCC574000000000F7C12841CDCCCCAC2D005841CDCCCCCCCCCC574033333333F0C12841666666262E005841CDCCCCCCCCCC574033333333EFC128419A9999392E005841CDCCCCCCCCCC5740', 'BATIMENT0000000314350004', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:06.554+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.2, 88.1, 95.3, 96.3, 89.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC3BBB2841CDCCCCACFC0258416666666666C65440CDCCCCCC07BB284100000060FC0258416666666666C654403333333307BB2841333333F3FE0258416666666666C65440333333333ABB284133333353FF0258416666666666C65440CDCCCCCC3BBB2841CDCCCCACFC0258416666666666C65440', 'BATIMENT0000000314350216', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.8, 75.3, 83.1, 83.6, 75.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999ADBA2841000000C01103584166666666662654409A999999ADBA2841666666C613035841666666666626544033333333C4BA28419A99999913035841666666666626544000000000C3BA2841CDCCCCCC1103584166666666662654409A999999ADBA2841000000C0110358416666666666265440', 'BATIMENT0000000314350223', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 6.1, 74.6, 80.7, 82.5, 75.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999B8B8284166666646930258419A99999999F9534066666666C4B8284133333313940258419A99999999F953409A999999C8B8284133333333930258419A99999999F95340CDCCCCCCBCB8284133333373920258419A99999999F953409A999999B8B8284166666646930258419A99999999F95340', 'BATIMENT0000000314350231', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 76.4, 80.0, 80.6, 76.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666EEBA2841000000E0000358416666666666A6534066666666EFBA28419A999979030358416666666666A6534033333333FBBA28419A999979030358416666666666A65340CDCCCCCCFABA2841666666E6010358416666666666A6534066666666EEBA2841000000E0000358416666666666A65340', 'BATIMENT0000000314350238', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.6, 75.1, 78.7, 79.2, 75.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000001FBD28419A999999AE0258419A99999999395440CDCCCCCC21BD28419A999959AD0258419A999999993954406666666615BD2841000000E0AC0258419A99999999395440CDCCCCCC11BD284166666626AE0258419A99999999395440000000001FBD28419A999999AE0258419A99999999395440', 'BATIMENT0000000314350240', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 3.7, 77.2, 80.9, 81.8, 77.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000140000009A999999ADBA2841000000C0110358410000000000C0544000000000C3BA2841CDCCCCCC110358410000000000C0544066666666F2BA2841CDCCCC0C120358410000000000C05440CDCCCCCCF6BA284100000000120358410000000000C0544000000000FABA2841000000E0100358410000000000C0544033333333FCBA2841000000400E0358410000000000C0544000000000FCBA28419A9999B90C0358410000000000C0544000000000E8BA2841666666C60D0358410000000000C054409A999999D5BA2841666666860E0358410000000000C054409A999999BCBA2841333333B30E0358410000000000C0544066666666BBBA284133333353080358410000000000C054409A999999ACBA284100000060080358410000000000C0544033333333ADBA2841000000800D0358410000000000C0544066666666AEBA2841333333730D0358410000000000C05440CDCCCCCCBBBA28419A9999790D0358410000000000C0544066666666BBBA28419A9999990E0358410000000000C0544066666666B9BA2841333333930E0358410000000000C054409A999999B8BA2841CDCCCC0C100358410000000000C0544066666666ADBA284166666606100358410000000000C054409A999999ADBA2841000000C0110358410000000000C05440', 'BATIMENT0000000314350222', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 8.5, 74.6, 83.1, 84.2, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999B8B8284166666646930258419A999999995954409A99999997B8284133333313910258419A99999999595440CDCCCCCC88B8284166666646940258419A9999999959544033333333B6B8284100000040970258419A9999999959544066666666C4B8284133333313940258419A999999995954409A999999B8B8284166666646930258419A99999999595440', 'BATIMENT0000000314350230', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 5.0, 76.5, 81.5, 83.4, 77.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC5FBD28419A999999A40258419A999999995954403333333365BD2841000000C0A40258419A999999995954409A99999969BD2841333333F3A20258419A999999995954406666666663BD2841333333D3A20258419A99999999595440CDCCCCCC5FBD28419A999999A40258419A99999999595440', 'BATIMENT0000000314350236', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.1, 77.4, 81.4, 81.8, 77.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000066666666C1BA2841CDCCCCCC1D035841CDCCCCCCCC8C5440CDCCCCCCE3BA2841CDCCCC0C15035841CDCCCCCCCC8C54409A999999DCBA2841CDCCCCAC14035841CDCCCCCCCC8C5440CDCCCCCCD6BA2841CDCCCC6C16035841CDCCCCCCCC8C54409A999999CABA2841CDCCCCEC15035841CDCCCCCCCC8C544033333333B0BA2841CDCCCC6C1C035841CDCCCCCCCC8C544066666666C1BA2841CDCCCCCC1D035841CDCCCCCCCC8C5440', 'BATIMENT0000000314350217', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:16.123+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.0, 75.3, 82.3, 83.5, 75.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCCC9C12841CDCCCCEC2D005841000000000080584000000000C4C12841666666462C0058410000000000805840CDCCCCCCB9C12841CDCCCC4C2900584100000000008058406666666692C12841666666C62B005841000000000080584000000000A0C12841000000802F0058410000000000805840CDCCCCCCAFC12841333333932E005841000000000080584066666666B2C12841333333532F0058410000000000805840CDCCCCCCC9C12841CDCCCCEC2D0058410000000000805840', 'BATIMENT0000000314350002', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:06.554+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 7.9, 90.1, 98.0, 99.2, 92.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000D7C12841000000202B005841CDCCCCCCCCCC564066666666DCC12841CDCCCCCC2A005841CDCCCCCCCCCC564066666666D8C12841CDCCCCCC29005841CDCCCCCCCCCC564000000000D3C12841000000202A005841CDCCCCCCCCCC564000000000D7C12841000000202B005841CDCCCCCCCCCC5640', 'BATIMENT0000000314350005', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:06.554+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 89.0, 91.2, 92.2, 89.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666692BA2841333333535CFF5741CDCCCCCCCC4C54409A9999997DBA28419A9999995AFF5741CDCCCCCCCC4C5440CDCCCCCC76BA2841333333D35BFF5741CDCCCCCCCC4C5440333333338BBA2841000000805DFF5741CDCCCCCCCC4C54406666666692BA2841333333535CFF5741CDCCCCCCCC4C5440', 'BATIMENT0000000314331673', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:18.106+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.8, 76.5, 81.3, 81.8, 78.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000003FC32841CDCCCC6CE5FE57410000000000404C403333333346C32841333333D3E5FE57410000000000404C40CDCCCCCC4DC32841000000A0E3FE57410000000000404C409A99999946C3284100000040E3FE57410000000000404C40000000003FC32841CDCCCC6CE5FE57410000000000404C40', 'BATIMENT0000000314331683', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:23.275+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire', 5.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 2.3, 54.3, 56.6, 56.8, 54.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC3DBB28419A9999D968FF5741CDCCCCCCCCEC5340CDCCCCCC2CBB28416666660668FF5741CDCCCCCCCCEC5340CDCCCCCC20BB2841333333F366FF5741CDCCCCCCCCEC53409A9999991BBB28419A99993968FF5741CDCCCCCCCCEC5340CDCCCCCC3ABB2841666666266AFF5741CDCCCCCCCCEC5340CDCCCCCC3DBB28419A9999D968FF5741CDCCCCCCCCEC5340', 'BATIMENT0000000314331672', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:03:18.106+02', '2017-01-24 13:32:36.567+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Corrélation', 1.0, NULL, NULL, NULL, NULL, 4.3, 75.5, 79.8, 83.8, 76.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCC1BB284100000000100158410000000000A0584066666666C8BB2841CDCCCC6C0D0158416666666666A6584066666666BEBB2841CDCCCC0C0D0158416666666666A6584000000000B8BB2841000000A00F0158416666666666A65840CDCCCCCCC1BB284100000000100158410000000000A05840', 'BATIMENT0000000304467924', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.9, 95.7, NULL, 98.7, 96.0, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000BABB284166666686180158410000000000E05840CDCCCCCCD4BB284166666666170158410000000000E0584000000000D1BB28419A999919160158410000000000E0584066666666B6BB284133333333170158410000000000E0584000000000BABB284166666686180158410000000000E05840', 'BATIMENT0000000304467925', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2017-01-31 19:24:49.547+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.0, 95.5, NULL, 104.0, 96.2, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C000000CDCCCCCCFDC128419A9999B9C102584133333333333355409A999999FDC12841333333D3BF0258413333333333535540CDCCCCCCDBC1284100000020BF0258419A99999999595540CDCCCCCCD2C1284100000000BE025841333333333353554000000000CAC1284133333353BE02584133333333335355409A999999C1C1284133333353BD025841333333333353554066666666B6C1284100000060BE025841333333333353554000000000C5C128419A999919C0025841333333333353554033333333D1C1284166666646C002584133333333335355409A999999D1C1284100000020C1025841333333333353554066666666E9C1284133333373C10258410000000000405540CDCCCCCCFDC128419A9999B9C10258413333333333335540', 'BATIMENT0000000027741993', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 3.4, 82.0, NULL, 85.9, 82.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000044C12841000000A02B0158419A99999999F957400000000044C128419A9999392E0158419A99999999F95740333333332EC12841333333332E0158419A99999999F957409A9999992EC12841666666862B0158419A99999999F957400000000044C12841000000A02B0158419A99999999F95740', 'BATIMENT0000000314350196', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:55.639+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.3, 94.6, 95.9, 97.2, 94.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC54BA2841333333938A035841CDCCCCCCCCEC5440CDCCCCCCB3BA28419A9999198E035841CDCCCCCCCCEC54409A999999A8BA2841CDCCCCCC92035841CDCCCCCCCCEC54409A99999949BA2841666666468F035841CDCCCCCCCCEC5440CDCCCCCC54BA2841333333938A035841CDCCCCCCCCEC5440', 'BATIMENT0000000314350249', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:30.673+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.1, 76.6, 83.7, 86.1, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000100000006666666638C328419A999919F7FE5741CDCCCCCCCCCC4E406666666639C3284133333393F6FE5741CDCCCCCCCCCC4E40CDCCCCCC2CC3284100000000F6FE5741CDCCCCCCCCCC4E403333333340C32841000000E0EEFE5741CDCCCCCCCCCC4E40CDCCCCCC47C32841CDCCCC2CEFFE5741CDCCCCCCCCCC4E406666666642C3284100000020F1FE5741CDCCCCCCCCCC4E40000000005FC3284100000040F2FE5741CDCCCCCCCCCC4E409A99999960C32841000000C0F1FE5741CDCCCCCCCCCC4E403333333365C32841666666E6F1FE5741CDCCCCCCCCCC4E409A99999969C3284133333393F0FE5741CDCCCCCCCCCC4E40000000007EC32841CDCCCC6CF1FE5741CDCCCCCCCCCC4E409A99999974C32841666666C6F4FE5741CDCCCCCCCCCC4E40000000006DC32841CDCCCC6CF5FE5741CDCCCCCCCCCC4E400000000059C328419A9999B9F4FE5741CDCCCCCCCCCC4E409A99999950C3284133333313F8FE5741CDCCCCCCCCCC4E406666666638C328419A999919F7FE5741CDCCCCCCCCCC4E40', 'BATIMENT0000000357670279', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2016-06-10 15:22:50.421+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.9, 54.7, 61.6, 64.5, 57.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000C0000006666666632C3284166666686FCFE5741CDCCCCCCCCCC4E409A9999992EC3284166666646FCFE5741CDCCCCCCCCCC4E406666666638C328419A999919F7FE5741CDCCCCCCCCCC4E409A99999950C3284133333313F8FE5741CDCCCCCCCCCC4E40CDCCCCCC4CC32841000000C0F9FE5741CDCCCCCCCCCC4E400000000073C3284100000040FBFE5741CDCCCCCCCCCC4E406666666692C3284166666686FCFE5741CDCCCCCCCCCC4E40666666668EC32841CDCCCC6CFEFE5741CDCCCCCCCCCC4E400000000047C32841CDCCCCACFBFE5741CDCCCCCCCCCC4E403333333345C328419A999979FCFE5741CDCCCCCCCCCC4E40CDCCCCCC42C3284100000080FDFE5741CDCCCCCCCCCC4E406666666632C3284166666686FCFE5741CDCCCCCCCCCC4E40', 'BATIMENT0000000357670280', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2016-06-10 15:22:50.421+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.9, 54.7, 61.6, 63.5, 58.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000DEC22841CDCCCCECD6FE5741CDCCCCCCCC4C4D4000000000B1C22841333333D3D2FE5741CDCCCCCCCC4C4D409A999999B7C22841000000A0D1FE5741CDCCCCCCCC4C4D4066666666E5C22841333333B3D5FE5741CDCCCCCCCC4C4D4000000000DEC22841CDCCCCECD6FE5741CDCCCCCCCC4C4D40', 'BATIMENT0000000314331682', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:03:23.275+02', '2017-01-31 19:24:49.547+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.4, 52.2, 58.6, 59.5, 54.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999971BA2841CDCCCC8C930358419A999999993954400000000089BA2841CDCCCC6C940358419A999999993954409A9999997ABA2841CDCCCC6C9A0358419A999999993954403333333363BA284133333393990358419A999999993954409A99999971BA2841CDCCCC8C930358419A99999999395440', 'BATIMENT0000000314350248', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:30.673+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 76.9, 80.9, 81.4, 76.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333332AB2841000000A024025841CDCCCCCCCCCC5140333333333AAB28419A999959220258413333333333D351400000000031AB2841666666C6210258413333333333D351403333333327AB2841CDCCCCEC23025841CDCCCCCCCCCC51403333333332AB2841000000A024025841CDCCCCCCCCCC5140', 'BATIMENT0000000027743821', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 1.3, 70.0, NULL, 73.8, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666672B52841333333530B0158413333333333D35740000000008EB52841000000200D0158416666666666C65740CDCCCCCC85B52841666666660F0158416666666666C65740CDCCCCCC6AB52841000000A00D0158416666666666C657406666666672B52841333333530B0158413333333333D35740', 'BATIMENT0000000027745842', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.1, 93.2, NULL, 99.3, 93.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999997AAA28419A999939A6FF57419A99999999995C40CDCCCCCC8FAA284133333373A6FF57410000000000C05C409A99999990AA28419A999919A8FF57410000000000C05C40666666667BAA2841CDCCCC0CA8FF57413333333333B35C409A9999997AAA28419A999939A6FF57419A99999999995C40', 'BATIMENT0000000027748860', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.5, 112.5, NULL, 121.0, 113.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000009000000CDCCCCCCABAF2841000000E0060058413333333333735B40000000009FAF284166666686060058413333333333735B4033333333A4AF2841CDCCCC8C030058410000000000805B40CDCCCCCCB0AF284100000000040058416666666666865B4033333333AEAF284100000040050058416666666666865B4033333333ACAF28419A999939050058416666666666865B4033333333ABAF28419A9999B9050058416666666666865B409A999999ADAF2841000000E0050058416666666666865B40CDCCCCCCABAF2841000000E0060058413333333333735B40', 'BATIMENT0000000304467842', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:19.379+02', '2017-01-31 21:26:19.973+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.0, 107.1, NULL, 113.0, 107.2, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000000000007FAE284166666666E5FF5741CDCCCCCCCC8C59400000000090AE2841CDCCCC4CE7FF5741CDCCCCCCCC8C5940000000008BAE284133333333E8FF5741CDCCCCCCCC8C59400000000080AE28419A999919E7FF5741CDCCCCCCCC8C5940333333337CAE284133333393E7FF5741CDCCCCCCCC8C59403333333376AE2841333333D3E6FF5741CDCCCCCCCC8C5940000000007FAE284166666666E5FF5741CDCCCCCCCC8C5940', 'BATIMENT0000000027748857', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.7, 97.5, NULL, 105.4, 99.0, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC4EAA28419A9999593F03584100000000002050409A99999956AA28419A9999F94203584100000000002050403333333337AA284133333313440358410000000000205040666666662FAA2841CDCCCC6C400358410000000000205040CDCCCCCC4EAA28419A9999593F0358410000000000205040', 'BATIMENT0000000314341022', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.0, 58.5, 64.5, 65.0, 62.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000000000000072AA284166666666CE0358410000000000804C40CDCCCCCC77AA284133333373CE0358410000000000804C40666666668BAA2841CDCCCCECC00358410000000000804C403333333380AA28419A999999C00358410000000000804C409A9999996EAA284133333333CC0358410000000000804C40333333336CAA2841CDCCCC4CCE0358410000000000804C400000000072AA284166666666CE0358410000000000804C40', 'BATIMENT0000000314340956', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:48.171+02', '2018-07-03 06:49:09.898+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.8, 50.2, 57.0, 57.9, 53.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCABAD284100000060830158419A9999999999544033333333A3AD284166666626830158419A9999999999544066666666A5AD2841000000C0810158419A999999999954409A999999A9AD2841CDCCCCEC810158419A9999999999544000000000B2AD284100000040820158419A9999999999544066666666AFAD28419A9999B9820158419A99999999995440CDCCCCCCABAD284100000060830158419A99999999995440', 'BATIMENT0000000314347123', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.4, 75.0, 82.4, 82.5, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333A9B32841CDCCCC2C3E015841333333333333594000000000BBB32841333333933D0158410000000000005940CDCCCCCCB9B32841000000403C0158413333333333135940CDCCCCCCA4B32841666666063D015841CDCCCCCCCC4C594033333333A9B32841CDCCCC2C3E0158413333333333335940', 'BATIMENT0000000027745847', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 6.8, 94.4, NULL, 101.7, 96.4, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC63AF2841CDCCCCAC080158416666666666A65740CDCCCCCC4EAF284133333333080158416666666666A65740CDCCCCCC4FAF2841CDCCCC6C070158416666666666A657400000000065AF28419A9999D9070158416666666666A65740CDCCCCCC63AF2841CDCCCCAC080158416666666666A65740', 'BATIMENT0000000314347588', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 88.9, 94.6, 96.5, 91.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666625B328419A9999792C04584133333333337352400000000046B32841333333932B0458410000000000C052409A99999941B3284133333313280458410000000000C05240000000001FB32841CDCCCCAC280458416666666666A652406666666625B328419A9999792C0458413333333333735240', 'BATIMENT0000000027740714', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 5.1, 69.9, NULL, 76.4, 71.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC70AE284100000020A70158413333333333735440333333336FAE28419A999919A80158413333333333735440000000006DAE2841CDCCCC0CA80158413333333333735440CDCCCCCC61AE2841333333B3A701584133333333337354409A99999963AE2841333333B3A60158413333333333735440CDCCCCCC70AE284100000020A70158413333333333735440', 'BATIMENT0000000314348473', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.8, 75.0, 81.8, 83.4, 76.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666660EAF2841333333B3FE0158413333333333F35440CDCCCCCCFFAE28419A9999B9FE0158413333333333F35440CDCCCCCCFFAE2841CDCCCCECFC0158413333333333F35440333333330DAF2841CDCCCCECFC0158413333333333F35440333333330DAF28419A9999D9FD0158413333333333F35440333333330EAF2841000000E0FD0158413333333333F35440666666660EAF2841333333B3FE0158413333333333F35440', 'BATIMENT0000000304467873', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2018-02-20 14:11:41.158+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.8, 81.0, NULL, 83.9, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999997AAE284133333373A70158419A99999999795440000000007AAE2841CDCCCCCCA70158419A999999997954400000000079AE284100000060A80158419A99999999795440333333336FAE28419A999919A80158419A99999999795440CDCCCCCC70AE284100000020A70158419A999999997954409A9999997AAE284133333373A70158419A99999999795440', 'BATIMENT0000000314348475', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.9, 75.0, 81.9, 82.5, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333332CB02841000000C09F0158410000000000A05540333333332CB028419A9999199F0158410000000000A055409A99999937B028419A9999199F0158410000000000A05540CDCCCCCC37B02841666666C69F0158410000000000A05540333333332CB02841000000C09F0158410000000000A05540', 'BATIMENT0000000314348932', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 83.4, 86.5, 86.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999AEAF2841666666E6D8015841666666666666544000000000AAAF2841CDCCCCECD801584166666666666654409A999999A8AF284100000080D7015841666666666666544000000000AEAF284133333373D701584166666666666654409A999999AEAF2841666666E6D80158416666666666665440', 'BATIMENT0000000314349713', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 77.7, 81.6, 82.2, 78.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000FFAD2841CDCCCC8CE5015841CDCCCCCCCC6C53403333333301AE284100000000E7015841CDCCCCCCCC6C534033333333FEAD2841CDCCCC0CE7015841CDCCCCCCCC6C534000000000FCAD28419A999999E5015841CDCCCCCCCC6C534000000000FFAD2841CDCCCC8CE5015841CDCCCCCCCC6C5340', 'BATIMENT0000000314349741', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 74.0, 77.7, 78.3, 74.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCDAAD284100000000FC015841CDCCCCCCCCEC5340CDCCCCCCDBAD28419A9999B9FB015841CDCCCCCCCCEC5340CDCCCCCCE4AD284166666646FC015841CDCCCCCCCCEC5340CDCCCCCCE3AD284133333393FC015841CDCCCCCCCCEC5340CDCCCCCCDAAD284100000000FC015841CDCCCCCCCCEC5340', 'BATIMENT0000000314349745', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 75.5, 79.7, 80.5, 76.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000041B328419A9999B96F0158416666666666065740CDCCCCCC4BB32841CDCCCCEC6F0158413333333333D35640000000004BB3284166666606710158413333333333D356400000000040B328419A9999D97001584166666666660657400000000041B328419A9999B96F0158416666666666065740', 'BATIMENT0000000027745726', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.7, 89.4, NULL, 93.9, 90.4, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A000000CDCCCCCCEFB22841CDCCCCACA801584166666666660658409A999999F0B2284133333313A9015841666666666606584066666666F6B22841666666E6A8015841666666666606584000000000F9B22841CDCCCC4CAA015841666666666606584066666666F9B228419A999979AA015841666666666606584066666666EEB22841CDCCCCCCAA015841666666666606584033333333EDB2284133333333AA015841666666666606584000000000DFB228419A999999AA015841666666666606584066666666DCB228419A999939A90158416666666666065840CDCCCCCCEFB22841CDCCCCACA80158416666666666065840', 'BATIMENT0000000314350159', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.5, 87.6, 96.1, 96.2, 88.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666CEA628419A999919CA025841CDCCCCCCCC2C504066666666DEA62841000000E0CA025841000000000040504000000000D9A628419A999939CC0258416666666666265040CDCCCCCCC9A6284100000060CB0258419A9999999919504066666666CEA628419A999919CA025841CDCCCCCCCC2C5040', 'BATIMENT0000000027742041', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 61.3, NULL, 65.4, 61.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC37AF2841000000402C0258419A999999999954403333333336AF28419A9999F92C0258419A99999999995440CDCCCCCC2EAF2841666666662D0258419A99999999995440CDCCCCCC31AF2841CDCCCC0C2C0258419A99999999995440CDCCCCCC37AF2841000000402C0258419A99999999995440', 'BATIMENT0000000314349748', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.6, 76.8, 82.4, 83.6, 78.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A99999910B02841333333B31E025841CDCCCCCCCC4C5640CDCCCCCC1BB02841666666C61D025841CDCCCCCCCC4C56400000000021B028419A9999591D025841CDCCCCCCCC4C56409A99999925B02841000000401E025841CDCCCCCCCC4C56403333333328B028419A9999B91E025841CDCCCCCCCC4C56409A99999917B028413333331320025841CDCCCCCCCC4C5640CDCCCCCC15B02841000000C01F025841CDCCCCCCCC4C56409A99999910B02841333333B31E025841CDCCCCCCCC4C5640', 'BATIMENT0000000314349788', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.6, 82.6, 89.2, 89.8, 82.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333E7B02841000000009D0058410000000000405A40CDCCCCCCE8B02841000000209C0058410000000000405A40CDCCCCCCEDB02841000000409C0058410000000000405A4033333333ECB02841333333139D0058410000000000405A4033333333E7B02841000000009D0058410000000000405A40', 'BATIMENT0000000314341092', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.5, 101.5, 105.0, 105.4, 102.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000E1B428419A9999F96E0158419A99999999395640CDCCCCCCE0B42841666666C66F0158419A9999999939564000000000DBB42841000000C06F0158419A9999999939564033333333DBB428419A9999F96E0158419A9999999939564000000000E1B428419A9999F96E0158419A99999999395640', 'BATIMENT0000000314341093', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 85.8, 88.9, 89.6, 87.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666603B128419A999959290158413333333333335C406666666606B12841666666C62A015841CDCCCCCCCC2C5C40333333330DB12841000000802A015841CDCCCCCCCC2C5C40666666660AB128419A999919290158410000000000405C406666666603B128419A999959290158413333333333335C40', 'BATIMENT0000000027745848', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.6, 110.4, NULL, 120.5, 110.9, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666669CB02841666666266B015841666666666606584000000000A4B02841CDCCCCEC6A0158416666666666065840CDCCCCCCA5B02841333333B36B015841666666666606584000000000A5B02841666666866C0158416666666666065840666666669FB02841333333B36C0158416666666666065840666666669CB02841666666266B0158416666666666065840', 'BATIMENT0000000314341151', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 91.2, 96.1, 96.3, 93.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC64B12841000000202E0158419A99999999995D400000000064B12841333333B32E0158419A99999999995D40000000005AB12841000000C02E0158419A99999999995D409A99999959B12841CDCCCC2C2F0158419A99999999995D406666666653B128419A9999392F0158419A99999999995D406666666653B128419A9999192E0158419A99999999995D40CDCCCCCC64B12841000000202E0158419A99999999995D40', 'BATIMENT0000000314341171', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.6, 110.8, 118.4, 121.0, 115.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A99999980AD28419A9999392501584133333333339357400000000075AD2841000000202501584133333333339357406666666674AD2841CDCCCC2C260158413333333333935740CDCCCCCC71AD2841000000202601584133333333339357403333333373AD2841CDCCCC6C2401584133333333339357403333333381AD2841333333B32401584133333333339357409A99999980AD28419A999939250158413333333333935740', 'BATIMENT0000000314347451', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 88.4, 94.3, 95.3, 89.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A9999999FAB28419A999999380458410000000000C04C409A999999DCAB284100000040380458410000000000C04C4033333333DEAB2841000000803A0458410000000000C04C40CDCCCCCCBCAB2841CDCCCCAC3A0458410000000000C04C4000000000A2AB28419A9999D93A0458410000000000C04C409A9999999FAB28419A999999380458410000000000C04C40', 'BATIMENT0000000314340961', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:48.171+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.2, 51.3, 57.5, 58.4, 53.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666667BAD28419A999939270158416666666666265740CDCCCCCC79AD284166666686280158416666666666265740CDCCCCCC6DAD2841CDCCCC4C2801584166666666662657409A9999996FAD2841333333D32601584166666666662657400000000074AD2841000000E02601584166666666662657400000000074AD284133333313270158416666666666265740666666667BAD28419A999939270158416666666666265740', 'BATIMENT0000000314347453', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 88.3, 92.6, 93.0, 88.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC43AE284133333353FB005841CDCCCCCCCC6C58409A99999937AE2841CDCCCC0CFB005841CDCCCCCCCC6C58403333333338AE28419A999999FA005841CDCCCCCCCC6C5840333333332DAE284100000060FA005841CDCCCCCCCC6C5840CDCCCCCC2DAE28419A9999F9F9005841CDCCCCCCCC6C5840CDCCCCCC44AE28419A999979FA005841CDCCCCCCCC6C5840CDCCCCCC43AE284133333353FB005841CDCCCCCCCC6C5840', 'BATIMENT0000000314347512', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 93.5, 97.7, 99.3, 94.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC26AE2841666666063601584166666666668656406666666626AE284166666686360158416666666666865640CDCCCCCC13AE2841CDCCCC4C3601584166666666668656403333333314AE2841CDCCCCCC350158416666666666865640CDCCCCCC26AE284166666606360158416666666666865640', 'BATIMENT0000000314347629', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 86.2, 90.1, 90.3, 86.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCD3AC2841CDCCCCCC5A0158419A9999999939544066666666D4AC2841000000205B0158419A9999999939544033333333C4AC2841333333735B0158419A999999993954409A999999C3AC2841CDCCCC0C5B0158419A99999999395440CDCCCCCCD3AC2841CDCCCCCC5A0158419A99999999395440', 'BATIMENT0000000314347619', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 76.2, 80.9, 82.1, 77.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999998DAE2841666666E672015841000000000020564066666666B2AE2841CDCCCCEC75015841000000000020564066666666A4AE28419A999959780158410000000000205640666666667AAE28419A9999D97401584100000000002056400000000081AE2841CDCCCC8C7301584100000000002056403333333387AE2841000000607201584100000000002056409A9999998DAE2841666666E6720158410000000000205640', 'BATIMENT0000000314347303', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.2, 80.3, 88.5, 89.4, 81.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333F8AF2841CDCCCC4C590158413333333333D35740CDCCCCCCF8AF28419A9999F9560158413333333333D3574000000000FAAF284166666666540158413333333333D357409A99999911B02841CDCCCC6C540158413333333333D357409A99999911B02841000000E0550158413333333333D357403333333310B0284133333353590158413333333333D3574033333333F8AF2841CDCCCC4C590158413333333333D35740', 'BATIMENT0000000314347688', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.8, 91.5, 95.3, 97.2, 91.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333B4AF2841666666C695015841CDCCCCCCCC6C55409A999999BEAF28419A9999B995015841CDCCCCCCCC6C5540CDCCCCCCC6AF2841CDCCCCAC95015841CDCCCCCCCC6C554033333333C6AF2841000000C096015841CDCCCCCCCC6C554066666666ADAF28419A9999D996015841CDCCCCCCCC6C55409A999999ADAF2841CDCCCCCC95015841CDCCCCCCCC6C554033333333B4AF2841666666C695015841CDCCCCCCCC6C5540', 'BATIMENT0000000314349228', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 81.6, 85.7, 87.8, 81.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333EAAE28419A9999B949015841CDCCCCCCCCCC554000000000E4AE28413333331349015841CDCCCCCCCCCC554033333333E8AE28410000008048015841CDCCCCCCCCCC554000000000EEAE28419A99991949015841CDCCCCCCCCCC554033333333EAAE28419A9999B949015841CDCCCCCCCCCC5540', 'BATIMENT0000000314347221', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.6, 84.6, 87.2, 87.7, 84.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000003AF2841666666063D015841666666666646564066666666FFAE2841000000603C0158416666666666465640000000000BAF2841333333733B01584166666666664656409A9999990EAF28419A9999193C01584166666666664656400000000003AF2841666666063D0158416666666666465640', 'BATIMENT0000000314347418', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 84.9, 89.1, 91.2, 85.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666666EAE2841333333B34C01584166666666666655403333333367AE2841000000604E01584166666666666655400000000061AE28419A9999B94F01584166666666666655400000000055AE28419A9999194F0158416666666666665540CDCCCCCC60AE2841000000E04B0158416666666666665540666666666EAE2841333333B34C0158416666666666665540', 'BATIMENT0000000314347330', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.4, 83.2, 85.6, 86.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666675AE28419A999979AA01584100000000006054400000000069AE284100000020AA0158410000000000605440333333336BAE284166666606A901584100000000006054406666666677AE28419A999959A901584100000000006054406666666675AE28419A999979AA0158410000000000605440', 'BATIMENT0000000314348476', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.5, 75.0, 81.5, 81.8, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000000000000CDAE284166666666AD015841333333333373544000000000CBAE284133333373AF015841333333333373544000000000C8AE28419A999939AF015841333333333373544000000000BCAE284100000060AE015841333333333373544000000000B1AE28419A999999AD015841333333333373544033333333B3AE284133333393AB015841333333333373544000000000CDAE284166666666AD0158413333333333735440', 'BATIMENT0000000314348485', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.8, 75.0, 81.8, 82.6, 76.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000B9AE284133333373B401584166666666666654409A999999B7AE2841333333B3B50158416666666666665440CDCCCCCCADAE284133333373B501584166666666666654409A999999AFAE284133333313B4015841666666666666544066666666B1AE284166666626B4015841666666666666544000000000B9AE284133333373B40158416666666666665440', 'BATIMENT0000000314348488', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.6, 75.0, 81.6, 82.5, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A9999997CAE2841000000E0A0015841CDCCCCCCCC4C5540CDCCCCCC86AE28419A999919A1015841CDCCCCCCCC4C55403333333389AE2841333333F39E015841CDCCCCCCCC4C5540CDCCCCCC89AE2841CDCCCC8C9E015841CDCCCCCCCC4C55409A99999980AE28419A9999599E015841CDCCCCCCCC4C55409A9999997BAE28419A9999399E015841CDCCCCCCCC4C55403333333377AE2841000000C0A0015841CDCCCCCCCC4C55409A9999997CAE2841000000E0A0015841CDCCCCCCCC4C5540', 'BATIMENT0000000314349045', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-07-03 06:49:09.898+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.2, 77.0, 85.2, 86.5, 79.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999997BAF284133333313990158419A99999999395540000000007CAF2841CDCCCC8C980158419A99999999395540000000008FAF2841CDCCCCAC980158419A99999999395540CDCCCCCC8EAF284100000020990158419A999999993955409A9999997BAF284133333313990158419A99999999395540', 'BATIMENT0000000314349221', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.6, 81.3, 84.9, 85.5, 81.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000040000000000000077AA284100000060D20358410000000000004D409A99999972AA284166666646D20358410000000000004D403333333374AA28419A999959D00358410000000000004D400000000077AA284100000060D20358410000000000004D40', 'BATIMENT0000000314340954', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:48.171+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.5, 51.5, 58.0, 58.4, 52.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666661EAD284133333313820458416666666666A64D406666666620AD2841333333D3840458416666666666A64D406666666607AD28419A999939850458416666666666A64D400000000005AD284166666686820458416666666666A64D40666666661EAD284133333313820458416666666666A64D40', 'BATIMENT0000000314350203', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:33:05.473+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.4, 53.9, 59.3, 60.0, 53.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC0EA82841CDCCCC6CBE0058416666666666265F40666666660FA82841CDCCCCACC00058416666666666265F4066666666FDA72841000000C0C00058416666666666265F40CDCCCCCCFCA7284100000080BE0058416666666666265F40CDCCCCCC0EA82841CDCCCC6CBE0058416666666666265F40', 'BATIMENT0000000314346820', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:24:56.193+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 120.5, 124.6, 125.5, 122.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000D000000666666662CA8284133333373C20058416666666666C65F40666666662BA8284133333333C10058416666666666C65F406666666621A828419A999959C10058416666666666C65F40333333331FA82841000000C0BE0058416666666666C65F403333333329A82841000000A0BE0058416666666666C65F40CDCCCCCC26A82841CDCCCCACBB0058416666666666C65F400000000025A82841666666A6B90058416666666666C65F40000000003DA8284133333353B90058416666666666C65F40CDCCCCCC3FA82841666666A6BC0058416666666666C65F403333333342A82841CDCCCCACBF0058416666666666C65F406666666644A8284100000020C20058416666666666C65F403333333337A82841CDCCCC4CC20058416666666666C65F40666666662CA8284133333373C20058416666666666C65F40', 'BATIMENT0000000314346825', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:24:56.193+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 122.5, 127.1, 127.9, 123.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000000000000A1AD2841CDCCCC4CFFFE57419A999999991956409A9999999AAD284100000060FFFE57419A99999999195640000000009FAD2841CDCCCC4C03FF57419A9999999919564033333333ACAD2841CDCCCC0C03FF57419A9999999919564066666666ABAD28416666662602FF57419A9999999919564033333333B2AD2841333333F301FF57419A9999999919564033333333B1AD2841000000C000FF574100000000002056409A999999A3AD28419A99991901FF5741000000000020564000000000A1AD2841CDCCCC4CFFFE57419A99999999195640', 'BATIMENT0000000206309849', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2008-09-25 16:47:29.261+02', '2017-01-31 21:26:19.973+01', NULL, '2006-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.9, 81.6, NULL, 88.5, 87.3, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666667EAD2841666666E60902584133333333339353406666666670AD2841666666060902584133333333339353406666666671AD2841CDCCCCCC080258413333333333935340333333337FAD2841CDCCCCAC090258413333333333935340666666667EAD2841666666E6090258413333333333935340', 'BATIMENT0000000314349670', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.3, 73.0, 78.3, 78.9, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000D2AF28419A999919460158413333333333D3574066666666D1AF2841CDCCCC6C470158413333333333D3574000000000CCAF2841CDCCCC6C470158413333333333D3574000000000CCAF2841CDCCCCCC460158413333333333D3574033333333CCAF284133333313460158413333333333D3574000000000D2AF28419A999919460158413333333333D35740', 'BATIMENT0000000314347078', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 91.6, 95.3, 95.8, 91.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000018B128419A9999B945015841CDCCCCCCCCAC5A40CDCCCCCC22B128413333333346015841CDCCCCCCCCAC5A40333333331FB128413333337347015841CDCCCCCCCCAC5A40CDCCCCCC14B128410000000047015841CDCCCCCCCCAC5A406666666614B128419A9999F946015841CDCCCCCCCCAC5A400000000018B128419A9999B945015841CDCCCCCCCCAC5A40', 'BATIMENT0000000314341241', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 102.4, 106.7, 106.9, 102.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333F8AF2841CDCCCC4C590158419A99999999B95740CDCCCCCCEBAF284166666646590158419A99999999B95740CDCCCCCCEDAF2841CDCCCCEC560158419A99999999B95740CDCCCCCCF8AF28419A9999F9560158419A99999999B9574033333333F8AF2841CDCCCC4C590158419A99999999B95740', 'BATIMENT0000000314347068', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.4, 91.5, 94.9, 95.6, 91.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333302B02841CDCCCC2C7C015841CDCCCCCCCC2C564066666666F0AF2841333333737C015841CDCCCCCCCC2C564066666666EBAF2841666666A67B015841CDCCCCCCCC2C56409A99999901B02841000000407B015841CDCCCCCCCC2C56403333333302B02841CDCCCC2C7C015841CDCCCCCCCC2C5640', 'BATIMENT0000000314347085', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.3, 85.4, 88.7, 90.7, 86.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333F0AE2841CDCCCCEC640158419A9999999939564066666666EAAE2841666666C6650158419A999999993956409A999999E6AE284100000060650158419A9999999939564033333333E2AE2841666666E6640158419A99999999395640CDCCCCCCE7AE284100000000640158419A9999999939564033333333F0AE2841CDCCCCEC640158419A99999999395640', 'BATIMENT0000000314347241', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.3, 81.6, 88.9, 89.8, 82.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333335CAB2841000000803F0258419A99999999D951400000000075AB28419A9999393D025841CDCCCCCCCCEC51403333333376AB2841CDCCCC6C3E025841CDCCCCCCCCEC5140333333335FAB284166666686400258410000000000E05140333333335CAB2841000000803F0258419A99999999D95140', 'BATIMENT0000000027743781', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.3, 69.4, NULL, 73.0, 69.4, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000042AF28419A9999B92F0158413333333333B357409A9999993FAF2841CDCCCC8C2E0158413333333333B35740CDCCCCCC4FAF2841CDCCCC0C2E0158413333333333B35740CDCCCCCC50AF28419A9999792E0158413333333333B357400000000052AF2841333333332F0158413333333333B357400000000042AF28419A9999B92F0158413333333333B35740', 'BATIMENT0000000314347431', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.5, 88.3, 94.8, 95.8, 88.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999E9AB28419A9999B9460158419A99999999F954409A999999E9AB284133333373470158419A99999999F9544033333333DFAB284133333373470158419A99999999F9544066666666DFAB2841333333B3460158419A99999999F954409A999999E9AB28419A9999B9460158419A99999999F95440', 'BATIMENT0000000314347586', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.4, 79.5, 83.9, 84.3, 80.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333E3AB2841333333337F0158419A9999999999534066666666E3AB28419A9999B97F0158419A9999999999534066666666E3AB284166666606800158419A9999999999534000000000E1AB284166666606800158419A99999999995340CDCCCCCCE0AB2841333333337F0158419A9999999999534033333333E3AB2841333333337F0158419A99999999995340', 'BATIMENT0000000314347614', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 74.2, 78.4, 80.0, 74.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC89AB2841000000807E0158416666666666E65340CDCCCCCC8FAB28419A9999797E0158416666666666E65340CDCCCCCC8FAB2841CDCCCC8C7E0158416666666666E65340CDCCCCCC8FAB2841333333B37E0158416666666666E65340CDCCCCCC89AB2841000000C07E0158416666666666E65340CDCCCCCC89AB2841000000807E0158416666666666E65340', 'BATIMENT0000000314347342', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 75.0, 79.6, 80.2, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999B4AB28419A9999198F0158413333333333735340CDCCCCCCB4AB2841CDCCCC8C90015841333333333373534033333333B1AB2841CDCCCC8C90015841333333333373534066666666B0AB2841000000208F01584133333333337353409A999999B4AB28419A9999198F0158413333333333735340', 'BATIMENT0000000314348293', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.8, 74.0, 77.8, 78.3, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B000000CDCCCCCC4AB0284166666606150258419A99999999D956409A9999993EB0284166666686170258419A99999999D956406666666634B028419A9999B9160258410000000000A05640CDCCCCCC32B028410000002017025841CDCCCCCCCC4C56400000000030B02841CDCCCC0C1702584133333333335356400000000026B0284100000020160258416666666666065640CDCCCCCC31B02841CDCCCCEC150258419A999999991956400000000030B02841CDCCCC0C150258410000000000205640666666663AB02841000000C0140258410000000000805640666666663EB02841666666E6130258410000000000805640CDCCCCCC4AB0284166666606150258419A99999999D95640', 'BATIMENT0000000304467865', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:45.308+02', '2018-02-20 14:11:41.158+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 6.0, 85.4, NULL, 91.7, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333335AAF2841CDCCCCEC14025841CDCCCCCCCC4C5540666666666DAF28419A99995915025841CDCCCCCCCC4C55409A9999996AAF2841CDCCCCEC17025841CDCCCCCCCC4C5540CDCCCCCC56AF28413333339317025841CDCCCCCCCC4C5540333333335AAF2841CDCCCCEC14025841CDCCCCCCCC4C5540', 'BATIMENT0000000027743792', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.1, 82.1, NULL, 85.6, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC7BAF28419A9999192F02584166666666660655409A9999997CAF2841333333B32E02584166666666660655403333333381AF2841000000E02E02584166666666660655406666666680AF2841000000402F0258416666666666065540CDCCCCCC7BAF28419A9999192F0258416666666666065540', 'BATIMENT0000000314349737', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.4, 77.7, 84.1, 85.2, 78.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333E5AD2841666666E6FD015841CDCCCCCCCCEC534033333333E0AD2841CDCCCC8CFD015841CDCCCCCCCCEC534000000000E1AD284166666646FD015841CDCCCCCCCCEC534066666666E6AD2841000000A0FD015841CDCCCCCCCCEC534033333333E5AD2841666666E6FD015841CDCCCCCCCCEC5340', 'BATIMENT0000000314349744', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 75.5, 79.7, 81.4, 76.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC34AE2841000000E0070258419A999999997954406666666631AE284133333313090258419A99999999795440CDCCCCCC2DAE2841CDCCCCEC080258419A999999997954403333333331AE2841000000C0070258419A99999999795440CDCCCCCC34AE2841000000E0070258419A99999999795440', 'BATIMENT0000000314349767', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.6, 78.3, 81.9, 83.6, 79.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B000000000000006EB02841666666E6110258419A999999991957409A9999996DB02841CDCCCC8C110258419A99999999195740CDCCCCCC71B028419A999979110258419A999999991957409A9999996FB02841666666860F0258419A99999999195740666666666AB02841CDCCCC8C0F0258419A999999991957409A99999969B02841333333B30E0258419A999999991957406666666676B02841000000400E0258419A999999991957406666666677B028419A9999390F0258419A999999991957409A99999981B02841666666060F0258419A999999991957406666666684B02841CDCCCC4C110258419A99999999195740000000006EB02841666666E6110258419A99999999195740', 'BATIMENT0000000314350023', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.0, 86.4, 92.4, 93.6, 87.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000006EB02841666666E611025841CDCCCCCCCC0C57406666666684B02841CDCCCC4C11025841CDCCCCCCCC0C57409A99999985B028416666664612025841CDCCCCCCCC0C5740CDCCCCCC6EB02841666666C612025841CDCCCCCCCC0C5740000000006EB02841666666E611025841CDCCCCCCCC0C5740', 'BATIMENT0000000314350024', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.8, 86.4, 92.2, 93.7, 87.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000C6B02841CDCCCCAC1E02584100000000008057409A999999B2B02841000000201F025841000000000080574033333333B1B02841CDCCCC6C1E025841000000000080574033333333C5B02841CDCCCCEC1D025841000000000080574000000000C6B02841CDCCCCAC1E0258410000000000805740', 'BATIMENT0000000314350027', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.1, 85.9, 94.0, 94.2, 87.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666E9B42841000000C01A0258419A99999999F9544033333333EBB42841CDCCCCAC190258419A99999999F9544066666666F5B42841000000001A0258419A99999999F9544000000000F4B42841666666061B0258419A99999999F9544066666666E9B42841000000C01A0258419A99999999F95440', 'BATIMENT0000000314350031', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.8, 80.1, 83.9, 85.1, 82.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000EDB02841000000001E0258419A99999999D95640CDCCCCCCF0B0284100000020200258419A99999999D9564066666666ECB0284166666646200258419A99999999D9564066666666E9B028419A999959200258419A99999999D9564033333333E5B02841666666461E0258419A99999999D9564000000000EDB02841000000001E0258419A99999999D95640', 'BATIMENT0000000314350034', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.4, 86.0, 91.4, 92.8, 87.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666670B02841333333B33F02584133333333339355403333333370B02841333333533D0258413333333333935540CDCCCCCC8DB02841000000403D0258413333333333935540333333338EB02841666666A63F02584133333333339355406666666670B02841333333B33F0258413333333333935540', 'BATIMENT0000000314350149', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 82.3, 86.3, 88.2, 83.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A999999E0A72841000000A09F0158413333333333F353409A999999DCA72841666666869F0158413333333333F3534033333333DFA72841333333739D0158413333333333F353409A999999E7A72841000000A09D0158413333333333F35340CDCCCCCCE5A728419A9999399F0158413333333333F3534033333333E1A72841CDCCCC2C9F0158413333333333F353409A999999E0A72841000000A09F0158413333333333F35340', 'BATIMENT0000000314346926', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:20.605+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 75.0, 79.8, 81.5, 77.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333351AA2841CDCCCC4C2802584100000000008051409A9999994BAA28419A9999392A02584166666666666651409A99999953AA2841CDCCCC8C2A0258419A99999999595140000000005BAA2841000000002902584166666666666651403333333351AA2841CDCCCC4C280258410000000000805140', 'BATIMENT0000000027743777', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 1.8, 68.2, NULL, 71.2, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000005FB228419A9999D9580358419A99999999195340333333335EB22841666666865D0358419A99999999F95240CDCCCCCC6AB22841333333935D0358416666666666E652409A9999996BB22841CDCCCCCC580358416666666666C65240000000005FB228419A9999D9580358419A99999999195340', 'BATIMENT0000000027742007', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.5, 71.9, NULL, 81.0, 73.3, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000062B2284166666626820158413333333333935840CDCCCCCC48B22841333333738201584133333333339358400000000048B22841333333738101584133333333339358403333333361B228419A9999398101584133333333339358400000000062B2284166666626820158413333333333935840', 'BATIMENT0000000314341136', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 94.6, 98.3, 101.2, 96.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000F5B128419A999959510158413333333333535B409A999999F5B12841666666A6510158413333333333535B4066666666EEB1284100000000520158413333333333535B4033333333ECB12841CDCCCC4C510158413333333333535B4000000000F4B1284166666606510158413333333333535B4000000000F5B128419A999959510158413333333333535B40', 'BATIMENT0000000314341143', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 105.0, 109.3, 111.0, 106.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC61B528419A9999592001584166666666664657403333333373B52841333333F31D01584166666666664657409A99999980B52841CDCCCC6C1F0158416666666666465740666666666EB52841666666C6210158416666666666465740CDCCCCCC61B528419A999959200158416666666666465740', 'BATIMENT0000000314341166', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.8, 90.3, 93.1, 94.5, 90.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCACB128419A9999D9330158416666666666065E409A999999AAB1284166666686330158416666666666065E4066666666B7B1284166666606320158416666666666065E409A999999B4B12841000000A0310158416666666666065E4033333333C2B128419A9999F92F0158416666666666065E4000000000C7B12841666666A6300158416666666666065E40CDCCCCCCACB128419A9999D9330158416666666666065E40', 'BATIMENT0000000314341168', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 114.4, 120.1, 121.3, 118.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A99999992B22841666666063E0158419A99999999F95B40CDCCCCCC8AB2284100000080400158419A99999999F95B409A99999979B228419A9999993F0158419A99999999F95B409A99999964B22841666666863E0158419A99999999F95B409A99999965B228419A9999393E0158419A99999999F95B40CDCCCCCC6CB22841CDCCCC0C3C0158419A99999999F95B409A99999992B22841666666063E0158419A99999999F95B40', 'BATIMENT0000000314341232', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 106.0, 111.9, 113.0, 109.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999992B22841666666063E0158416666666666E65B40CDCCCCCC6CB22841CDCCCC0C3C0158416666666666E65B409A9999996EB22841666666A63B0158416666666666E65B40333333336FB22841666666863B0158416666666666E65B409A99999994B22841000000803D0158416666666666E65B409A99999992B22841666666063E0158416666666666E65B40', 'BATIMENT0000000314341233', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.6, 106.0, 111.6, 111.8, 109.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999990CB22841000000E0570158410000000000805B406666666604B228419A999939580158410000000000805B409A99999901B228419A999939570158410000000000805B409A99999909B228419A9999D9560158410000000000805B409A9999990CB22841000000E0570158410000000000805B40', 'BATIMENT0000000314341235', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.1, 103.9, 110.0, 110.0, 105.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999992BB22841333333D382015841CDCCCCCCCC2C5940000000001DB228410000000083015841CDCCCCCCCC2C5940666666661CB22841CDCCCC4C82015841CDCCCCCCCC2C5940666666662BB228419A99991982015841CDCCCCCCCC2C59409A9999992BB22841333333D382015841CDCCCCCCCC2C5940', 'BATIMENT0000000314350129', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 95.9, 100.7, 103.5, 97.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B00000000000000EAB22841000000E0A501584166666666660658409A999999E5B22841CDCCCC6CA3015841666666666606584066666666F0B2284100000020A3015841666666666606584000000000F1B228419A999959A3015841666666666606584033333333F5B2284100000040A3015841666666666606584000000000F6B228419A9999B9A301584166666666660658409A999999F9B22841000000A0A3015841666666666606584033333333FCB228419A999919A5015841666666666606584066666666F4B2284133333353A50158416666666666065840CDCCCCCCF4B22841CDCCCC8CA5015841666666666606584000000000EAB22841000000E0A50158416666666666065840', 'BATIMENT0000000314350157', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.5, 87.6, 96.1, 96.1, 89.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000033333333E8B22841333333B3A601584166666666660658409A999999E9B22841CDCCCC6CA7015841666666666606584066666666EDB2284133333353A70158416666666666065840CDCCCCCCEFB22841CDCCCCACA8015841666666666606584066666666DCB228419A999939A9015841666666666606584000000000DAB22841CDCCCCECA7015841666666666606584033333333D9B22841333333F3A701584166666666660658409A999999D7B22841CDCCCC2CA701584166666666660658409A999999DBB22841CDCCCC0CA7015841666666666606584033333333E8B22841333333B3A60158416666666666065840', 'BATIMENT0000000314350158', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.5, 87.6, 96.1, 96.3, 88.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666642B428416666660630045841CDCCCCCCCC4C5340CDCCCCCC36B42841333333132B045841CDCCCCCCCC4C5340666666664CB42841666666462A045841CDCCCCCCCC4C53409A99999957B42841CDCCCC4C2F045841CDCCCCCCCC4C53406666666642B428416666660630045841CDCCCCCCCC4C5340', 'BATIMENT0000000314327576', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:00:31.396+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 73.0, 77.2, 80.2, 73.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A99999920AB2841CDCCCC8C590358419A999999995951400000000021AB2841000000005A0358419A999999995951409A9999992EAB2841000000C0590358419A99999999595140CDCCCCCC30AB2841000000A05B0358419A999999995951406666666612AB2841CDCCCC2C5C0358419A999999995951409A9999990EAB28419A9999B9580358419A99999999595140333333331FAB284166666666580358419A999999995951409A99999920AB2841CDCCCC8C590358419A99999999595140', 'BATIMENT0000000314341027', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.4, 66.0, 69.4, 71.9, 66.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999928AD2841000000E0810458419A99999999994D409A9999992AAD284166666626850458419A99999999994D403333333320AD284166666666850458419A99999999994D406666666620AD2841333333D3840458419A99999999994D40666666661EAD284133333313820458419A99999999994D409A99999928AD2841000000E0810458419A99999999994D40', 'BATIMENT0000000314350202', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:33:05.473+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.3, 53.9, 59.2, 61.3, 54.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC88AA2841CDCCCC0C150258419A99999999795140666666669AAA28419A999999150258419A999999997951409A9999999DAA284166666666140258419A99999999795140666666668BAA2841666666E6130258419A99999999795140CDCCCCCC88AA2841CDCCCC0C150258419A99999999795140', 'BATIMENT0000000027743824', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.5, 67.4, NULL, 70.4, 67.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333377AB2841333333937E015841CDCCCCCCCCAC5340333333337DAB2841CDCCCC8C7E015841CDCCCCCCCCAC5340333333337DAB2841666666C67E015841CDCCCCCCCCAC53403333333377AB2841666666C67E015841CDCCCCCCCCAC53403333333377AB2841333333937E015841CDCCCCCCCCAC5340', 'BATIMENT0000000314347344', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 75.0, 78.7, 79.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA9AB284100000000940158413333333333335340CDCCCCCCA2AB28416666660694015841333333333333534033333333A2AB28410000004093015841333333333333534066666666A9AB28419A999939930158413333333333335340CDCCCCCCA9AB284100000000940158413333333333335340', 'BATIMENT0000000314348299', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.8, 74.0, 76.8, 77.2, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333335CAD2841666666469F0158419A99999999F95340666666665BAD2841333333B3A00158419A99999999F95340CDCCCCCC4EAD2841CDCCCCECA00158419A99999999F95340666666664DAD2841333333939F0158419A99999999F95340333333335CAD2841666666469F0158419A99999999F95340', 'BATIMENT0000000314348472', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.1, 73.8, 79.9, 80.8, 73.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999A4AC2841666666E68F015841CDCCCCCCCCEC5340CDCCCCCCA5AC28410000008090015841CDCCCCCCCCEC5340333333339DAC2841333333B390015841CDCCCCCCCCEC5340333333339CAC28410000002090015841CDCCCCCCCCEC53409A999999A4AC2841666666E68F015841CDCCCCCCCCEC5340', 'BATIMENT0000000314349084', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 74.9, 79.7, 80.3, 74.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666666BAC2841CDCCCC6C8B0158413333333333335440CDCCCCCC75AC2841666666068B0158413333333333335440CDCCCCCC79AC28419A9999798C0158413333333333335440CDCCCCCC6FAC2841333333D38C0158413333333333335440CDCCCCCC6BAC2841333333938B0158413333333333335440666666666BAC2841CDCCCC6C8B0158413333333333335440', 'BATIMENT0000000314349124', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.8, 75.0, 80.8, 81.1, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666665FAB284166666686970158416666666666A65340CDCCCCCC5FAB2841333333F3960158416666666666A653400000000066AB2841CDCCCC0C970158416666666666A653400000000066AB28419A999999970158416666666666A65340666666665FAB284166666686970158416666666666A65340', 'BATIMENT0000000314349302', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.1, 72.5, 78.6, 79.8, 73.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000089AD28419A9999B9DD01584100000000000053400000000085AD2841CDCCCC4CDF01584100000000000053403333333382AD284133333333DF01584100000000000053403333333386AD28419A999999DD01584100000000000053400000000089AD28419A9999B9DD0158410000000000005340', 'BATIMENT0000000314349735', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 70.9, 76.0, 76.2, 72.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666623AC284100000020320258410000000000C05240CDCCCCCC29AC284100000060320258410000000000C052400000000028AC284133333313330258410000000000C052409A99999921AC2841333333D3320258410000000000C052406666666623AC284100000020320258410000000000C05240', 'BATIMENT0000000314348673', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.1, 72.9, 75.0, 75.0, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999998AD2841333333D39E015841CDCCCCCCCC0C5440CDCCCCCCA0AD2841CDCCCCAC9E015841CDCCCCCCCC0C544066666666A4AD2841CDCCCC4CA1015841CDCCCCCCCC0C5440666666669AAD284166666686A1015841CDCCCCCCCC0C54406666666696AD2841000000E09E015841CDCCCCCCCC0C54409A99999998AD2841333333D39E015841CDCCCCCCCC0C5440', 'BATIMENT0000000314348953', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.3, 74.9, 80.2, 81.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999996FAB284166666626800258410000000000A052406666666667AB28419A9999D9810258410000000000A052403333333362AB28419A999979810258410000000000A05240333333336AAB2841CDCCCCCC7F0258410000000000A052409A9999996FAB284166666626800258410000000000A05240', 'BATIMENT0000000314340999', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 70.6, 74.5, 74.5, 71.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333354AA2841CDCCCC4CAE0258413333333333B351400000000053AA284133333353AF0258413333333333B35140CDCCCCCC4AAA284133333333AF0258413333333333B351406666666647AA284100000020AF0258413333333333B35140CDCCCCCC48AA28419A999919AE0258413333333333B351403333333354AA2841CDCCCC4CAE0258413333333333B35140', 'BATIMENT0000000314340991', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:56.738+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.8, 64.0, 70.8, 71.5, 64.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC6DA728419A999979720258413333333333535240333333337AA728419A9999D9700258419A999999997952403333333386A72841000000C0710258413333333333535240333333337FA72841666666E67202584133333333335352406666666684A72841CDCCCCAC7302584133333333335352406666666680A728419A999959740258413333333333535240CDCCCCCC6DA728419A999979720258413333333333535240', 'BATIMENT0000000027743933', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.9, 71.0, NULL, 73.9, 71.0, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333FEAC2841666666E64E0258419A99999999D9544066666666F7AC28419A999979500258419A99999999D9544033333333F0AC284166666606500258419A99999999D95440CDCCCCCCF6AC2841000000804E0258419A99999999D9544033333333FEAC2841666666E64E0258419A99999999D95440', 'BATIMENT0000000314348626', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 79.2, 83.4, 84.3, 79.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333E3AC28416666664657025841CDCCCCCCCC6C544000000000E4AC2841000000C057025841CDCCCCCCCC6C544000000000E1AC2841666666A658025841CDCCCCCCCC6C54409A999999DBAC28410000006058025841CDCCCCCCCC6C544066666666DFAC28413333331357025841CDCCCCCCCC6C544033333333E3AC28416666664657025841CDCCCCCCCC6C5440', 'BATIMENT0000000314349615', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 78.0, 81.7, 83.0, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999A3AD28419A99991901FF5741000000000020564033333333B1AD2841000000C000FF5741000000000020564000000000AEAD28419A9999F9FCFE57413333333333135640333333339EAD28419A999939FDFE57419A9999999919564000000000A1AD2841CDCCCC4CFFFE57419A999999991956409A999999A3AD28419A99991901FF57410000000000205640', 'BATIMENT0000000027749969', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 2.4, 86.1, NULL, 89.2, 86.8, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000333333339BB02841CDCCCC0C480258419A99999999B95540333333339AB028419A999919420258419A99999999B955409A99999985B02841CDCCCC2C420258419A99999999B955400000000087B0284166666626480258419A99999999B955400000000087B0284133333373480258419A99999999B95540333333339BB0284166666666480258419A99999999B95540333333339BB02841CDCCCC0C480258419A99999999B95540', 'BATIMENT0000000314350150', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:32:17.321+02', '2018-07-03 06:49:09.898+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 82.1, 86.9, 87.4, 82.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000008000000CDCCCCCC15AD2841CDCCCC8C2F0258410000000000C054403333333314AD2841333333732F0258410000000000C05440CDCCCCCC18AD2841666666062E0258410000000000C054400000000030AD2841000000202F0258410000000000C05440333333332EAD2841333333B32F0258410000000000C05440666666661CAD2841333333D32E0258410000000000C054409A99999919AD2841000000C02F0258410000000000C05440CDCCCCCC15AD2841CDCCCC8C2F0258410000000000C05440', 'BATIMENT0000000314348630', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.3, 78.7, 83.0, 83.7, 79.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333FBB02841CDCCCC8C2E025841CDCCCCCCCC4C5640CDCCCCCCFFB02841CDCCCC4C30025841CDCCCCCCCC4C56409A999999EDB02841000000E030025841CDCCCCCCCC4C5640CDCCCCCCEAB028419A9999392E025841CDCCCCCCCC4C564000000000F4B02841000000202E025841CDCCCCCCCC4C564066666666F5B02841CDCCCCAC2E025841CDCCCCCCCC4C564033333333FBB02841CDCCCC8C2E025841CDCCCCCCCC4C5640', 'BATIMENT0000000027743691', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.4, 85.8, NULL, 89.3, 85.9, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000017B12841CDCCCC8C200258410000000000805740CDCCCCCC11B12841CDCCCCAC200258410000000000805740CDCCCCCC0DB12841000000A01E0258410000000000805740CDCCCCCC10B12841000000801E02584100000000008057403333333313B12841CDCCCC6C1E02584100000000008057400000000017B12841CDCCCC8C200258410000000000805740', 'BATIMENT0000000314350018', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.0, 86.0, 94.0, 94.3, 87.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000003333333356B12841000000C0290258413333333333F356403333333350B128419A9999F9290258413333333333F35640666666664DB12841666666A6280258413333333333F35640000000004FB1284133333393280258413333333333F356409A99999953B128419A999979280258413333333333F356403333333356B12841000000C0290258413333333333F35640', 'BATIMENT0000000314350033', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.8, 86.0, 91.8, 92.9, 86.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A000000000000005CB22841000000605E035841CDCCCCCCCCCC5240CDCCCCCC5CB22841333333B35F0358413333333333B35240333333335EB22841333333136203584166666666668652403333333306B22841666666E66203584166666666666652400000000004B228419A9999F9600358410000000000C052409A999999F6B128410000000061035841CDCCCCCCCC8C52409A999999F5B12841666666C65F0358416666666666665240CDCCCCCC0BB22841666666A65F0358419A99999999B95240000000000CB228419A9999195F0358416666666666865240000000005CB22841000000605E035841CDCCCCCCCCCC5240', 'BATIMENT0000000027742004', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.1, 71.1, NULL, 75.8, 72.2, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000666666660DB02841666666E600015841CDCCCCCCCCEC5A403333333316B028419A99995900015841CDCCCCCCCCEC5A40CDCCCCCC18B02841666666E600015841CDCCCCCCCCEC5A40CDCCCCCC1EB028410000008000015841CDCCCCCCCCEC5A400000000022B028416666662601015841CDCCCCCCCCEC5A40000000001BB02841666666A601015841CDCCCCCCCCEC5A40666666660DB02841666666E600015841CDCCCCCCCCEC5A40', 'BATIMENT0000000314347508', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.3, 101.4, 107.7, 108.0, 101.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000E0000009A999999A2AE284133333313A60158413333333333B35440666666669BAE284133333313AC0158413333333333B354400000000098AE2841CDCCCC4CAF0158413333333333B35440CDCCCCCC97AE2841000000A0AF0158413333333333B354406666666683AE2841666666E6AE0158413333333333B35440000000006EAE284100000020AE0158413333333333B354406666666670AE2841333333F3AC0158413333333333B354403333333371AE28419A999999AC0158413333333333B35440333333338CAE28419A999979AD0158413333333333B35440CDCCCCCC91AE284166666686A80158413333333333B354403333333395AE28419A999999A80158413333333333B35440000000009AAE2841666666E6A60158413333333333B35440CDCCCCCC9AAE2841000000E0A50158413333333333B354409A999999A2AE284133333313A60158413333333333B35440', 'BATIMENT0000000314348482', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.8, 75.0, 82.8, 83.8, 77.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000009A999999A4AE2841333333B3A30158410000000000C0544033333333BBAE28419A999939A40158410000000000C0544033333333B3AE284133333393AB0158410000000000C0544000000000B1AE28419A999999AD0158410000000000C0544000000000AFAE28419A999979AD0158410000000000C0544033333333A5AE2841666666C6AC0158410000000000C05440666666669BAE284133333313AC0158410000000000C054409A999999A2AE284133333313A60158410000000000C054409A999999A4AE2841333333B3A30158410000000000C05440', 'BATIMENT0000000314348484', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.0, 75.0, 83.0, 84.9, 78.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC02AF28419A9999190701584166666666664657406666666602AF28410000004008015841666666666646574066666666FAAE28413333331308015841666666666646574033333333FBAE284100000000070158416666666666465740CDCCCCCC02AF28419A999919070158416666666666465740', 'BATIMENT0000000314347594', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 87.2, 93.1, 95.0, 89.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC51AF28419A999999B40158413333333333D354406666666643AF28419A999939B40158413333333333D354403333333344AF2841CDCCCCECB20158413333333333D354403333333352AF2841CDCCCC4CB30158413333333333D35440CDCCCCCC51AF28419A999999B40158413333333333D35440', 'BATIMENT0000000314349251', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.8, 77.5, 83.3, 83.5, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333ECB028419A999999970158419A9999999939574033333333DDB0284166666686970158419A9999999939574033333333DDB02841333333F3960158419A999999993957409A999999ECB02841CDCCCC0C970158419A9999999939574033333333ECB028419A999999970158419A99999999395740', 'BATIMENT0000000314350133', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:32:17.321+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.5, 85.4, 92.9, 93.7, 87.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999926B128419A999979EB005841CDCCCCCCCC8C5B400000000021B12841CDCCCC2CED005841CDCCCCCCCC8C5B409A9999991AB12841666666C6EC005841CDCCCCCCCC8C5B40CDCCCCCC20B1284100000020EB005841CDCCCCCCCC8C5B409A99999926B128419A999979EB005841CDCCCCCCCC8C5B40', 'BATIMENT0000000314341200', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.0, 107.2, 110.2, 110.3, 108.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCCBDAD284100000080C4005841000000000080594066666666BFAD284100000040C5005841000000000080594033333333D0AD2841000000C0C40058410000000000805940CDCCCCCCCEAD284133333313C400584100000000008059409A999999CBAD2841000000A0C20058410000000000805940CDCCCCCCBAAD284100000020C30058410000000000805940CDCCCCCCBDAD284100000080C40058410000000000805940', 'BATIMENT0000000314347494', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2020-05-29 12:14:55.52+02', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.8, 98.2, 102.0, 102.8, 98.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666617AF2841333333F3E60058419A99999999D95740CDCCCCCC17AF284100000040E50058410000000000E057409A99999901AF284166666626E50058410000000000E057403333333301AF2841000000C0E60058410000000000E057406666666617AF2841333333F3E60058419A99999999D95740', 'BATIMENT0000000027747465', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 3.5, 92.0, NULL, 99.7, 92.6, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC28B12841333333D3E60058410000000000005C400000000027B12841CDCCCC8CE60058410000000000005C40000000002EB12841000000C0E50058410000000000005C403333333332B1284133333353E60058410000000000005C40333333332BB128419A999919E70058410000000000005C40CDCCCCCC28B12841333333D3E60058410000000000005C40', 'BATIMENT0000000314341202', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:11:38.554+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.9, 109.1, 112.0, 113.5, 109.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000006666666618B0284100000000050158416666666666C65A409A9999991BB028419A9999F9030158416666666666C65A409A99999918B02841333333D3030158416666666666C65A40666666661AB0284166666626030158416666666666C65A409A9999991CB0284100000020030158416666666666C65A409A99999921B02841000000A0030158416666666666C65A40333333331DB028419A999939050158416666666666C65A406666666618B0284100000000050158416666666666C65A40', 'BATIMENT0000000314347507', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.7, 101.4, 107.1, 109.2, 101.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000008BAD2841000000E0EA0058413333333333335940CDCCCCCC8EAD2841CDCCCCACEC0058413333333333335940CDCCCCCC87AD2841CDCCCCECEC00584133333333333359400000000084AD28419A999919EB0058413333333333335940000000008BAD2841000000E0EA0058413333333333335940', 'BATIMENT0000000314347640', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 95.8, 100.8, 101.0, 96.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC9FB328419A999979400058416666666666A65F40CDCCCCCC91B328419A9999193F005841CDCCCCCCCCAC5F400000000096B32841666666863E005841CDCCCCCCCCAC5F40CDCCCCCC9AB32841666666A63E005841CDCCCCCCCCAC5F409A999999A1B328419A9999393E005841CDCCCCCCCCAC5F4000000000AAB32841666666063F005841CDCCCCCCCCAC5F40CDCCCCCC9FB328419A999979400058416666666666A65F40', 'BATIMENT0000000027747452', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDTopo', 2.5, 'BDTopo', 1.5, NULL, NULL, NULL, NULL, 1.6, 125.1, NULL, 127.8, 126.4, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000D00000033333333D1B12841CDCCCCECF70058419A99999999595E4033333333DAB128419A9999B9F80058419A99999999595E409A999999D2B1284166666626FA0058419A99999999595E40CDCCCCCCD4B1284166666666FA0058419A99999999595E4066666666D0B1284166666646FB0058419A99999999595E4033333333D5B128419A9999B9FB0058419A99999999595E40CDCCCCCCCEB1284100000000FD0058419A99999999595E4066666666C7B1284133333373FC0058419A99999999595E4000000000CBB128419A9999B9FB0058419A99999999595E4066666666B3B12841000000C0F90058419A99999999595E40CDCCCCCCBAB1284100000040F80058419A99999999595E4033333333C9B1284133333393F90058419A99999999595E4033333333D1B12841CDCCCCECF70058419A99999999595E40', 'BATIMENT0000000314341194', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:11:38.554+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 117.3, 121.4, 123.8, 118.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000000000000005AF2841000000A0E601584166666666662654409A99999904AF2841CDCCCC0CE8015841666666666626544033333333F1AE2841CDCCCC0CE8015841666666666626544000000000F5AE28419A9999B9E601584166666666662654400000000005AF2841000000A0E60158416666666666265440', 'BATIMENT0000000314348809', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 77.9, 80.6, 80.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000C3AE284166666686DB015841CDCCCCCCCC2C544066666666D8AE284133333333DB015841CDCCCCCCCC2C54409A999999D9AE2841CDCCCC8CDC015841CDCCCCCCCC2C5440CDCCCCCCC3AE2841000000C0DC015841CDCCCCCCCC2C544000000000C3AE284166666686DB015841CDCCCCCCCC2C5440', 'BATIMENT0000000314348883', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 76.7, 80.7, 81.7, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999EBAF2841666666A6B60158419A9999999919554033333333F1AF28419A999959B60158419A999999991955409A999999FAAF28419A9999B9B80158419A999999991955409A999999F4AF284166666626B90158419A999999991955409A999999EBAF2841666666A6B60158419A99999999195540', 'BATIMENT0000000314348918', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 80.2, 84.4, 84.5, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999D1AE2841666666A69B015841666666666666554033333333CFAE2841666666E69D01584166666666666655409A999999C4AE2841CDCCCCAC9D015841666666666666554033333333BFAE2841CDCCCC8C9D0158416666666666665540CDCCCCCCBBAE28419A9999799D015841666666666666554066666666BDAE2841666666C69B0158416666666666665540CDCCCCCCBDAE2841666666469B01584166666666666655409A999999D1AE2841666666A69B0158416666666666665540', 'BATIMENT0000000314349038', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.4, 78.2, 85.6, 86.8, 79.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC8CAF2841CDCCCCECB20158410000000000005540666666668CAF284100000080B301584100000000000055409A9999997DAF28419A999959B30158410000000000005540666666667EAF284133333393B10158410000000000005540666666668DAF28419A9999B9B10158410000000000005540CDCCCCCC8CAF2841CDCCCCECB20158410000000000005540', 'BATIMENT0000000314349104', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.1, 79.9, 84.0, 84.6, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A9999995FAF2841CDCCCCACB3015841CDCCCCCCCCEC54403333333352AF2841CDCCCC4CB3015841CDCCCCCCCCEC54403333333344AF2841CDCCCCECB2015841CDCCCCCCCCEC54400000000041AF2841333333D3B2015841CDCCCCCCCCEC5440CDCCCCCC43AF284100000020B1015841CDCCCCCCCCEC54409A99999960AF284100000000B2015841CDCCCCCCCCEC54409A9999995FAF2841CDCCCCACB3015841CDCCCCCCCCEC5440', 'BATIMENT0000000314349252', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.9, 77.8, 83.7, 84.9, 78.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000033333333B7AE28419A9999B9970158419A99999999D9544000000000C1AE2841000000E0970158419A99999999D9544000000000C0AE28419A9999F9980158419A99999999D95440CDCCCCCCBFAE284166666626990158419A99999999D9544000000000B6AE284166666606990158419A99999999D9544033333333B7AE28419A9999B9970158419A99999999D95440', 'BATIMENT0000000314349322', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.7, 79.7, 83.4, 83.4, 80.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000800000033333333C7AE284100000060D101584166666666666654409A999999C1AE28419A999979D1015841666666666666544066666666C0AE2841CDCCCCACD0015841666666666666544066666666B6AE2841000000E0D0015841666666666666544000000000B6AE2841CDCCCC6CD0015841666666666666544000000000B8AE284166666666D001584166666666666654409A999999C5AE284166666626D0015841666666666666544033333333C7AE284100000060D10158416666666666665440', 'BATIMENT0000000314349470', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.5, 75.1, 81.6, 81.9, 75.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCCEAD2841333333F3E101584133333333331353409A999999C0AD284166666666E1015841333333333313534000000000C1AD2841CDCCCC0CE101584133333333331353409A999999CFAD2841666666A6E10158413333333333135340CDCCCCCCCEAD2841333333F3E10158413333333333135340', 'BATIMENT0000000314349612', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 71.6, 76.3, 76.4, 73.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000006666666638AE2841333333B3BE0158410000000000A053403333333338AE2841CDCCCC4CBD0158410000000000A05340000000004DAE284100000020BD0158410000000000A05340000000004DAE2841000000A0BD0158410000000000A05340000000004DAE284166666686BE0158410000000000A053406666666638AE2841333333B3BE0158410000000000A05340', 'BATIMENT0000000314349580', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.6, 74.9, 78.5, 78.6, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000033333333BCAE2841333333337E0158419A99999999195640CDCCCCCCC2AE2841000000407D0158419A99999999195640CDCCCCCCC5AE2841CDCCCC8C7D0158419A9999999919564033333333CFAE2841CDCCCC6C7E0158419A999999991956409A999999C9AE2841000000607F0158419A99999999195640CDCCCCCCC1AE2841333333B37E0158419A9999999919564033333333BCAE2841333333337E0158419A99999999195640', 'BATIMENT0000000314347190', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.1, 80.3, 88.4, 89.3, 81.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC0BAE2841CDCCCC2CF4015841CDCCCCCCCCAC5340666666660DAE284133333393F5015841CDCCCCCCCCAC5340000000000AAE28419A999999F5015841CDCCCCCCCCAC53409A99999908AE284133333333F4015841CDCCCCCCCCAC5340CDCCCCCC0BAE2841CDCCCC2CF4015841CDCCCCCCCCAC5340', 'BATIMENT0000000314349688', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.5, 74.2, 78.7, 79.4, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999DAAD284100000040CE015841333333333373534066666666D7AD2841CDCCCC4CCE01584133333333337353409A999999D6AD2841CDCCCC8CCD0158413333333333735340CDCCCCCCD9AD284100000080CD01584133333333337353409A999999DAAD284100000040CE0158413333333333735340', 'BATIMENT0000000314349805', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 72.8, 77.8, 78.0, 72.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000099AD2841333333735501584166666666666655409A9999999DAD2841000000C054015841666666666666554000000000AEAD28413333337356015841666666666666554033333333ADAD2841666666A6560158416666666666665540CDCCCCCC9AAD2841333333D35501584166666666666655400000000099AD284133333373550158416666666666665540', 'BATIMENT0000000314347205', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.6, 78.0, 85.6, 86.5, 79.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A99999923AD284100000080770158419A99999999B954409A99999932AD2841666666A6780158419A99999999B954409A9999992DAD28419A999979790158419A99999999B954400000000027AD284133333313790158419A99999999B954400000000020AD2841666666A6780158419A99999999B954409A99999923AD284100000080770158419A99999999B95440', 'BATIMENT0000000314347146', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.8, 75.1, 82.9, 82.9, 76.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000033333333FDAC28419A999939820158410000000000A054409A999999E1AC2841666666A6840158410000000000A05440CDCCCCCCD7AC2841666666A6820158410000000000A05440CDCCCCCCDDAC2841CDCCCC2C820158410000000000A054409A999999DCAC284133333393800158410000000000A05440CDCCCCCCDBAC2841666666C67F0158410000000000A0544066666666F8AC2841CDCCCC2C800158410000000000A0544066666666F8AC28419A9999F9800158410000000000A054409A999999F9AC2841CDCCCC8C810158410000000000A0544033333333FDAC28419A999939820158410000000000A05440', 'BATIMENT0000000314347148', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.4, 75.1, 82.5, 85.0, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000003333333321AE28416666668652015841CDCCCCCCCCAC5540CDCCCCCC0EAE28419A99999951015841CDCCCCCCCCAC55406666666613AE28413333331350015841CDCCCCCCCCAC55400000000026AE28419A9999F950015841CDCCCCCCCCAC55403333333321AE28416666668652015841CDCCCCCCCCAC5540', 'BATIMENT0000000314347199', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.7, 79.0, 86.7, 86.8, 81.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999E7AE28410000006071015841CDCCCCCCCC8C554000000000E9AE28410000008071015841CDCCCCCCCC8C5540CDCCCCCCE0AE2841666666E672015841CDCCCCCCCC8C554000000000DAAE28416666664672015841CDCCCCCCCC8C554066666666E2AE2841CDCCCCEC70015841CDCCCCCCCC8C55409A999999E7AE28410000006071015841CDCCCCCCCC8C5540', 'BATIMENT0000000314347230', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 82.3, 86.2, 86.6, 82.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000009A999999E2AE2841666666E6750158419A99999999D95540CDCCCCCCD2AE2841333333B3740158419A99999999D95540CDCCCCCCD2AE284133333373730158419A99999999D9554000000000DAAE284166666646720158419A99999999D95540CDCCCCCCE0AE2841666666E6720158419A99999999D9554066666666EEAE284100000020740158419A99999999D955409A999999E2AE2841666666E6750158419A99999999D95540', 'BATIMENT0000000314347231', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 82.3, 87.4, 88.0, 82.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000009A999999E6AE284100000060650158419A99999999195640CDCCCCCCDEAE2841666666C6660158419A99999999195640CDCCCCCCD1AE284100000080650158419A9999999919564000000000DBAE28419A999919640158419A9999999919564033333333E2AE2841666666E6640158419A999999991956409A999999E6AE284100000060650158419A99999999195640', 'BATIMENT0000000314347242', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.8, 81.6, 88.4, 88.8, 82.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000B00000066666666DDAE28419A9999995E015841666666666666564000000000ECAE2841CDCCCC2C6001584166666666666656409A999999EFAE28413333339360015841666666666666564033333333EAAE2841333333536101584166666666666656409A999999F3AE28410000006062015841666666666666564066666666EDAE28410000004063015841666666666666564000000000E4AE28413333333362015841666666666666564000000000DDAE2841CDCCCC6C61015841666666666666564066666666E2AE28419A99999960015841666666666666564000000000D8AE2841000000605F015841666666666666564066666666DDAE28419A9999995E0158416666666666665640', 'BATIMENT0000000314347245', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 8.0, 81.6, 89.6, 90.1, 82.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC71AE2841000000007801584133333333333355406666666669AE28419A999999790158413333333333335540CDCCCCCC63AE28419A999919790158413333333333335540666666666CAE284133333393770158413333333333335540CDCCCCCC71AE284100000000780158413333333333335540', 'BATIMENT0000000314347312', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 79.8, 84.8, 86.5, 79.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333339AAE2841000000607A015841CDCCCCCCCC2C55400000000096AE2841000000207B015841CDCCCCCCCC2C55409A99999991AE2841666666C67A015841CDCCCCCCCC2C55400000000096AE2841666666067A015841CDCCCCCCCC2C5540333333339AAE2841000000607A015841CDCCCCCCCC2C5540', 'BATIMENT0000000314347319', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 80.7, 84.7, 85.1, 81.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000666666666DAE2841000000E071015841CDCCCCCCCC8C55400000000081AE2841CDCCCC8C73015841CDCCCCCCCC8C5540666666667AAE28419A9999D974015841CDCCCCCCCC8C55409A99999966AE28413333333373015841CDCCCCCCCC8C5540CDCCCCCC67AE28419A9999F972015841CDCCCCCCCC8C5540666666666DAE2841000000E071015841CDCCCCCCCC8C5540', 'BATIMENT0000000314347300', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 6.4, 79.8, 86.2, 87.0, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000333333335DAD2841CDCCCC4C210158416666666666265740CDCCCCCC60AD28419A9999F91E01584166666666662657406666666671AD2841000000601F0158416666666666265740CDCCCCCC6DAD2841333333F32101584166666666662657409A99999960AD2841666666A62101584166666666662657400000000061AD28419A999959210158416666666666265740333333335DAD2841CDCCCC4C210158416666666666265740', 'BATIMENT0000000314347478', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.6, 89.0, 92.6, 93.5, 90.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000070000006666666603AE28419A999959780158416666666666C65440CDCCCCCC08AE284100000020770158416666666666C654406666666616AE284133333313780158416666666666C654406666666619AE2841CDCCCC4C780158416666666666C654403333333317AE2841000000C0780158416666666666C654403333333313AE2841CDCCCC8C790158416666666666C654406666666603AE28419A999959780158416666666666C65440', 'BATIMENT0000000314347385', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.1, 78.0, 83.1, 84.4, 78.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC52AE284166666606280158413333333333D356409A9999994AAE2841333333F3270158413333333333D35640000000004CAE284166666606270158413333333333D35640CDCCCCCC4CAE284133333373260158413333333333D35640CDCCCCCC54AE2841000000A0260158413333333333D35640CDCCCCCC52AE284166666606280158413333333333D35640', 'BATIMENT0000000314347591', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 86.3, 91.3, 93.4, 86.9, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000066666666CFAC284100000040430158413333333333B35440CDCCCCCCCFAC2841CDCCCC0C450158413333333333B3544066666666CAAC2841CDCCCC0C450158413333333333B3544066666666CAAC2841CDCCCC4C430158413333333333B3544066666666CFAC284100000040430158413333333333B35440', 'BATIMENT0000000314347604', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 77.9, 82.8, 83.9, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000066666666CDAC284166666606470158413333333333B354409A999999CFAC284100000000470158413333333333B3544066666666DBAC284166666606470158413333333333B354409A999999DBAC2841000000A0480158413333333333B3544066666666E4AC28419A999999480158413333333333B35440CDCCCCCCE4AC2841333333B3490158413333333333B354409A999999DBAC2841333333B3490158413333333333B3544066666666DBAC2841CDCCCC6C4A0158413333333333B35440CDCCCCCCCDAC2841666666864A0158413333333333B3544066666666CDAC284166666606470158413333333333B35440', 'BATIMENT0000000314347605', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 77.9, 82.8, 84.3, 79.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000009A999999EDAE2841CDCCCC6C8C0158419A999999997955403333333306AF2841333333938C01584166666666666655409A99999906AF2841000000C08B015841CDCCCCCCCC6C55403333333307AF2841000000A089015841CDCCCCCCCC6C554066666666FAAE28410000006089015841CDCCCCCCCC6C554000000000F9AE2841CDCCCC4C8A015841CDCCCCCCCC6C554000000000EEAE2841333333338A01584100000000008055409A999999EDAE2841CDCCCC6C8C0158419A99999999795540', 'BATIMENT0000000206309805', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2008-09-25 16:47:29.261+02', '2018-02-20 14:11:41.158+01', NULL, '2006-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.6, 81.4, NULL, 86.3, NULL, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000900000033333333E5AE2841666666C68401584166666666664655409A999999E5AE28416666664686015841666666666646554000000000E6AE284100000020870158416666666666465540CDCCCCCCD6AE2841333333338701584166666666664655409A999999D3AE2841CDCCCC2C87015841666666666646554066666666D3AE28410000006086015841666666666646554033333333DFAE2841CDCCCC4C86015841666666666646554033333333DFAE2841CDCCCCCC84015841666666666646554033333333E5AE2841666666C6840158416666666666465540', 'BATIMENT0000000314348390', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.0, 81.1, 85.1, 86.3, 81.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666648AA284133333333DA0158416666666666A65240666666663FAA2841666666A6DA0158416666666666A65240666666663CAA2841CDCCCCACD90158416666666666A652400000000045AA284100000040D90158416666666666A652406666666648AA284133333333DA0158416666666666A65240', 'BATIMENT0000000314348726', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.6, 72.0, 74.6, 75.7, 72.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000333333337FAE2841666666A6510058419A99999999D95B409A99999968AE2841CDCCCCEC500058419A99999999D95B409A9999996DAE2841000000604E0058413333333333D35B406666666684AE2841000000404F0058413333333333D35B40333333337FAE2841666666A6510058419A99999999D95B40', 'BATIMENT0000000027747472', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.4, 108.0, NULL, 114.2, 108.4, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000666666665BAE2841333333134E0058410000000000605B400000000056AE284133333373500058416666666666865B409A99999942AE2841333333D34F0058416666666666865B409A99999947AE2841666666464D0058416666666666865B40666666665BAE2841333333134E0058410000000000605B40', 'BATIMENT0000000304467838', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2012-06-28 10:22:19.379+02', '2017-01-31 21:26:19.973+01', NULL, '2010-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.3, 105.8, NULL, 113.2, 107.2, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCC1BAB28419A9999D9B701584166666666668653403333333319AB2841CDCCCCCCB70158416666666666865340CDCCCCCC1AAB2841666666A6B501584166666666668653400000000044AB28419A999959B601584166666666668653403333333342AB2841CDCCCC8CB80158416666666666865340CDCCCCCC1BAB28419A9999D9B70158416666666666865340', 'BATIMENT0000000314349567', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.4, 72.7, 78.1, 80.0, 72.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333CDAB2841000000A0F8015841CDCCCCCCCC6C524033333333D6AB2841000000E0F8015841CDCCCCCCCC6C524000000000D5AB2841666666A6F9015841CDCCCCCCCC6C524000000000CCAB2841CDCCCC6CF9015841CDCCCCCCCC6C524033333333CDAB2841000000A0F8015841CDCCCCCCCC6C5240', 'BATIMENT0000000314348747', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 71.0, 73.7, 73.9, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000003EB628413333331390035841CDCCCCCCCCEC51400000000046B62841666666C690035841CDCCCCCCCCEC51409A9999994FB62841000000A08E035841CDCCCCCCCCEC51406666666646B62841333333138E035841CDCCCCCCCCEC5140000000003EB628413333331390035841CDCCCCCCCCEC5140', 'BATIMENT0000000206309582', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2008-09-25 16:47:29.261+02', '2017-01-31 21:26:19.973+01', NULL, '2006-07-01', NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 3.7, 68.0, NULL, 72.2, 69.7, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC59AC28419A9999D9E90158416666666666665240000000005EAC284166666646EA01584166666666666652403333333352AC2841CDCCCCECEB0158416666666666665240333333334EAC284166666666EB0158416666666666665240CDCCCCCC59AC28419A9999D9E90158416666666666665240', 'BATIMENT0000000314348708', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.6, 72.0, 73.6, 73.8, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000090000006666666658AB284166666646CE01584133333333339352403333333352AB284166666626CE01584133333333339352409A99999953AB284100000000CD01584133333333339352406666666646AB28419A9999B9CC01584133333333339352406666666649AB284133333313CA0158413333333333935240CDCCCCCC4FAB284133333333CA01584133333333339352409A99999953AB2841000000C0CA0158413333333333935240CDCCCCCC5BAB2841CDCCCCECCA01584133333333339352406666666658AB284166666646CE0158413333333333935240', 'BATIMENT0000000314349722', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 70.1, 74.3, 78.0, 71.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000700000066666666DEB428419A999939C40158419A99999999595540CDCCCCCCEBB42841666666E6C30158410000000000605540CDCCCCCCEAB42841CDCCCCCCC2015841666666666666554066666666DEB4284100000040C3015841666666666666554033333333DBB428419A999959C301584166666666666655409A999999DCB42841CDCCCC4CC4015841666666666666554066666666DEB428419A999939C40158419A99999999595540', 'BATIMENT0000000027745754', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 2.8, 82.8, NULL, 86.1, 84.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCF4B4284100000060BD015841CDCCCCCCCC2C56406666666608B5284100000060BC015841CDCCCCCCCC2C56409A99999912B5284100000060C1015841CDCCCCCCCC2C5640CDCCCCCCFEB4284166666646C2015841CDCCCCCCCC2C5640CDCCCCCCF4B4284100000060BD015841CDCCCCCCCC2C5640', 'BATIMENT0000000027745718', 'Industriel, agricole ou commercial', 'Indifférencié', NULL, false, 'En service', '2006-09-28 15:44:41.164+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'Photogrammétrie', 2.5, 'Photogrammétrie', 1.5, NULL, NULL, NULL, NULL, 4.6, 84.1, NULL, 89.0, 84.1, 'Imagerie aérienne', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666686AA28413333331349015841CDCCCCCCCCEC54406666666686AA2841666666064A015841CDCCCCCCCCEC54400000000076AA2841CDCCCC0C4A015841CDCCCCCCCCEC5440CDCCCCCC75AA28419A99991949015841CDCCCCCCCCEC54406666666686AA28413333331349015841CDCCCCCCCCEC5440', 'BATIMENT0000000314347545', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.0, 78.7, 83.7, 84.7, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666614AB28419A9999F9C001584166666666662653403333333308AB2841333333D3C00158416666666666265340CDCCCCCC09AB284100000060BE01584166666666662653403333333316AB2841CDCCCC8CBE01584166666666662653406666666614AB28419A9999F9C00158416666666666265340', 'BATIMENT0000000314349761', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 7.1, 69.5, 76.6, 77.7, 71.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCD3AA2841CDCCCC0C71015841CDCCCCCCCCAC534033333333DAAA28416666664670015841CDCCCCCCCCAC534066666666E0AA2841333333F370015841CDCCCCCCCCAC53409A999999DAAA2841000000C071015841CDCCCCCCCCAC5340CDCCCCCCD3AA2841CDCCCC0C71015841CDCCCCCCCCAC5340', 'BATIMENT0000000314347251', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.7, 76.0, 78.7, 80.5, 76.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCD5AA28419A9999995E015841000000000000544066666666CFAA2841333333D35F015841000000000000544066666666C6AA28419A99991960015841000000000000544066666666D0AA28419A9999395E0158410000000000005440CDCCCCCCD5AA28419A9999995E0158410000000000005440', 'BATIMENT0000000314347622', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.6, 74.4, 80.0, 80.7, 76.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000033333333C7A928419A999919CE0158416666666666C6524000000000C8A9284133333373CC0158416666666666C6524066666666CCA928419A999979CC0158416666666666C6524000000000CCA9284100000020CE0158416666666666C6524033333333C7A928419A999919CE0158416666666666C65240', 'BATIMENT0000000314349510', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.1, 73.0, 75.1, 76.8, 73.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000000000004DA92841CDCCCC0CA90158419A999999997953409A9999994BA9284133333313A80158419A999999997953400000000054A92841333333F3A70158419A999999997953406666666654A92841333333F3A80158419A99999999795340000000004DA92841CDCCCC0CA90158419A99999999795340', 'BATIMENT0000000314349515', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 74.0, 77.9, 78.4, 74.0, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC14AC284100000020A90158416666666666E65340CDCCCCCC11AC2841CDCCCC2CA70158416666666666E65340CDCCCCCC1AAC2841333333F3A60158416666666666E65340333333331EAC2841CDCCCCECA80158416666666666E65340CDCCCCCC14AC284100000020A90158416666666666E65340', 'BATIMENT0000000314348984', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.6, 74.0, 79.6, 80.1, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000066666666FCAC28419A999939BA0158419A999999999953409A99999914AD2841666666E6BA0158419A99999999995340CDCCCCCC11AD2841CDCCCCACBC0158419A99999999995340CDCCCCCCFEAC284166666626BC0158419A999999999953409A999999F8AC284166666606BC0158419A9999999999534066666666FCAC28419A999939BA0158419A99999999995340', 'BATIMENT0000000314349267', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 73.6, 78.4, 78.5, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A999999DEAB28419A999939B0015841333333333373534033333333DBAB28419A999939B3015841333333333373534033333333C5AB2841000000C0B201584133333333337353409A999999C8AB28419A9999B9AF01584133333333337353409A999999DEAB28419A999939B00158413333333333735340', 'BATIMENT0000000314349306', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.8, 73.0, 77.8, 80.3, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC95AB2841000000A0CD0158413333333333935240000000008EAB284100000080CD0158413333333333935240CDCCCCCC8EAB2841666666C6CC01584133333333339352409A99999996AB2841666666E6CC0158413333333333935240CDCCCCCC95AB2841000000A0CD0158413333333333935240', 'BATIMENT0000000314349646', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 69.7, 74.3, 75.3, 70.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000333333338BAB28419A999919D001584133333333339352400000000088AB284133333313D001584133333333339352403333333388AB2841666666C6CF01584133333333339352409A99999988AB284100000060CF0158413333333333935240CDCCCCCC8BAB2841CDCCCC6CCF0158413333333333935240333333338BAB28419A999919D00158413333333333935240', 'BATIMENT0000000314349647', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.6, 69.7, 74.3, 74.4, 70.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000010AD28419A9999799F0158410000000000C053409A99999901AD2841CDCCCCACA00158410000000000C05340CDCCCCCCFCAC2841000000409E0158410000000000C053409A99999901AD28419A9999D99D0158410000000000C05340CDCCCCCC0AAD28419A9999199D0158410000000000C053400000000010AD28419A9999799F0158410000000000C05340', 'BATIMENT0000000314349409', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.7, 74.3, 79.0, 81.4, 74.3, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCC99AD28419A999999D90158413333333333F352409A99999998AD2841CDCCCC0CDA0158413333333333F352409A99999986AD284100000060D90158413333333333F352409A99999987AD2841CDCCCCECD80158413333333333F35240CDCCCCCC99AD28419A999999D90158413333333333F35240', 'BATIMENT0000000314349693', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 5.2, 70.6, 75.8, 75.9, 72.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000500000000000000B7AB28419A9999B9CC015841333333333393524033333333C2AB2841000000E0CC0158413333333333935240CDCCCCCCC1AB284166666666CD015841333333333393524066666666B6AB284100000040CD015841333333333393524000000000B7AB28419A9999B9CC0158413333333333935240', 'BATIMENT0000000314349701', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 70.4, 74.3, 76.5, 70.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000600000000000000BEAB28419A999979D0015841333333333393524066666666BEAB2841CDCCCC0CD0015841333333333393524066666666C1AB284100000020D0015841333333333393524000000000C1AB2841666666C6D00158413333333333935240CDCCCCCCBDAB2841000000C0D0015841333333333393524000000000BEAB28419A999979D00158413333333333935240', 'BATIMENT0000000314349703', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 70.4, 74.3, 74.9, 70.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000006000000CDCCCCCCA9AB2841666666A6CF01584133333333339352409A999999A9AB2841666666E6CF01584133333333339352409A999999A6AB2841000000E0CF015841333333333393524033333333A7AB2841CDCCCC2CCF015841333333333393524033333333AAAB28419A999939CF0158413333333333935240CDCCCCCCA9AB2841666666A6CF0158413333333333935240', 'BATIMENT0000000314349705', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.9, 70.4, 74.3, 74.9, 70.8, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCA1AD284100000060F80158419A999999993953409A99999995AD2841000000A0F70158419A99999999395340CDCCCCCC96AD2841CDCCCC2CF70158419A999999993953409A999999A3AD2841666666E6F70158419A99999999395340CDCCCCCCA1AD284100000060F80158419A99999999395340', 'BATIMENT0000000314349728', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.1, 73.8, 76.9, 77.6, 74.4, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000006666666655AB2841666666A6500258413333333333B35240000000005CAB2841666666C6510258413333333333B352409A99999955AB284133333373520258413333333333B352409A9999994EAB284166666646510258413333333333B352406666666655AB2841666666A6500258413333333333B35240', 'BATIMENT0000000314348591', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.2, 70.6, 74.8, 75.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000060000000000000073AE28419A9999B9D101584100000000000054400000000081AE2841CDCCCC6CD101584100000000000054409A99999982AE2841666666C6D201584100000000000054403333333383AE284166666646D301584100000000000054406666666675AE2841CDCCCC8CD301584100000000000054400000000073AE28419A9999B9D10158410000000000005440', 'BATIMENT0000000314349480', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 4.9, 75.1, 80.0, 80.8, 75.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000080000003333333354AC2841666666A6E50158416666666666665240CDCCCCCC60AC2841CDCCCCECE501584166666666666652409A9999995CAC2841000000A0E601584166666666666652409A99999964AC2841CDCCCC8CE70158416666666666665240CDCCCCCC60AC2841CDCCCC2CE801584166666666666652403333333356AC284133333313E701584166666666666652409A9999995AAC284166666666E601584166666666666652403333333354AC2841666666A6E50158416666666666665240', 'BATIMENT0000000314348709', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:28:11.073+02', '2018-02-20 14:11:41.158+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 1.6, 72.0, 73.6, 74.0, NULL, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A99999922AE28419A9999190F0258419A99999999795440333333331FAE2841CDCCCCEC0E0258419A999999997954403333333323AE2841666666A60D0258419A999999997954409A99999926AE2841333333D30D0258419A999999997954409A99999922AE28419A9999190F0258419A99999999795440', 'BATIMENT0000000314349765', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.6, 78.3, 81.9, 83.4, 80.2, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000005000000CDCCCCCCB9AA28419A9999B9FB0158419A9999999959524000000000B4AA2841666666C6FB0158419A9999999959524000000000B4AA28419A999959FB0158419A999999995952409A999999B9AA284133333353FB0158419A99999999595240CDCCCCCCB9AA28419A9999B9FB0158419A99999999595240', 'BATIMENT0000000314348750', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:28:11.073+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 2.9, 70.5, 73.4, 73.5, 71.1, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A0800000100000001030000800100000007000000CDCCCCCC7EAA28419A9999D9560158419A999999995954409A9999997CAA2841333333F3570158419A999999995954400000000084AA28419A999939580158419A999999995954409A99999981AA284166666626590158419A99999999595440CDCCCCCC76AA2841666666C6580158419A99999999595440CDCCCCCC7BAA2841666666C6560158419A99999999595440CDCCCCCC7EAA28419A9999D9560158419A99999999595440', 'BATIMENT0000000314347611', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:25:52.795+02', '2018-02-20 11:33:35.732+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.8, 77.6, 81.4, 82.0, 77.6, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A080000010000000103000080010000000A00000000000000B6AB2841CDCCCC0C4A0458416666666666E64D400000000086AB2841000000404A0458416666666666E64D400000000085AB2841CDCCCCEC470458416666666666E64D40000000009CAB2841000000C0470458416666666666E64D400000000099AB2841CDCCCC6C430458416666666666E64D400000000094AB2841666666863F0458416666666666E64D4000000000BBAB2841666666463F0458416666666666E64D4066666666BBAB2841CDCCCCCC400458416666666666E64D40CDCCCCCCB5AB28419A9999D9400458416666666666E64D4000000000B6AB2841CDCCCC0C4A0458416666666666E64D40', 'BATIMENT0000000314340959', 'Indifférenciée', 'Indifférencié', NULL, false, 'En service', '2012-10-19 08:10:48.171+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 9.7, 50.1, 59.8, 61.8, 52.7, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_minimale_toit, altitude_maximale_toit, altitude_maximale_sol, origine_du_batiment, appariement_fichiers_fonciers) VALUES ('01060000A06A08000001000000010300008001000000050000009A9999992EAB2841000000C05903584100000000006051400000000021AB2841000000005A03584100000000006051409A99999920AB2841CDCCCC8C590358410000000000605140000000002EAB2841CDCCCC4C5903584100000000006051409A9999992EAB2841000000C0590358410000000000605140', 'BATIMENT0000000314341026', 'Indifférenciée', 'Indifférencié', NULL, true, 'En service', '2012-10-19 08:10:56.738+02', '2017-01-31 21:26:19.973+01', NULL, NULL, NULL, '', 'BDParcellaire recalée', 3.0, 'Interpolation bâti BDTopo', 2.5, NULL, NULL, NULL, NULL, 3.5, 66.0, 69.5, 70.7, 66.5, 'Cadastre', NULL);
INSERT INTO batiment (geom, cleabs, nature, usage_1, usage_2, construction_legere, etat_de_l_objet, date_creation, date_modification, date_d_apparition, date_de_confirmation, sources, identifiants_sources, methode_d_acquisition_planimetrique, precision_planimetrique, methode_d_acquisition_altimetrique, precision_altimetrique, nombre_de_logements, nombre_d_etages, materiaux_des_murs, materiaux_de_la_toiture, hauteur, altitude_minimale_sol, altitude_mini